/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"client_id", "client_secret", "code", "grant_type", "state"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthTokenGenerateRequest {
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_CODE = "code";
    private String code;
    public static final String JSON_PROPERTY_GRANT_TYPE = "grant_type";
    private String grantType = "authorization_code";
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public static OAuthTokenGenerateRequest init(String jsonData) throws Exception {
        return (OAuthTokenGenerateRequest)new ObjectMapper().readValue(jsonData, OAuthTokenGenerateRequest.class);
    }

    public static OAuthTokenGenerateRequest init(HashMap data) throws Exception {
        return (OAuthTokenGenerateRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), OAuthTokenGenerateRequest.class);
    }

    public OAuthTokenGenerateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthTokenGenerateRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nonnull
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuthTokenGenerateRequest code(String code) {
        this.code = code;
        return this;
    }

    @Nonnull
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCode(String code) {
        this.code = code;
    }

    public OAuthTokenGenerateRequest grantType(String grantType) {
        this.grantType = grantType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="grant_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGrantType() {
        return this.grantType;
    }

    @JsonProperty(value="grant_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public OAuthTokenGenerateRequest state(String state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthTokenGenerateRequest oauthTokenGenerateRequest = (OAuthTokenGenerateRequest)o;
        return Objects.equals(this.clientId, oauthTokenGenerateRequest.clientId) && Objects.equals(this.clientSecret, oauthTokenGenerateRequest.clientSecret) && Objects.equals(this.code, oauthTokenGenerateRequest.code) && Objects.equals(this.grantType, oauthTokenGenerateRequest.grantType) && Objects.equals(this.state, oauthTokenGenerateRequest.state);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.code, this.grantType, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthTokenGenerateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    grantType: ").append(this.toIndentedString(this.grantType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.clientSecret != null) {
                if (this.isFileTypeOrListOfFiles(this.clientSecret)) {
                    fileTypeFound = true;
                }
                if (this.clientSecret.getClass().equals(File.class) || this.clientSecret.getClass().equals(Integer.class) || this.clientSecret.getClass().equals(String.class) || this.clientSecret.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_SECRET, this.clientSecret);
                } else if (this.isListOfFile(this.clientSecret)) {
                    for (i = 0; i < this.getListSize(this.clientSecret); ++i) {
                        map.put("client_secret[" + i + "]", this.getFromList(this.clientSecret, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_SECRET, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientSecret));
                }
            }
            if (this.code != null) {
                if (this.isFileTypeOrListOfFiles(this.code)) {
                    fileTypeFound = true;
                }
                if (this.code.getClass().equals(File.class) || this.code.getClass().equals(Integer.class) || this.code.getClass().equals(String.class) || this.code.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CODE, this.code);
                } else if (this.isListOfFile(this.code)) {
                    for (i = 0; i < this.getListSize(this.code); ++i) {
                        map.put("code[" + i + "]", this.getFromList(this.code, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.code));
                }
            }
            if (this.grantType != null) {
                if (this.isFileTypeOrListOfFiles(this.grantType)) {
                    fileTypeFound = true;
                }
                if (this.grantType.getClass().equals(File.class) || this.grantType.getClass().equals(Integer.class) || this.grantType.getClass().equals(String.class) || this.grantType.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_GRANT_TYPE, this.grantType);
                } else if (this.isListOfFile(this.grantType)) {
                    for (i = 0; i < this.getListSize(this.grantType); ++i) {
                        map.put("grant_type[" + i + "]", this.getFromList(this.grantType, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_GRANT_TYPE, JSON.getDefault().getMapper().writeValueAsString((Object)this.grantType));
                }
            }
            if (this.state != null) {
                if (this.isFileTypeOrListOfFiles(this.state)) {
                    fileTypeFound = true;
                }
                if (this.state.getClass().equals(File.class) || this.state.getClass().equals(Integer.class) || this.state.getClass().equals(String.class) || this.state.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_STATE, this.state);
                } else if (this.isListOfFile(this.state)) {
                    for (i = 0; i < this.getListSize(this.state); ++i) {
                        map.put("state[" + i + "]", this.getFromList(this.state, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_STATE, JSON.getDefault().getMapper().writeValueAsString((Object)this.state));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

