/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data_uri"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FileResponseDataUri {
    public static final String JSON_PROPERTY_DATA_URI = "data_uri";
    private String dataUri;

    public static FileResponseDataUri init(String jsonData) throws Exception {
        return (FileResponseDataUri)new ObjectMapper().readValue(jsonData, FileResponseDataUri.class);
    }

    public static FileResponseDataUri init(HashMap data) throws Exception {
        return (FileResponseDataUri)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FileResponseDataUri.class);
    }

    public FileResponseDataUri dataUri(String dataUri) {
        this.dataUri = dataUri;
        return this;
    }

    @Nonnull
    @JsonProperty(value="data_uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDataUri() {
        return this.dataUri;
    }

    @JsonProperty(value="data_uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDataUri(String dataUri) {
        this.dataUri = dataUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileResponseDataUri fileResponseDataUri = (FileResponseDataUri)o;
        return Objects.equals(this.dataUri, fileResponseDataUri.dataUri);
    }

    public int hashCode() {
        return Objects.hash(this.dataUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileResponseDataUri {\n");
        sb.append("    dataUri: ").append(this.toIndentedString(this.dataUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            if (this.dataUri != null) {
                if (this.isFileTypeOrListOfFiles(this.dataUri)) {
                    fileTypeFound = true;
                }
                if (this.dataUri.getClass().equals(File.class) || this.dataUri.getClass().equals(Integer.class) || this.dataUri.getClass().equals(String.class) || this.dataUri.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_DATA_URI, this.dataUri);
                } else if (this.isListOfFile(this.dataUri)) {
                    for (int i = 0; i < this.getListSize(this.dataUri); ++i) {
                        map.put("data_uri[" + i + "]", this.getFromList(this.dataUri, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_DATA_URI, JSON.getDefault().getMapper().writeValueAsString((Object)this.dataUri));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

