/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"file_url", "expires_at"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FileResponse {
    public static final String JSON_PROPERTY_FILE_URL = "file_url";
    private String fileUrl;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private Integer expiresAt;

    public static FileResponse init(String jsonData) throws Exception {
        return (FileResponse)new ObjectMapper().readValue(jsonData, FileResponse.class);
    }

    public static FileResponse init(HashMap data) throws Exception {
        return (FileResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FileResponse.class);
    }

    public FileResponse fileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        return this;
    }

    @Nonnull
    @JsonProperty(value="file_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFileUrl() {
        return this.fileUrl;
    }

    @JsonProperty(value="file_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public FileResponse expiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nonnull
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpiresAt(Integer expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileResponse fileResponse = (FileResponse)o;
        return Objects.equals(this.fileUrl, fileResponse.fileUrl) && Objects.equals(this.expiresAt, fileResponse.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.fileUrl, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileResponse {\n");
        sb.append("    fileUrl: ").append(this.toIndentedString(this.fileUrl)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.fileUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.fileUrl)) {
                    fileTypeFound = true;
                }
                if (this.fileUrl.getClass().equals(File.class) || this.fileUrl.getClass().equals(Integer.class) || this.fileUrl.getClass().equals(String.class) || this.fileUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILE_URL, this.fileUrl);
                } else if (this.isListOfFile(this.fileUrl)) {
                    for (i = 0; i < this.getListSize(this.fileUrl); ++i) {
                        map.put("file_url[" + i + "]", this.getFromList(this.fileUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILE_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.fileUrl));
                }
            }
            if (this.expiresAt != null) {
                if (this.isFileTypeOrListOfFiles(this.expiresAt)) {
                    fileTypeFound = true;
                }
                if (this.expiresAt.getClass().equals(File.class) || this.expiresAt.getClass().equals(Integer.class) || this.expiresAt.getClass().equals(String.class) || this.expiresAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EXPIRES_AT, this.expiresAt);
                } else if (this.isListOfFile(this.expiresAt)) {
                    for (i = 0; i < this.getListSize(this.expiresAt); ++i) {
                        map.put("expires_at[" + i + "]", this.getFromList(this.expiresAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EXPIRES_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.expiresAt));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

