/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"recipient", "sender", "files", "file_urls", "test_mode", "cover_page_to", "cover_page_from", "cover_page_message", "title"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxSendRequest {
    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    private String recipient;
    public static final String JSON_PROPERTY_SENDER = "sender";
    private String sender;
    public static final String JSON_PROPERTY_FILES = "files";
    private List<File> files = null;
    public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
    private List<String> fileUrls = null;
    public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
    private Boolean testMode = false;
    public static final String JSON_PROPERTY_COVER_PAGE_TO = "cover_page_to";
    private String coverPageTo;
    public static final String JSON_PROPERTY_COVER_PAGE_FROM = "cover_page_from";
    private String coverPageFrom;
    public static final String JSON_PROPERTY_COVER_PAGE_MESSAGE = "cover_page_message";
    private String coverPageMessage;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;

    public static FaxSendRequest init(String jsonData) throws Exception {
        return (FaxSendRequest)new ObjectMapper().readValue(jsonData, FaxSendRequest.class);
    }

    public static FaxSendRequest init(HashMap data) throws Exception {
        return (FaxSendRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxSendRequest.class);
    }

    public FaxSendRequest recipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Nonnull
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public FaxSendRequest sender(String sender) {
        this.sender = sender;
        return this;
    }

    @Nullable
    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSender() {
        return this.sender;
    }

    @JsonProperty(value="sender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSender(String sender) {
        this.sender = sender;
    }

    public FaxSendRequest files(List<File> files) {
        this.files = files;
        return this;
    }

    public FaxSendRequest addFilesItem(File filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<File>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFiles(List<File> files) {
        this.files = files;
    }

    public FaxSendRequest fileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
        return this;
    }

    public FaxSendRequest addFileUrlsItem(String fileUrlsItem) {
        if (this.fileUrls == null) {
            this.fileUrls = new ArrayList<String>();
        }
        this.fileUrls.add(fileUrlsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    @JsonProperty(value="file_urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public FaxSendRequest testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTestMode() {
        return this.testMode;
    }

    @JsonProperty(value="test_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public FaxSendRequest coverPageTo(String coverPageTo) {
        this.coverPageTo = coverPageTo;
        return this;
    }

    @Nullable
    @JsonProperty(value="cover_page_to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCoverPageTo() {
        return this.coverPageTo;
    }

    @JsonProperty(value="cover_page_to")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoverPageTo(String coverPageTo) {
        this.coverPageTo = coverPageTo;
    }

    public FaxSendRequest coverPageFrom(String coverPageFrom) {
        this.coverPageFrom = coverPageFrom;
        return this;
    }

    @Nullable
    @JsonProperty(value="cover_page_from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCoverPageFrom() {
        return this.coverPageFrom;
    }

    @JsonProperty(value="cover_page_from")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoverPageFrom(String coverPageFrom) {
        this.coverPageFrom = coverPageFrom;
    }

    public FaxSendRequest coverPageMessage(String coverPageMessage) {
        this.coverPageMessage = coverPageMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="cover_page_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCoverPageMessage() {
        return this.coverPageMessage;
    }

    @JsonProperty(value="cover_page_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCoverPageMessage(String coverPageMessage) {
        this.coverPageMessage = coverPageMessage;
    }

    public FaxSendRequest title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxSendRequest faxSendRequest = (FaxSendRequest)o;
        return Objects.equals(this.recipient, faxSendRequest.recipient) && Objects.equals(this.sender, faxSendRequest.sender) && Objects.equals(this.files, faxSendRequest.files) && Objects.equals(this.fileUrls, faxSendRequest.fileUrls) && Objects.equals(this.testMode, faxSendRequest.testMode) && Objects.equals(this.coverPageTo, faxSendRequest.coverPageTo) && Objects.equals(this.coverPageFrom, faxSendRequest.coverPageFrom) && Objects.equals(this.coverPageMessage, faxSendRequest.coverPageMessage) && Objects.equals(this.title, faxSendRequest.title);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.sender, this.files, this.fileUrls, this.testMode, this.coverPageTo, this.coverPageFrom, this.coverPageMessage, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxSendRequest {\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    fileUrls: ").append(this.toIndentedString(this.fileUrls)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("    coverPageTo: ").append(this.toIndentedString(this.coverPageTo)).append("\n");
        sb.append("    coverPageFrom: ").append(this.toIndentedString(this.coverPageFrom)).append("\n");
        sb.append("    coverPageMessage: ").append(this.toIndentedString(this.coverPageMessage)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.recipient != null) {
                if (this.isFileTypeOrListOfFiles(this.recipient)) {
                    fileTypeFound = true;
                }
                if (this.recipient.getClass().equals(File.class) || this.recipient.getClass().equals(Integer.class) || this.recipient.getClass().equals(String.class) || this.recipient.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_RECIPIENT, this.recipient);
                } else if (this.isListOfFile(this.recipient)) {
                    for (i = 0; i < this.getListSize(this.recipient); ++i) {
                        map.put("recipient[" + i + "]", this.getFromList(this.recipient, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_RECIPIENT, JSON.getDefault().getMapper().writeValueAsString((Object)this.recipient));
                }
            }
            if (this.sender != null) {
                if (this.isFileTypeOrListOfFiles(this.sender)) {
                    fileTypeFound = true;
                }
                if (this.sender.getClass().equals(File.class) || this.sender.getClass().equals(Integer.class) || this.sender.getClass().equals(String.class) || this.sender.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SENDER, this.sender);
                } else if (this.isListOfFile(this.sender)) {
                    for (i = 0; i < this.getListSize(this.sender); ++i) {
                        map.put("sender[" + i + "]", this.getFromList(this.sender, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SENDER, JSON.getDefault().getMapper().writeValueAsString((Object)this.sender));
                }
            }
            if (this.files != null) {
                if (this.isFileTypeOrListOfFiles(this.files)) {
                    fileTypeFound = true;
                }
                if (this.files.getClass().equals(File.class) || this.files.getClass().equals(Integer.class) || this.files.getClass().equals(String.class) || this.files.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILES, this.files);
                } else if (this.isListOfFile(this.files)) {
                    for (i = 0; i < this.getListSize(this.files); ++i) {
                        map.put("files[" + i + "]", this.getFromList(this.files, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILES, JSON.getDefault().getMapper().writeValueAsString(this.files));
                }
            }
            if (this.fileUrls != null) {
                if (this.isFileTypeOrListOfFiles(this.fileUrls)) {
                    fileTypeFound = true;
                }
                if (this.fileUrls.getClass().equals(File.class) || this.fileUrls.getClass().equals(Integer.class) || this.fileUrls.getClass().equals(String.class) || this.fileUrls.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FILE_URLS, this.fileUrls);
                } else if (this.isListOfFile(this.fileUrls)) {
                    for (i = 0; i < this.getListSize(this.fileUrls); ++i) {
                        map.put("file_urls[" + i + "]", this.getFromList(this.fileUrls, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FILE_URLS, JSON.getDefault().getMapper().writeValueAsString(this.fileUrls));
                }
            }
            if (this.testMode != null) {
                if (this.isFileTypeOrListOfFiles(this.testMode)) {
                    fileTypeFound = true;
                }
                if (this.testMode.getClass().equals(File.class) || this.testMode.getClass().equals(Integer.class) || this.testMode.getClass().equals(String.class) || this.testMode.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEST_MODE, this.testMode);
                } else if (this.isListOfFile(this.testMode)) {
                    for (i = 0; i < this.getListSize(this.testMode); ++i) {
                        map.put("test_mode[" + i + "]", this.getFromList(this.testMode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEST_MODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.testMode));
                }
            }
            if (this.coverPageTo != null) {
                if (this.isFileTypeOrListOfFiles(this.coverPageTo)) {
                    fileTypeFound = true;
                }
                if (this.coverPageTo.getClass().equals(File.class) || this.coverPageTo.getClass().equals(Integer.class) || this.coverPageTo.getClass().equals(String.class) || this.coverPageTo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_COVER_PAGE_TO, this.coverPageTo);
                } else if (this.isListOfFile(this.coverPageTo)) {
                    for (i = 0; i < this.getListSize(this.coverPageTo); ++i) {
                        map.put("cover_page_to[" + i + "]", this.getFromList(this.coverPageTo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_COVER_PAGE_TO, JSON.getDefault().getMapper().writeValueAsString((Object)this.coverPageTo));
                }
            }
            if (this.coverPageFrom != null) {
                if (this.isFileTypeOrListOfFiles(this.coverPageFrom)) {
                    fileTypeFound = true;
                }
                if (this.coverPageFrom.getClass().equals(File.class) || this.coverPageFrom.getClass().equals(Integer.class) || this.coverPageFrom.getClass().equals(String.class) || this.coverPageFrom.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_COVER_PAGE_FROM, this.coverPageFrom);
                } else if (this.isListOfFile(this.coverPageFrom)) {
                    for (i = 0; i < this.getListSize(this.coverPageFrom); ++i) {
                        map.put("cover_page_from[" + i + "]", this.getFromList(this.coverPageFrom, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_COVER_PAGE_FROM, JSON.getDefault().getMapper().writeValueAsString((Object)this.coverPageFrom));
                }
            }
            if (this.coverPageMessage != null) {
                if (this.isFileTypeOrListOfFiles(this.coverPageMessage)) {
                    fileTypeFound = true;
                }
                if (this.coverPageMessage.getClass().equals(File.class) || this.coverPageMessage.getClass().equals(Integer.class) || this.coverPageMessage.getClass().equals(String.class) || this.coverPageMessage.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_COVER_PAGE_MESSAGE, this.coverPageMessage);
                } else if (this.isListOfFile(this.coverPageMessage)) {
                    for (i = 0; i < this.getListSize(this.coverPageMessage); ++i) {
                        map.put("cover_page_message[" + i + "]", this.getFromList(this.coverPageMessage, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_COVER_PAGE_MESSAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.coverPageMessage));
                }
            }
            if (this.title != null) {
                if (this.isFileTypeOrListOfFiles(this.title)) {
                    fileTypeFound = true;
                }
                if (this.title.getClass().equals(File.class) || this.title.getClass().equals(Integer.class) || this.title.getClass().equals(String.class) || this.title.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TITLE, this.title);
                } else if (this.isListOfFile(this.title)) {
                    for (i = 0; i < this.getListSize(this.title); ++i) {
                        map.put("title[" + i + "]", this.getFromList(this.title, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TITLE, JSON.getDefault().getMapper().writeValueAsString((Object)this.title));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

