/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.FaxLineResponseFaxLine;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"fax_line", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxLineResponse {
    public static final String JSON_PROPERTY_FAX_LINE = "fax_line";
    private FaxLineResponseFaxLine faxLine;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private WarningResponse warnings;

    public static FaxLineResponse init(String jsonData) throws Exception {
        return (FaxLineResponse)new ObjectMapper().readValue(jsonData, FaxLineResponse.class);
    }

    public static FaxLineResponse init(HashMap data) throws Exception {
        return (FaxLineResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxLineResponse.class);
    }

    public FaxLineResponse faxLine(FaxLineResponseFaxLine faxLine) {
        this.faxLine = faxLine;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fax_line")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FaxLineResponseFaxLine getFaxLine() {
        return this.faxLine;
    }

    @JsonProperty(value="fax_line")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFaxLine(FaxLineResponseFaxLine faxLine) {
        this.faxLine = faxLine;
    }

    public FaxLineResponse warnings(WarningResponse warnings) {
        this.warnings = warnings;
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WarningResponse getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(WarningResponse warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxLineResponse faxLineResponse = (FaxLineResponse)o;
        return Objects.equals(this.faxLine, faxLineResponse.faxLine) && Objects.equals(this.warnings, faxLineResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.faxLine, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxLineResponse {\n");
        sb.append("    faxLine: ").append(this.toIndentedString(this.faxLine)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.faxLine != null) {
                if (this.isFileTypeOrListOfFiles(this.faxLine)) {
                    fileTypeFound = true;
                }
                if (this.faxLine.getClass().equals(File.class) || this.faxLine.getClass().equals(Integer.class) || this.faxLine.getClass().equals(String.class) || this.faxLine.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FAX_LINE, this.faxLine);
                } else if (this.isListOfFile(this.faxLine)) {
                    for (i = 0; i < this.getListSize(this.faxLine); ++i) {
                        map.put("fax_line[" + i + "]", this.getFromList(this.faxLine, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FAX_LINE, JSON.getDefault().getMapper().writeValueAsString((Object)this.faxLine));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString((Object)this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

