/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"area_code", "country", "city", "account_id"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxLineCreateRequest {
    public static final String JSON_PROPERTY_AREA_CODE = "area_code";
    private Integer areaCode;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private CountryEnum country;
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;

    public static FaxLineCreateRequest init(String jsonData) throws Exception {
        return (FaxLineCreateRequest)new ObjectMapper().readValue(jsonData, FaxLineCreateRequest.class);
    }

    public static FaxLineCreateRequest init(HashMap data) throws Exception {
        return (FaxLineCreateRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxLineCreateRequest.class);
    }

    public FaxLineCreateRequest areaCode(Integer areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    @Nonnull
    @JsonProperty(value="area_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAreaCode() {
        return this.areaCode;
    }

    @JsonProperty(value="area_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAreaCode(Integer areaCode) {
        this.areaCode = areaCode;
    }

    public FaxLineCreateRequest country(CountryEnum country) {
        this.country = country;
        return this;
    }

    @Nonnull
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CountryEnum getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountry(CountryEnum country) {
        this.country = country;
    }

    public FaxLineCreateRequest city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public FaxLineCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxLineCreateRequest faxLineCreateRequest = (FaxLineCreateRequest)o;
        return Objects.equals(this.areaCode, faxLineCreateRequest.areaCode) && Objects.equals((Object)this.country, (Object)faxLineCreateRequest.country) && Objects.equals(this.city, faxLineCreateRequest.city) && Objects.equals(this.accountId, faxLineCreateRequest.accountId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.areaCode, this.country, this.city, this.accountId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxLineCreateRequest {\n");
        sb.append("    areaCode: ").append(this.toIndentedString(this.areaCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString((Object)this.country)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.areaCode != null) {
                if (this.isFileTypeOrListOfFiles(this.areaCode)) {
                    fileTypeFound = true;
                }
                if (this.areaCode.getClass().equals(File.class) || this.areaCode.getClass().equals(Integer.class) || this.areaCode.getClass().equals(String.class) || this.areaCode.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_AREA_CODE, this.areaCode);
                } else if (this.isListOfFile(this.areaCode)) {
                    for (i = 0; i < this.getListSize(this.areaCode); ++i) {
                        map.put("area_code[" + i + "]", this.getFromList(this.areaCode, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_AREA_CODE, JSON.getDefault().getMapper().writeValueAsString((Object)this.areaCode));
                }
            }
            if (this.country != null) {
                if (this.isFileTypeOrListOfFiles((Object)this.country)) {
                    fileTypeFound = true;
                }
                if (((Object)((Object)this.country)).getClass().equals(File.class) || ((Object)((Object)this.country)).getClass().equals(Integer.class) || ((Object)((Object)this.country)).getClass().equals(String.class) || ((Object)((Object)this.country)).getClass().isEnum()) {
                    map.put(JSON_PROPERTY_COUNTRY, (Object)this.country);
                } else if (this.isListOfFile((Object)this.country)) {
                    for (i = 0; i < this.getListSize((Object)this.country); ++i) {
                        map.put("country[" + i + "]", this.getFromList((Object)this.country, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_COUNTRY, JSON.getDefault().getMapper().writeValueAsString((Object)this.country));
                }
            }
            if (this.city != null) {
                if (this.isFileTypeOrListOfFiles(this.city)) {
                    fileTypeFound = true;
                }
                if (this.city.getClass().equals(File.class) || this.city.getClass().equals(Integer.class) || this.city.getClass().equals(String.class) || this.city.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CITY, this.city);
                } else if (this.isListOfFile(this.city)) {
                    for (i = 0; i < this.getListSize(this.city); ++i) {
                        map.put("city[" + i + "]", this.getFromList(this.city, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CITY, JSON.getDefault().getMapper().writeValueAsString((Object)this.city));
                }
            }
            if (this.accountId != null) {
                if (this.isFileTypeOrListOfFiles(this.accountId)) {
                    fileTypeFound = true;
                }
                if (this.accountId.getClass().equals(File.class) || this.accountId.getClass().equals(Integer.class) || this.accountId.getClass().equals(String.class) || this.accountId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, this.accountId);
                } else if (this.isListOfFile(this.accountId)) {
                    for (i = 0; i < this.getListSize(this.accountId); ++i) {
                        map.put("account_id[" + i + "]", this.getFromList(this.accountId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.accountId));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CountryEnum {
        CA("CA"),
        US("US"),
        UK("UK");

        private String value;

        private CountryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CountryEnum fromValue(String value) {
            for (CountryEnum b : CountryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

