/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"area_codes"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxLineAreaCodeGetResponse {
    public static final String JSON_PROPERTY_AREA_CODES = "area_codes";
    private List<Integer> areaCodes = new ArrayList<Integer>();

    public static FaxLineAreaCodeGetResponse init(String jsonData) throws Exception {
        return (FaxLineAreaCodeGetResponse)new ObjectMapper().readValue(jsonData, FaxLineAreaCodeGetResponse.class);
    }

    public static FaxLineAreaCodeGetResponse init(HashMap data) throws Exception {
        return (FaxLineAreaCodeGetResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), FaxLineAreaCodeGetResponse.class);
    }

    public FaxLineAreaCodeGetResponse areaCodes(List<Integer> areaCodes) {
        this.areaCodes = areaCodes;
        return this;
    }

    public FaxLineAreaCodeGetResponse addAreaCodesItem(Integer areaCodesItem) {
        if (this.areaCodes == null) {
            this.areaCodes = new ArrayList<Integer>();
        }
        this.areaCodes.add(areaCodesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="area_codes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Integer> getAreaCodes() {
        return this.areaCodes;
    }

    @JsonProperty(value="area_codes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAreaCodes(List<Integer> areaCodes) {
        this.areaCodes = areaCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxLineAreaCodeGetResponse faxLineAreaCodeGetResponse = (FaxLineAreaCodeGetResponse)o;
        return Objects.equals(this.areaCodes, faxLineAreaCodeGetResponse.areaCodes);
    }

    public int hashCode() {
        return Objects.hash(this.areaCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FaxLineAreaCodeGetResponse {\n");
        sb.append("    areaCodes: ").append(this.toIndentedString(this.areaCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            if (this.areaCodes != null) {
                if (this.isFileTypeOrListOfFiles(this.areaCodes)) {
                    fileTypeFound = true;
                }
                if (this.areaCodes.getClass().equals(File.class) || this.areaCodes.getClass().equals(Integer.class) || this.areaCodes.getClass().equals(String.class) || this.areaCodes.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_AREA_CODES, this.areaCodes);
                } else if (this.isListOfFile(this.areaCodes)) {
                    for (int i = 0; i < this.getListSize(this.areaCodes); ++i) {
                        map.put("area_codes[" + i + "]", this.getFromList(this.areaCodes, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_AREA_CODES, JSON.getDefault().getMapper().writeValueAsString(this.areaCodes));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

