/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"related_signature_id", "reported_for_account_id", "reported_for_app_id", "event_message"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class EventCallbackRequestEventMetadata {
    public static final String JSON_PROPERTY_RELATED_SIGNATURE_ID = "related_signature_id";
    private String relatedSignatureId;
    public static final String JSON_PROPERTY_REPORTED_FOR_ACCOUNT_ID = "reported_for_account_id";
    private String reportedForAccountId;
    public static final String JSON_PROPERTY_REPORTED_FOR_APP_ID = "reported_for_app_id";
    private String reportedForAppId;
    public static final String JSON_PROPERTY_EVENT_MESSAGE = "event_message";
    private String eventMessage;

    public static EventCallbackRequestEventMetadata init(String jsonData) throws Exception {
        return (EventCallbackRequestEventMetadata)new ObjectMapper().readValue(jsonData, EventCallbackRequestEventMetadata.class);
    }

    public static EventCallbackRequestEventMetadata init(HashMap data) throws Exception {
        return (EventCallbackRequestEventMetadata)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), EventCallbackRequestEventMetadata.class);
    }

    public EventCallbackRequestEventMetadata relatedSignatureId(String relatedSignatureId) {
        this.relatedSignatureId = relatedSignatureId;
        return this;
    }

    @Nullable
    @JsonProperty(value="related_signature_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRelatedSignatureId() {
        return this.relatedSignatureId;
    }

    @JsonProperty(value="related_signature_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelatedSignatureId(String relatedSignatureId) {
        this.relatedSignatureId = relatedSignatureId;
    }

    public EventCallbackRequestEventMetadata reportedForAccountId(String reportedForAccountId) {
        this.reportedForAccountId = reportedForAccountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="reported_for_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReportedForAccountId() {
        return this.reportedForAccountId;
    }

    @JsonProperty(value="reported_for_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReportedForAccountId(String reportedForAccountId) {
        this.reportedForAccountId = reportedForAccountId;
    }

    public EventCallbackRequestEventMetadata reportedForAppId(String reportedForAppId) {
        this.reportedForAppId = reportedForAppId;
        return this;
    }

    @Nullable
    @JsonProperty(value="reported_for_app_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReportedForAppId() {
        return this.reportedForAppId;
    }

    @JsonProperty(value="reported_for_app_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReportedForAppId(String reportedForAppId) {
        this.reportedForAppId = reportedForAppId;
    }

    public EventCallbackRequestEventMetadata eventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventMessage() {
        return this.eventMessage;
    }

    @JsonProperty(value="event_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCallbackRequestEventMetadata eventCallbackRequestEventMetadata = (EventCallbackRequestEventMetadata)o;
        return Objects.equals(this.relatedSignatureId, eventCallbackRequestEventMetadata.relatedSignatureId) && Objects.equals(this.reportedForAccountId, eventCallbackRequestEventMetadata.reportedForAccountId) && Objects.equals(this.reportedForAppId, eventCallbackRequestEventMetadata.reportedForAppId) && Objects.equals(this.eventMessage, eventCallbackRequestEventMetadata.eventMessage);
    }

    public int hashCode() {
        return Objects.hash(this.relatedSignatureId, this.reportedForAccountId, this.reportedForAppId, this.eventMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventCallbackRequestEventMetadata {\n");
        sb.append("    relatedSignatureId: ").append(this.toIndentedString(this.relatedSignatureId)).append("\n");
        sb.append("    reportedForAccountId: ").append(this.toIndentedString(this.reportedForAccountId)).append("\n");
        sb.append("    reportedForAppId: ").append(this.toIndentedString(this.reportedForAppId)).append("\n");
        sb.append("    eventMessage: ").append(this.toIndentedString(this.eventMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.relatedSignatureId != null) {
                if (this.isFileTypeOrListOfFiles(this.relatedSignatureId)) {
                    fileTypeFound = true;
                }
                if (this.relatedSignatureId.getClass().equals(File.class) || this.relatedSignatureId.getClass().equals(Integer.class) || this.relatedSignatureId.getClass().equals(String.class) || this.relatedSignatureId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_RELATED_SIGNATURE_ID, this.relatedSignatureId);
                } else if (this.isListOfFile(this.relatedSignatureId)) {
                    for (i = 0; i < this.getListSize(this.relatedSignatureId); ++i) {
                        map.put("related_signature_id[" + i + "]", this.getFromList(this.relatedSignatureId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_RELATED_SIGNATURE_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.relatedSignatureId));
                }
            }
            if (this.reportedForAccountId != null) {
                if (this.isFileTypeOrListOfFiles(this.reportedForAccountId)) {
                    fileTypeFound = true;
                }
                if (this.reportedForAccountId.getClass().equals(File.class) || this.reportedForAccountId.getClass().equals(Integer.class) || this.reportedForAccountId.getClass().equals(String.class) || this.reportedForAccountId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REPORTED_FOR_ACCOUNT_ID, this.reportedForAccountId);
                } else if (this.isListOfFile(this.reportedForAccountId)) {
                    for (i = 0; i < this.getListSize(this.reportedForAccountId); ++i) {
                        map.put("reported_for_account_id[" + i + "]", this.getFromList(this.reportedForAccountId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REPORTED_FOR_ACCOUNT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.reportedForAccountId));
                }
            }
            if (this.reportedForAppId != null) {
                if (this.isFileTypeOrListOfFiles(this.reportedForAppId)) {
                    fileTypeFound = true;
                }
                if (this.reportedForAppId.getClass().equals(File.class) || this.reportedForAppId.getClass().equals(Integer.class) || this.reportedForAppId.getClass().equals(String.class) || this.reportedForAppId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_REPORTED_FOR_APP_ID, this.reportedForAppId);
                } else if (this.isListOfFile(this.reportedForAppId)) {
                    for (i = 0; i < this.getListSize(this.reportedForAppId); ++i) {
                        map.put("reported_for_app_id[" + i + "]", this.getFromList(this.reportedForAppId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_REPORTED_FOR_APP_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.reportedForAppId));
                }
            }
            if (this.eventMessage != null) {
                if (this.isFileTypeOrListOfFiles(this.eventMessage)) {
                    fileTypeFound = true;
                }
                if (this.eventMessage.getClass().equals(File.class) || this.eventMessage.getClass().equals(Integer.class) || this.eventMessage.getClass().equals(String.class) || this.eventMessage.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EVENT_MESSAGE, this.eventMessage);
                } else if (this.isListOfFile(this.eventMessage)) {
                    for (i = 0; i < this.getListSize(this.eventMessage); ++i) {
                        map.put("event_message[" + i + "]", this.getFromList(this.eventMessage, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EVENT_MESSAGE, JSON.getDefault().getMapper().writeValueAsString((Object)this.eventMessage));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

