/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.AccountResponse;
import com.dropbox.sign.model.EventCallbackRequestEvent;
import com.dropbox.sign.model.SignatureRequestResponse;
import com.dropbox.sign.model.TemplateResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"event", "account", "signature_request", "template"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class EventCallbackRequest {
    public static final String JSON_PROPERTY_EVENT = "event";
    private EventCallbackRequestEvent event;
    public static final String JSON_PROPERTY_ACCOUNT = "account";
    private AccountResponse account;
    public static final String JSON_PROPERTY_SIGNATURE_REQUEST = "signature_request";
    private SignatureRequestResponse signatureRequest;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private TemplateResponse template;

    public static EventCallbackRequest init(String jsonData) throws Exception {
        return (EventCallbackRequest)new ObjectMapper().readValue(jsonData, EventCallbackRequest.class);
    }

    public static EventCallbackRequest init(HashMap data) throws Exception {
        return (EventCallbackRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), EventCallbackRequest.class);
    }

    public EventCallbackRequest event(EventCallbackRequestEvent event) {
        this.event = event;
        return this;
    }

    @Nonnull
    @JsonProperty(value="event")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EventCallbackRequestEvent getEvent() {
        return this.event;
    }

    @JsonProperty(value="event")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEvent(EventCallbackRequestEvent event) {
        this.event = event;
    }

    public EventCallbackRequest account(AccountResponse account) {
        this.account = account;
        return this;
    }

    @Nullable
    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountResponse getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccount(AccountResponse account) {
        this.account = account;
    }

    public EventCallbackRequest signatureRequest(SignatureRequestResponse signatureRequest) {
        this.signatureRequest = signatureRequest;
        return this;
    }

    @Nullable
    @JsonProperty(value="signature_request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SignatureRequestResponse getSignatureRequest() {
        return this.signatureRequest;
    }

    @JsonProperty(value="signature_request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatureRequest(SignatureRequestResponse signatureRequest) {
        this.signatureRequest = signatureRequest;
    }

    public EventCallbackRequest template(TemplateResponse template) {
        this.template = template;
        return this;
    }

    @Nullable
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TemplateResponse getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(TemplateResponse template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventCallbackRequest eventCallbackRequest = (EventCallbackRequest)o;
        return Objects.equals(this.event, eventCallbackRequest.event) && Objects.equals(this.account, eventCallbackRequest.account) && Objects.equals(this.signatureRequest, eventCallbackRequest.signatureRequest) && Objects.equals(this.template, eventCallbackRequest.template);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.account, this.signatureRequest, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventCallbackRequest {\n");
        sb.append("    event: ").append(this.toIndentedString(this.event)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    signatureRequest: ").append(this.toIndentedString(this.signatureRequest)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.event != null) {
                if (this.isFileTypeOrListOfFiles(this.event)) {
                    fileTypeFound = true;
                }
                if (this.event.getClass().equals(File.class) || this.event.getClass().equals(Integer.class) || this.event.getClass().equals(String.class) || this.event.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EVENT, this.event);
                } else if (this.isListOfFile(this.event)) {
                    for (i = 0; i < this.getListSize(this.event); ++i) {
                        map.put("event[" + i + "]", this.getFromList(this.event, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EVENT, JSON.getDefault().getMapper().writeValueAsString((Object)this.event));
                }
            }
            if (this.account != null) {
                if (this.isFileTypeOrListOfFiles(this.account)) {
                    fileTypeFound = true;
                }
                if (this.account.getClass().equals(File.class) || this.account.getClass().equals(Integer.class) || this.account.getClass().equals(String.class) || this.account.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ACCOUNT, this.account);
                } else if (this.isListOfFile(this.account)) {
                    for (i = 0; i < this.getListSize(this.account); ++i) {
                        map.put("account[" + i + "]", this.getFromList(this.account, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ACCOUNT, JSON.getDefault().getMapper().writeValueAsString((Object)this.account));
                }
            }
            if (this.signatureRequest != null) {
                if (this.isFileTypeOrListOfFiles(this.signatureRequest)) {
                    fileTypeFound = true;
                }
                if (this.signatureRequest.getClass().equals(File.class) || this.signatureRequest.getClass().equals(Integer.class) || this.signatureRequest.getClass().equals(String.class) || this.signatureRequest.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_SIGNATURE_REQUEST, this.signatureRequest);
                } else if (this.isListOfFile(this.signatureRequest)) {
                    for (i = 0; i < this.getListSize(this.signatureRequest); ++i) {
                        map.put("signature_request[" + i + "]", this.getFromList(this.signatureRequest, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_SIGNATURE_REQUEST, JSON.getDefault().getMapper().writeValueAsString((Object)this.signatureRequest));
                }
            }
            if (this.template != null) {
                if (this.isFileTypeOrListOfFiles(this.template)) {
                    fileTypeFound = true;
                }
                if (this.template.getClass().equals(File.class) || this.template.getClass().equals(Integer.class) || this.template.getClass().equals(String.class) || this.template.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TEMPLATE, this.template);
                } else if (this.isListOfFile(this.template)) {
                    for (i = 0; i < this.getListSize(this.template); ++i) {
                        map.put("template[" + i + "]", this.getFromList(this.template, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TEMPLATE, JSON.getDefault().getMapper().writeValueAsString((Object)this.template));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

