/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"error_msg", "error_name", "error_path"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorResponseError {
    public static final String JSON_PROPERTY_ERROR_MSG = "error_msg";
    private String errorMsg;
    public static final String JSON_PROPERTY_ERROR_NAME = "error_name";
    private String errorName;
    public static final String JSON_PROPERTY_ERROR_PATH = "error_path";
    private String errorPath;

    public static ErrorResponseError init(String jsonData) throws Exception {
        return (ErrorResponseError)new ObjectMapper().readValue(jsonData, ErrorResponseError.class);
    }

    public static ErrorResponseError init(HashMap data) throws Exception {
        return (ErrorResponseError)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ErrorResponseError.class);
    }

    public ErrorResponseError errorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    @Nonnull
    @JsonProperty(value="error_msg")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @JsonProperty(value="error_msg")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public ErrorResponseError errorName(String errorName) {
        this.errorName = errorName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="error_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getErrorName() {
        return this.errorName;
    }

    @JsonProperty(value="error_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setErrorName(String errorName) {
        this.errorName = errorName;
    }

    public ErrorResponseError errorPath(String errorPath) {
        this.errorPath = errorPath;
        return this;
    }

    @Nullable
    @JsonProperty(value="error_path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorPath() {
        return this.errorPath;
    }

    @JsonProperty(value="error_path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorPath(String errorPath) {
        this.errorPath = errorPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponseError errorResponseError = (ErrorResponseError)o;
        return Objects.equals(this.errorMsg, errorResponseError.errorMsg) && Objects.equals(this.errorName, errorResponseError.errorName) && Objects.equals(this.errorPath, errorResponseError.errorPath);
    }

    public int hashCode() {
        return Objects.hash(this.errorMsg, this.errorName, this.errorPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorResponseError {\n");
        sb.append("    errorMsg: ").append(this.toIndentedString(this.errorMsg)).append("\n");
        sb.append("    errorName: ").append(this.toIndentedString(this.errorName)).append("\n");
        sb.append("    errorPath: ").append(this.toIndentedString(this.errorPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.errorMsg != null) {
                if (this.isFileTypeOrListOfFiles(this.errorMsg)) {
                    fileTypeFound = true;
                }
                if (this.errorMsg.getClass().equals(File.class) || this.errorMsg.getClass().equals(Integer.class) || this.errorMsg.getClass().equals(String.class) || this.errorMsg.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ERROR_MSG, this.errorMsg);
                } else if (this.isListOfFile(this.errorMsg)) {
                    for (i = 0; i < this.getListSize(this.errorMsg); ++i) {
                        map.put("error_msg[" + i + "]", this.getFromList(this.errorMsg, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ERROR_MSG, JSON.getDefault().getMapper().writeValueAsString((Object)this.errorMsg));
                }
            }
            if (this.errorName != null) {
                if (this.isFileTypeOrListOfFiles(this.errorName)) {
                    fileTypeFound = true;
                }
                if (this.errorName.getClass().equals(File.class) || this.errorName.getClass().equals(Integer.class) || this.errorName.getClass().equals(String.class) || this.errorName.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ERROR_NAME, this.errorName);
                } else if (this.isListOfFile(this.errorName)) {
                    for (i = 0; i < this.getListSize(this.errorName); ++i) {
                        map.put("error_name[" + i + "]", this.getFromList(this.errorName, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ERROR_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.errorName));
                }
            }
            if (this.errorPath != null) {
                if (this.isFileTypeOrListOfFiles(this.errorPath)) {
                    fileTypeFound = true;
                }
                if (this.errorPath.getClass().equals(File.class) || this.errorPath.getClass().equals(Integer.class) || this.errorPath.getClass().equals(String.class) || this.errorPath.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_ERROR_PATH, this.errorPath);
                } else if (this.isListOfFile(this.errorPath)) {
                    for (i = 0; i < this.getListSize(this.errorPath); ++i) {
                        map.put("error_path[" + i + "]", this.getFromList(this.errorPath, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_ERROR_PATH, JSON.getDefault().getMapper().writeValueAsString((Object)this.errorPath));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

