/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"bulk_send_job_id", "total", "is_creator", "created_at"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class BulkSendJobResponse {
    public static final String JSON_PROPERTY_BULK_SEND_JOB_ID = "bulk_send_job_id";
    private String bulkSendJobId;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Integer total;
    public static final String JSON_PROPERTY_IS_CREATOR = "is_creator";
    private Boolean isCreator;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Integer createdAt;

    public static BulkSendJobResponse init(String jsonData) throws Exception {
        return (BulkSendJobResponse)new ObjectMapper().readValue(jsonData, BulkSendJobResponse.class);
    }

    public static BulkSendJobResponse init(HashMap data) throws Exception {
        return (BulkSendJobResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), BulkSendJobResponse.class);
    }

    public BulkSendJobResponse bulkSendJobId(String bulkSendJobId) {
        this.bulkSendJobId = bulkSendJobId;
        return this;
    }

    @Nullable
    @JsonProperty(value="bulk_send_job_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBulkSendJobId() {
        return this.bulkSendJobId;
    }

    @JsonProperty(value="bulk_send_job_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBulkSendJobId(String bulkSendJobId) {
        this.bulkSendJobId = bulkSendJobId;
    }

    public BulkSendJobResponse total(Integer total) {
        this.total = total;
        return this;
    }

    @Nullable
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotal(Integer total) {
        this.total = total;
    }

    public BulkSendJobResponse isCreator(Boolean isCreator) {
        this.isCreator = isCreator;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCreator() {
        return this.isCreator;
    }

    @JsonProperty(value="is_creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsCreator(Boolean isCreator) {
        this.isCreator = isCreator;
    }

    public BulkSendJobResponse createdAt(Integer createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkSendJobResponse bulkSendJobResponse = (BulkSendJobResponse)o;
        return Objects.equals(this.bulkSendJobId, bulkSendJobResponse.bulkSendJobId) && Objects.equals(this.total, bulkSendJobResponse.total) && Objects.equals(this.isCreator, bulkSendJobResponse.isCreator) && Objects.equals(this.createdAt, bulkSendJobResponse.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.bulkSendJobId, this.total, this.isCreator, this.createdAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkSendJobResponse {\n");
        sb.append("    bulkSendJobId: ").append(this.toIndentedString(this.bulkSendJobId)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    isCreator: ").append(this.toIndentedString(this.isCreator)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.bulkSendJobId != null) {
                if (this.isFileTypeOrListOfFiles(this.bulkSendJobId)) {
                    fileTypeFound = true;
                }
                if (this.bulkSendJobId.getClass().equals(File.class) || this.bulkSendJobId.getClass().equals(Integer.class) || this.bulkSendJobId.getClass().equals(String.class) || this.bulkSendJobId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_BULK_SEND_JOB_ID, this.bulkSendJobId);
                } else if (this.isListOfFile(this.bulkSendJobId)) {
                    for (i = 0; i < this.getListSize(this.bulkSendJobId); ++i) {
                        map.put("bulk_send_job_id[" + i + "]", this.getFromList(this.bulkSendJobId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_BULK_SEND_JOB_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.bulkSendJobId));
                }
            }
            if (this.total != null) {
                if (this.isFileTypeOrListOfFiles(this.total)) {
                    fileTypeFound = true;
                }
                if (this.total.getClass().equals(File.class) || this.total.getClass().equals(Integer.class) || this.total.getClass().equals(String.class) || this.total.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_TOTAL, this.total);
                } else if (this.isListOfFile(this.total)) {
                    for (i = 0; i < this.getListSize(this.total); ++i) {
                        map.put("total[" + i + "]", this.getFromList(this.total, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_TOTAL, JSON.getDefault().getMapper().writeValueAsString((Object)this.total));
                }
            }
            if (this.isCreator != null) {
                if (this.isFileTypeOrListOfFiles(this.isCreator)) {
                    fileTypeFound = true;
                }
                if (this.isCreator.getClass().equals(File.class) || this.isCreator.getClass().equals(Integer.class) || this.isCreator.getClass().equals(String.class) || this.isCreator.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_CREATOR, this.isCreator);
                } else if (this.isListOfFile(this.isCreator)) {
                    for (i = 0; i < this.getListSize(this.isCreator); ++i) {
                        map.put("is_creator[" + i + "]", this.getFromList(this.isCreator, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_CREATOR, JSON.getDefault().getMapper().writeValueAsString((Object)this.isCreator));
                }
            }
            if (this.createdAt != null) {
                if (this.isFileTypeOrListOfFiles(this.createdAt)) {
                    fileTypeFound = true;
                }
                if (this.createdAt.getClass().equals(File.class) || this.createdAt.getClass().equals(Integer.class) || this.createdAt.getClass().equals(String.class) || this.createdAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CREATED_AT, this.createdAt);
                } else if (this.isListOfFile(this.createdAt)) {
                    for (i = 0; i < this.getListSize(this.createdAt); ++i) {
                        map.put("created_at[" + i + "]", this.getFromList(this.createdAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CREATED_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.createdAt));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

