/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.BulkSendJobResponse;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"bulk_send_jobs", "list_info", "warnings"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class BulkSendJobListResponse {
    public static final String JSON_PROPERTY_BULK_SEND_JOBS = "bulk_send_jobs";
    private List<BulkSendJobResponse> bulkSendJobs = new ArrayList<BulkSendJobResponse>();
    public static final String JSON_PROPERTY_LIST_INFO = "list_info";
    private ListInfoResponse listInfo;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<WarningResponse> warnings = null;

    public static BulkSendJobListResponse init(String jsonData) throws Exception {
        return (BulkSendJobListResponse)new ObjectMapper().readValue(jsonData, BulkSendJobListResponse.class);
    }

    public static BulkSendJobListResponse init(HashMap data) throws Exception {
        return (BulkSendJobListResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), BulkSendJobListResponse.class);
    }

    public BulkSendJobListResponse bulkSendJobs(List<BulkSendJobResponse> bulkSendJobs) {
        this.bulkSendJobs = bulkSendJobs;
        return this;
    }

    public BulkSendJobListResponse addBulkSendJobsItem(BulkSendJobResponse bulkSendJobsItem) {
        if (this.bulkSendJobs == null) {
            this.bulkSendJobs = new ArrayList<BulkSendJobResponse>();
        }
        this.bulkSendJobs.add(bulkSendJobsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="bulk_send_jobs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BulkSendJobResponse> getBulkSendJobs() {
        return this.bulkSendJobs;
    }

    @JsonProperty(value="bulk_send_jobs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBulkSendJobs(List<BulkSendJobResponse> bulkSendJobs) {
        this.bulkSendJobs = bulkSendJobs;
    }

    public BulkSendJobListResponse listInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
        return this;
    }

    @Nonnull
    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListInfoResponse getListInfo() {
        return this.listInfo;
    }

    @JsonProperty(value="list_info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListInfo(ListInfoResponse listInfo) {
        this.listInfo = listInfo;
    }

    public BulkSendJobListResponse warnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
        return this;
    }

    public BulkSendJobListResponse addWarningsItem(WarningResponse warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<WarningResponse>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WarningResponse> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWarnings(List<WarningResponse> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkSendJobListResponse bulkSendJobListResponse = (BulkSendJobListResponse)o;
        return Objects.equals(this.bulkSendJobs, bulkSendJobListResponse.bulkSendJobs) && Objects.equals(this.listInfo, bulkSendJobListResponse.listInfo) && Objects.equals(this.warnings, bulkSendJobListResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.bulkSendJobs, this.listInfo, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkSendJobListResponse {\n");
        sb.append("    bulkSendJobs: ").append(this.toIndentedString(this.bulkSendJobs)).append("\n");
        sb.append("    listInfo: ").append(this.toIndentedString(this.listInfo)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.bulkSendJobs != null) {
                if (this.isFileTypeOrListOfFiles(this.bulkSendJobs)) {
                    fileTypeFound = true;
                }
                if (this.bulkSendJobs.getClass().equals(File.class) || this.bulkSendJobs.getClass().equals(Integer.class) || this.bulkSendJobs.getClass().equals(String.class) || this.bulkSendJobs.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_BULK_SEND_JOBS, this.bulkSendJobs);
                } else if (this.isListOfFile(this.bulkSendJobs)) {
                    for (i = 0; i < this.getListSize(this.bulkSendJobs); ++i) {
                        map.put("bulk_send_jobs[" + i + "]", this.getFromList(this.bulkSendJobs, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_BULK_SEND_JOBS, JSON.getDefault().getMapper().writeValueAsString(this.bulkSendJobs));
                }
            }
            if (this.listInfo != null) {
                if (this.isFileTypeOrListOfFiles(this.listInfo)) {
                    fileTypeFound = true;
                }
                if (this.listInfo.getClass().equals(File.class) || this.listInfo.getClass().equals(Integer.class) || this.listInfo.getClass().equals(String.class) || this.listInfo.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LIST_INFO, this.listInfo);
                } else if (this.isListOfFile(this.listInfo)) {
                    for (i = 0; i < this.getListSize(this.listInfo); ++i) {
                        map.put("list_info[" + i + "]", this.getFromList(this.listInfo, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LIST_INFO, JSON.getDefault().getMapper().writeValueAsString((Object)this.listInfo));
                }
            }
            if (this.warnings != null) {
                if (this.isFileTypeOrListOfFiles(this.warnings)) {
                    fileTypeFound = true;
                }
                if (this.warnings.getClass().equals(File.class) || this.warnings.getClass().equals(Integer.class) || this.warnings.getClass().equals(String.class) || this.warnings.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WARNINGS, this.warnings);
                } else if (this.isListOfFile(this.warnings)) {
                    for (i = 0; i < this.getListSize(this.warnings); ++i) {
                        map.put("warnings[" + i + "]", this.getFromList(this.warnings, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WARNINGS, JSON.getDefault().getMapper().writeValueAsString(this.warnings));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

