/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.dropbox.sign.model.ApiAppResponseOAuth;
import com.dropbox.sign.model.ApiAppResponseOptions;
import com.dropbox.sign.model.ApiAppResponseOwnerAccount;
import com.dropbox.sign.model.ApiAppResponseWhiteLabelingOptions;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"callback_url", "client_id", "created_at", "domains", "name", "is_approved", "oauth", "options", "owner_account", "white_labeling_options"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiAppResponse {
    public static final String JSON_PROPERTY_CALLBACK_URL = "callback_url";
    private String callbackUrl;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Integer createdAt;
    public static final String JSON_PROPERTY_DOMAINS = "domains";
    private List<String> domains = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_IS_APPROVED = "is_approved";
    private Boolean isApproved;
    public static final String JSON_PROPERTY_OAUTH = "oauth";
    private ApiAppResponseOAuth oauth;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private ApiAppResponseOptions options;
    public static final String JSON_PROPERTY_OWNER_ACCOUNT = "owner_account";
    private ApiAppResponseOwnerAccount ownerAccount;
    public static final String JSON_PROPERTY_WHITE_LABELING_OPTIONS = "white_labeling_options";
    private ApiAppResponseWhiteLabelingOptions whiteLabelingOptions;

    public static ApiAppResponse init(String jsonData) throws Exception {
        return (ApiAppResponse)new ObjectMapper().readValue(jsonData, ApiAppResponse.class);
    }

    public static ApiAppResponse init(HashMap data) throws Exception {
        return (ApiAppResponse)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), ApiAppResponse.class);
    }

    public ApiAppResponse callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callback_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApiAppResponse clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ApiAppResponse createdAt(Integer createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public ApiAppResponse domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public ApiAppResponse addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public ApiAppResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiAppResponse isApproved(Boolean isApproved) {
        this.isApproved = isApproved;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_approved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsApproved() {
        return this.isApproved;
    }

    @JsonProperty(value="is_approved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsApproved(Boolean isApproved) {
        this.isApproved = isApproved;
    }

    public ApiAppResponse oauth(ApiAppResponseOAuth oauth) {
        this.oauth = oauth;
        return this;
    }

    @Nullable
    @JsonProperty(value="oauth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiAppResponseOAuth getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="oauth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOauth(ApiAppResponseOAuth oauth) {
        this.oauth = oauth;
    }

    public ApiAppResponse options(ApiAppResponseOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiAppResponseOptions getOptions() {
        return this.options;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOptions(ApiAppResponseOptions options) {
        this.options = options;
    }

    public ApiAppResponse ownerAccount(ApiAppResponseOwnerAccount ownerAccount) {
        this.ownerAccount = ownerAccount;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiAppResponseOwnerAccount getOwnerAccount() {
        return this.ownerAccount;
    }

    @JsonProperty(value="owner_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerAccount(ApiAppResponseOwnerAccount ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public ApiAppResponse whiteLabelingOptions(ApiAppResponseWhiteLabelingOptions whiteLabelingOptions) {
        this.whiteLabelingOptions = whiteLabelingOptions;
        return this;
    }

    @Nullable
    @JsonProperty(value="white_labeling_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiAppResponseWhiteLabelingOptions getWhiteLabelingOptions() {
        return this.whiteLabelingOptions;
    }

    @JsonProperty(value="white_labeling_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWhiteLabelingOptions(ApiAppResponseWhiteLabelingOptions whiteLabelingOptions) {
        this.whiteLabelingOptions = whiteLabelingOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAppResponse apiAppResponse = (ApiAppResponse)o;
        return Objects.equals(this.callbackUrl, apiAppResponse.callbackUrl) && Objects.equals(this.clientId, apiAppResponse.clientId) && Objects.equals(this.createdAt, apiAppResponse.createdAt) && Objects.equals(this.domains, apiAppResponse.domains) && Objects.equals(this.name, apiAppResponse.name) && Objects.equals(this.isApproved, apiAppResponse.isApproved) && Objects.equals(this.oauth, apiAppResponse.oauth) && Objects.equals(this.options, apiAppResponse.options) && Objects.equals(this.ownerAccount, apiAppResponse.ownerAccount) && Objects.equals(this.whiteLabelingOptions, apiAppResponse.whiteLabelingOptions);
    }

    public int hashCode() {
        return Objects.hash(this.callbackUrl, this.clientId, this.createdAt, this.domains, this.name, this.isApproved, this.oauth, this.options, this.ownerAccount, this.whiteLabelingOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAppResponse {\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isApproved: ").append(this.toIndentedString(this.isApproved)).append("\n");
        sb.append("    oauth: ").append(this.toIndentedString(this.oauth)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    ownerAccount: ").append(this.toIndentedString(this.ownerAccount)).append("\n");
        sb.append("    whiteLabelingOptions: ").append(this.toIndentedString(this.whiteLabelingOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.callbackUrl != null) {
                if (this.isFileTypeOrListOfFiles(this.callbackUrl)) {
                    fileTypeFound = true;
                }
                if (this.callbackUrl.getClass().equals(File.class) || this.callbackUrl.getClass().equals(Integer.class) || this.callbackUrl.getClass().equals(String.class) || this.callbackUrl.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CALLBACK_URL, this.callbackUrl);
                } else if (this.isListOfFile(this.callbackUrl)) {
                    for (i = 0; i < this.getListSize(this.callbackUrl); ++i) {
                        map.put("callback_url[" + i + "]", this.getFromList(this.callbackUrl, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CALLBACK_URL, JSON.getDefault().getMapper().writeValueAsString((Object)this.callbackUrl));
                }
            }
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.createdAt != null) {
                if (this.isFileTypeOrListOfFiles(this.createdAt)) {
                    fileTypeFound = true;
                }
                if (this.createdAt.getClass().equals(File.class) || this.createdAt.getClass().equals(Integer.class) || this.createdAt.getClass().equals(String.class) || this.createdAt.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CREATED_AT, this.createdAt);
                } else if (this.isListOfFile(this.createdAt)) {
                    for (i = 0; i < this.getListSize(this.createdAt); ++i) {
                        map.put("created_at[" + i + "]", this.getFromList(this.createdAt, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CREATED_AT, JSON.getDefault().getMapper().writeValueAsString((Object)this.createdAt));
                }
            }
            if (this.domains != null) {
                if (this.isFileTypeOrListOfFiles(this.domains)) {
                    fileTypeFound = true;
                }
                if (this.domains.getClass().equals(File.class) || this.domains.getClass().equals(Integer.class) || this.domains.getClass().equals(String.class) || this.domains.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_DOMAINS, this.domains);
                } else if (this.isListOfFile(this.domains)) {
                    for (i = 0; i < this.getListSize(this.domains); ++i) {
                        map.put("domains[" + i + "]", this.getFromList(this.domains, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_DOMAINS, JSON.getDefault().getMapper().writeValueAsString(this.domains));
                }
            }
            if (this.name != null) {
                if (this.isFileTypeOrListOfFiles(this.name)) {
                    fileTypeFound = true;
                }
                if (this.name.getClass().equals(File.class) || this.name.getClass().equals(Integer.class) || this.name.getClass().equals(String.class) || this.name.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_NAME, this.name);
                } else if (this.isListOfFile(this.name)) {
                    for (i = 0; i < this.getListSize(this.name); ++i) {
                        map.put("name[" + i + "]", this.getFromList(this.name, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_NAME, JSON.getDefault().getMapper().writeValueAsString((Object)this.name));
                }
            }
            if (this.isApproved != null) {
                if (this.isFileTypeOrListOfFiles(this.isApproved)) {
                    fileTypeFound = true;
                }
                if (this.isApproved.getClass().equals(File.class) || this.isApproved.getClass().equals(Integer.class) || this.isApproved.getClass().equals(String.class) || this.isApproved.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_IS_APPROVED, this.isApproved);
                } else if (this.isListOfFile(this.isApproved)) {
                    for (i = 0; i < this.getListSize(this.isApproved); ++i) {
                        map.put("is_approved[" + i + "]", this.getFromList(this.isApproved, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_IS_APPROVED, JSON.getDefault().getMapper().writeValueAsString((Object)this.isApproved));
                }
            }
            if (this.oauth != null) {
                if (this.isFileTypeOrListOfFiles(this.oauth)) {
                    fileTypeFound = true;
                }
                if (this.oauth.getClass().equals(File.class) || this.oauth.getClass().equals(Integer.class) || this.oauth.getClass().equals(String.class) || this.oauth.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_OAUTH, this.oauth);
                } else if (this.isListOfFile(this.oauth)) {
                    for (i = 0; i < this.getListSize(this.oauth); ++i) {
                        map.put("oauth[" + i + "]", this.getFromList(this.oauth, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_OAUTH, JSON.getDefault().getMapper().writeValueAsString((Object)this.oauth));
                }
            }
            if (this.options != null) {
                if (this.isFileTypeOrListOfFiles(this.options)) {
                    fileTypeFound = true;
                }
                if (this.options.getClass().equals(File.class) || this.options.getClass().equals(Integer.class) || this.options.getClass().equals(String.class) || this.options.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_OPTIONS, this.options);
                } else if (this.isListOfFile(this.options)) {
                    for (i = 0; i < this.getListSize(this.options); ++i) {
                        map.put("options[" + i + "]", this.getFromList(this.options, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.options));
                }
            }
            if (this.ownerAccount != null) {
                if (this.isFileTypeOrListOfFiles(this.ownerAccount)) {
                    fileTypeFound = true;
                }
                if (this.ownerAccount.getClass().equals(File.class) || this.ownerAccount.getClass().equals(Integer.class) || this.ownerAccount.getClass().equals(String.class) || this.ownerAccount.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_OWNER_ACCOUNT, this.ownerAccount);
                } else if (this.isListOfFile(this.ownerAccount)) {
                    for (i = 0; i < this.getListSize(this.ownerAccount); ++i) {
                        map.put("owner_account[" + i + "]", this.getFromList(this.ownerAccount, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_OWNER_ACCOUNT, JSON.getDefault().getMapper().writeValueAsString((Object)this.ownerAccount));
                }
            }
            if (this.whiteLabelingOptions != null) {
                if (this.isFileTypeOrListOfFiles(this.whiteLabelingOptions)) {
                    fileTypeFound = true;
                }
                if (this.whiteLabelingOptions.getClass().equals(File.class) || this.whiteLabelingOptions.getClass().equals(Integer.class) || this.whiteLabelingOptions.getClass().equals(String.class) || this.whiteLabelingOptions.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_WHITE_LABELING_OPTIONS, this.whiteLabelingOptions);
                } else if (this.isListOfFile(this.whiteLabelingOptions)) {
                    for (i = 0; i < this.getListSize(this.whiteLabelingOptions); ++i) {
                        map.put("white_labeling_options[" + i + "]", this.getFromList(this.whiteLabelingOptions, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_WHITE_LABELING_OPTIONS, JSON.getDefault().getMapper().writeValueAsString((Object)this.whiteLabelingOptions));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

