/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"email_address"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountVerifyRequest {
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;

    public static AccountVerifyRequest init(String jsonData) throws Exception {
        return (AccountVerifyRequest)new ObjectMapper().readValue(jsonData, AccountVerifyRequest.class);
    }

    public static AccountVerifyRequest init(HashMap data) throws Exception {
        return (AccountVerifyRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), AccountVerifyRequest.class);
    }

    public AccountVerifyRequest emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountVerifyRequest accountVerifyRequest = (AccountVerifyRequest)o;
        return Objects.equals(this.emailAddress, accountVerifyRequest.emailAddress);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountVerifyRequest {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (int i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

