/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"fax_pages_sent"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountResponseUsage {
    public static final String JSON_PROPERTY_FAX_PAGES_SENT = "fax_pages_sent";
    private Integer faxPagesSent;

    public static AccountResponseUsage init(String jsonData) throws Exception {
        return (AccountResponseUsage)new ObjectMapper().readValue(jsonData, AccountResponseUsage.class);
    }

    public static AccountResponseUsage init(HashMap data) throws Exception {
        return (AccountResponseUsage)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), AccountResponseUsage.class);
    }

    public AccountResponseUsage faxPagesSent(Integer faxPagesSent) {
        this.faxPagesSent = faxPagesSent;
        return this;
    }

    @Nullable
    @JsonProperty(value="fax_pages_sent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFaxPagesSent() {
        return this.faxPagesSent;
    }

    @JsonProperty(value="fax_pages_sent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFaxPagesSent(Integer faxPagesSent) {
        this.faxPagesSent = faxPagesSent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountResponseUsage accountResponseUsage = (AccountResponseUsage)o;
        return Objects.equals(this.faxPagesSent, accountResponseUsage.faxPagesSent);
    }

    public int hashCode() {
        return Objects.hash(this.faxPagesSent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountResponseUsage {\n");
        sb.append("    faxPagesSent: ").append(this.toIndentedString(this.faxPagesSent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            if (this.faxPagesSent != null) {
                if (this.isFileTypeOrListOfFiles(this.faxPagesSent)) {
                    fileTypeFound = true;
                }
                if (this.faxPagesSent.getClass().equals(File.class) || this.faxPagesSent.getClass().equals(Integer.class) || this.faxPagesSent.getClass().equals(String.class) || this.faxPagesSent.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_FAX_PAGES_SENT, this.faxPagesSent);
                } else if (this.isListOfFile(this.faxPagesSent)) {
                    for (int i = 0; i < this.getListSize(this.faxPagesSent); ++i) {
                        map.put("fax_pages_sent[" + i + "]", this.getFromList(this.faxPagesSent, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_FAX_PAGES_SENT, JSON.getDefault().getMapper().writeValueAsString((Object)this.faxPagesSent));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

