/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.model;

import com.dropbox.sign.ApiException;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"email_address", "client_id", "client_secret", "locale"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountCreateRequest {
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "email_address";
    private String emailAddress;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;

    public static AccountCreateRequest init(String jsonData) throws Exception {
        return (AccountCreateRequest)new ObjectMapper().readValue(jsonData, AccountCreateRequest.class);
    }

    public static AccountCreateRequest init(HashMap data) throws Exception {
        return (AccountCreateRequest)new ObjectMapper().readValue(new ObjectMapper().writeValueAsString((Object)data), AccountCreateRequest.class);
    }

    public AccountCreateRequest emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nonnull
    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonProperty(value="email_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public AccountCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AccountCreateRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public AccountCreateRequest locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountCreateRequest accountCreateRequest = (AccountCreateRequest)o;
        return Objects.equals(this.emailAddress, accountCreateRequest.emailAddress) && Objects.equals(this.clientId, accountCreateRequest.clientId) && Objects.equals(this.clientSecret, accountCreateRequest.clientSecret) && Objects.equals(this.locale, accountCreateRequest.locale);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddress, this.clientId, this.clientSecret, this.locale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountCreateRequest {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public Map<String, Object> createFormData() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean fileTypeFound = false;
        try {
            int i;
            if (this.emailAddress != null) {
                if (this.isFileTypeOrListOfFiles(this.emailAddress)) {
                    fileTypeFound = true;
                }
                if (this.emailAddress.getClass().equals(File.class) || this.emailAddress.getClass().equals(Integer.class) || this.emailAddress.getClass().equals(String.class) || this.emailAddress.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, this.emailAddress);
                } else if (this.isListOfFile(this.emailAddress)) {
                    for (i = 0; i < this.getListSize(this.emailAddress); ++i) {
                        map.put("email_address[" + i + "]", this.getFromList(this.emailAddress, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_EMAIL_ADDRESS, JSON.getDefault().getMapper().writeValueAsString((Object)this.emailAddress));
                }
            }
            if (this.clientId != null) {
                if (this.isFileTypeOrListOfFiles(this.clientId)) {
                    fileTypeFound = true;
                }
                if (this.clientId.getClass().equals(File.class) || this.clientId.getClass().equals(Integer.class) || this.clientId.getClass().equals(String.class) || this.clientId.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_ID, this.clientId);
                } else if (this.isListOfFile(this.clientId)) {
                    for (i = 0; i < this.getListSize(this.clientId); ++i) {
                        map.put("client_id[" + i + "]", this.getFromList(this.clientId, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_ID, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientId));
                }
            }
            if (this.clientSecret != null) {
                if (this.isFileTypeOrListOfFiles(this.clientSecret)) {
                    fileTypeFound = true;
                }
                if (this.clientSecret.getClass().equals(File.class) || this.clientSecret.getClass().equals(Integer.class) || this.clientSecret.getClass().equals(String.class) || this.clientSecret.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_CLIENT_SECRET, this.clientSecret);
                } else if (this.isListOfFile(this.clientSecret)) {
                    for (i = 0; i < this.getListSize(this.clientSecret); ++i) {
                        map.put("client_secret[" + i + "]", this.getFromList(this.clientSecret, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_CLIENT_SECRET, JSON.getDefault().getMapper().writeValueAsString((Object)this.clientSecret));
                }
            }
            if (this.locale != null) {
                if (this.isFileTypeOrListOfFiles(this.locale)) {
                    fileTypeFound = true;
                }
                if (this.locale.getClass().equals(File.class) || this.locale.getClass().equals(Integer.class) || this.locale.getClass().equals(String.class) || this.locale.getClass().isEnum()) {
                    map.put(JSON_PROPERTY_LOCALE, this.locale);
                } else if (this.isListOfFile(this.locale)) {
                    for (i = 0; i < this.getListSize(this.locale); ++i) {
                        map.put("locale[" + i + "]", this.getFromList(this.locale, i));
                    }
                } else {
                    map.put(JSON_PROPERTY_LOCALE, JSON.getDefault().getMapper().writeValueAsString((Object)this.locale));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return fileTypeFound ? map : new HashMap<String, Object>();
    }

    private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
        return obj.getClass().equals(File.class) || this.isListOfFile(obj);
    }

    private boolean isListOfFile(Object obj) throws Exception {
        return obj instanceof List && !this.isListEmpty(obj) && this.getFromList(obj, 0) instanceof File;
    }

    private boolean isListEmpty(Object obj) throws Exception {
        return (Boolean)Class.forName(List.class.getName()).getMethod("isEmpty", new Class[0]).invoke(obj, new Object[0]);
    }

    private Object getFromList(Object obj, int index) throws Exception {
        return Class.forName(List.class.getName()).getMethod("get", Integer.TYPE).invoke(obj, index);
    }

    private int getListSize(Object obj) throws Exception {
        return (Integer)Class.forName(List.class.getName()).getMethod("size", new Class[0]).invoke(obj, new Object[0]);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

