/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.FileResponse;
import com.dropbox.sign.model.FileResponseDataUri;
import com.dropbox.sign.model.TemplateAddUserRequest;
import com.dropbox.sign.model.TemplateCreateEmbeddedDraftRequest;
import com.dropbox.sign.model.TemplateCreateEmbeddedDraftResponse;
import com.dropbox.sign.model.TemplateCreateRequest;
import com.dropbox.sign.model.TemplateCreateResponse;
import com.dropbox.sign.model.TemplateGetResponse;
import com.dropbox.sign.model.TemplateListResponse;
import com.dropbox.sign.model.TemplateRemoveUserRequest;
import com.dropbox.sign.model.TemplateUpdateFilesRequest;
import com.dropbox.sign.model.TemplateUpdateFilesResponse;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TemplateApi {
    private ApiClient apiClient;

    public TemplateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplateApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TemplateGetResponse templateAddUser(String templateId, TemplateAddUserRequest templateAddUserRequest) throws ApiException {
        return this.templateAddUserWithHttpInfo(templateId, templateAddUserRequest).getData();
    }

    public ApiResponse<TemplateGetResponse> templateAddUserWithHttpInfo(String templateId, TemplateAddUserRequest templateAddUserRequest) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateAddUser");
        }
        if (templateAddUserRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'templateAddUserRequest' when calling templateAddUser");
        }
        String localVarPath = "/template/add_user/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = templateAddUserRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateGetResponse> localVarReturnType = new GenericType<TemplateGetResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateAddUser", localVarPath, "POST", new ArrayList<Pair>(), isFileTypeFound ? null : templateAddUserRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplateCreateResponse templateCreate(TemplateCreateRequest templateCreateRequest) throws ApiException {
        return this.templateCreateWithHttpInfo(templateCreateRequest).getData();
    }

    public ApiResponse<TemplateCreateResponse> templateCreateWithHttpInfo(TemplateCreateRequest templateCreateRequest) throws ApiException {
        if (templateCreateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'templateCreateRequest' when calling templateCreate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = templateCreateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateCreateResponse> localVarReturnType = new GenericType<TemplateCreateResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateCreate", "/template/create", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : templateCreateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplateCreateEmbeddedDraftResponse templateCreateEmbeddedDraft(TemplateCreateEmbeddedDraftRequest templateCreateEmbeddedDraftRequest) throws ApiException {
        return this.templateCreateEmbeddedDraftWithHttpInfo(templateCreateEmbeddedDraftRequest).getData();
    }

    public ApiResponse<TemplateCreateEmbeddedDraftResponse> templateCreateEmbeddedDraftWithHttpInfo(TemplateCreateEmbeddedDraftRequest templateCreateEmbeddedDraftRequest) throws ApiException {
        if (templateCreateEmbeddedDraftRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'templateCreateEmbeddedDraftRequest' when calling templateCreateEmbeddedDraft");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = templateCreateEmbeddedDraftRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateCreateEmbeddedDraftResponse> localVarReturnType = new GenericType<TemplateCreateEmbeddedDraftResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateCreateEmbeddedDraft", "/template/create_embedded_draft", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : templateCreateEmbeddedDraftRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void templateDelete(String templateId) throws ApiException {
        this.templateDeleteWithHttpInfo(templateId);
    }

    public ApiResponse<Void> templateDeleteWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateDelete");
        }
        String localVarPath = "/template/delete/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.apiClient.invokeAPI("TemplateApi.templateDelete", localVarPath, "POST", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public File templateFiles(String templateId, String fileType) throws ApiException {
        return this.templateFilesWithHttpInfo(templateId, fileType).getData();
    }

    public File templateFiles(String templateId) throws ApiException {
        String fileType = null;
        return this.templateFilesWithHttpInfo(templateId, fileType).getData();
    }

    public ApiResponse<File> templateFilesWithHttpInfo(String templateId) throws ApiException {
        String fileType = null;
        return this.templateFilesWithHttpInfo(templateId, fileType);
    }

    public ApiResponse<File> templateFilesWithHttpInfo(String templateId, String fileType) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateFiles");
        }
        String localVarPath = "/template/files/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "file_type", fileType));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/pdf", "application/zip", "application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateFiles", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FileResponseDataUri templateFilesAsDataUri(String templateId) throws ApiException {
        return this.templateFilesAsDataUriWithHttpInfo(templateId).getData();
    }

    public ApiResponse<FileResponseDataUri> templateFilesAsDataUriWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateFilesAsDataUri");
        }
        String localVarPath = "/template/files_as_data_uri/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<FileResponseDataUri> localVarReturnType = new GenericType<FileResponseDataUri>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateFilesAsDataUri", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FileResponse templateFilesAsFileUrl(String templateId, Integer forceDownload) throws ApiException {
        return this.templateFilesAsFileUrlWithHttpInfo(templateId, forceDownload).getData();
    }

    public FileResponse templateFilesAsFileUrl(String templateId) throws ApiException {
        Integer forceDownload = 1;
        return this.templateFilesAsFileUrlWithHttpInfo(templateId, forceDownload).getData();
    }

    public ApiResponse<FileResponse> templateFilesAsFileUrlWithHttpInfo(String templateId) throws ApiException {
        Integer forceDownload = 1;
        return this.templateFilesAsFileUrlWithHttpInfo(templateId, forceDownload);
    }

    public ApiResponse<FileResponse> templateFilesAsFileUrlWithHttpInfo(String templateId, Integer forceDownload) throws ApiException {
        if (forceDownload == null) {
            forceDownload = 1;
        }
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateFilesAsFileUrl");
        }
        String localVarPath = "/template/files_as_file_url/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "force_download", forceDownload));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<FileResponse> localVarReturnType = new GenericType<FileResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateFilesAsFileUrl", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplateGetResponse templateGet(String templateId) throws ApiException {
        return this.templateGetWithHttpInfo(templateId).getData();
    }

    public ApiResponse<TemplateGetResponse> templateGetWithHttpInfo(String templateId) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateGet");
        }
        String localVarPath = "/template/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateGetResponse> localVarReturnType = new GenericType<TemplateGetResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateGet", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplateListResponse templateList(String accountId, Integer page, Integer pageSize, String query) throws ApiException {
        return this.templateListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public TemplateListResponse templateList() throws ApiException {
        String accountId = null;
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<TemplateListResponse> templateListWithHttpInfo() throws ApiException {
        String accountId = null;
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query);
    }

    public TemplateListResponse templateList(String accountId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<TemplateListResponse> templateListWithHttpInfo(String accountId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query);
    }

    public TemplateListResponse templateList(String accountId, Integer page) throws ApiException {
        Integer pageSize = 20;
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<TemplateListResponse> templateListWithHttpInfo(String accountId, Integer page) throws ApiException {
        Integer pageSize = 20;
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query);
    }

    public TemplateListResponse templateList(String accountId, Integer page, Integer pageSize) throws ApiException {
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<TemplateListResponse> templateListWithHttpInfo(String accountId, Integer page, Integer pageSize) throws ApiException {
        String query = null;
        return this.templateListWithHttpInfo(accountId, page, pageSize, query);
    }

    public ApiResponse<TemplateListResponse> templateListWithHttpInfo(String accountId, Integer page, Integer pageSize, String query) throws ApiException {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateListResponse> localVarReturnType = new GenericType<TemplateListResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateList", "/template/list", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplateGetResponse templateRemoveUser(String templateId, TemplateRemoveUserRequest templateRemoveUserRequest) throws ApiException {
        return this.templateRemoveUserWithHttpInfo(templateId, templateRemoveUserRequest).getData();
    }

    public ApiResponse<TemplateGetResponse> templateRemoveUserWithHttpInfo(String templateId, TemplateRemoveUserRequest templateRemoveUserRequest) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateRemoveUser");
        }
        if (templateRemoveUserRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'templateRemoveUserRequest' when calling templateRemoveUser");
        }
        String localVarPath = "/template/remove_user/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = templateRemoveUserRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateGetResponse> localVarReturnType = new GenericType<TemplateGetResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateRemoveUser", localVarPath, "POST", new ArrayList<Pair>(), isFileTypeFound ? null : templateRemoveUserRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TemplateUpdateFilesResponse templateUpdateFiles(String templateId, TemplateUpdateFilesRequest templateUpdateFilesRequest) throws ApiException {
        return this.templateUpdateFilesWithHttpInfo(templateId, templateUpdateFilesRequest).getData();
    }

    public ApiResponse<TemplateUpdateFilesResponse> templateUpdateFilesWithHttpInfo(String templateId, TemplateUpdateFilesRequest templateUpdateFilesRequest) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling templateUpdateFiles");
        }
        if (templateUpdateFilesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'templateUpdateFilesRequest' when calling templateUpdateFiles");
        }
        String localVarPath = "/template/update_files/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = templateUpdateFilesRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TemplateUpdateFilesResponse> localVarReturnType = new GenericType<TemplateUpdateFilesResponse>(){};
        return this.apiClient.invokeAPI("TemplateApi.templateUpdateFiles", localVarPath, "POST", new ArrayList<Pair>(), isFileTypeFound ? null : templateUpdateFilesRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

