/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.TeamAddMemberRequest;
import com.dropbox.sign.model.TeamCreateRequest;
import com.dropbox.sign.model.TeamGetInfoResponse;
import com.dropbox.sign.model.TeamGetResponse;
import com.dropbox.sign.model.TeamInvitesResponse;
import com.dropbox.sign.model.TeamMembersResponse;
import com.dropbox.sign.model.TeamRemoveMemberRequest;
import com.dropbox.sign.model.TeamSubTeamsResponse;
import com.dropbox.sign.model.TeamUpdateRequest;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TeamApi {
    private ApiClient apiClient;

    public TeamApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TeamApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public TeamGetResponse teamAddMember(TeamAddMemberRequest teamAddMemberRequest, String teamId) throws ApiException {
        return this.teamAddMemberWithHttpInfo(teamAddMemberRequest, teamId).getData();
    }

    public TeamGetResponse teamAddMember(TeamAddMemberRequest teamAddMemberRequest) throws ApiException {
        String teamId = null;
        return this.teamAddMemberWithHttpInfo(teamAddMemberRequest, teamId).getData();
    }

    public ApiResponse<TeamGetResponse> teamAddMemberWithHttpInfo(TeamAddMemberRequest teamAddMemberRequest) throws ApiException {
        String teamId = null;
        return this.teamAddMemberWithHttpInfo(teamAddMemberRequest, teamId);
    }

    public ApiResponse<TeamGetResponse> teamAddMemberWithHttpInfo(TeamAddMemberRequest teamAddMemberRequest, String teamId) throws ApiException {
        if (teamAddMemberRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'teamAddMemberRequest' when calling teamAddMember");
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "team_id", teamId));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = teamAddMemberRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamGetResponse> localVarReturnType = new GenericType<TeamGetResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamAddMember", "/team/add_member", "PUT", localVarQueryParams, isFileTypeFound ? null : teamAddMemberRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamGetResponse teamCreate(TeamCreateRequest teamCreateRequest) throws ApiException {
        return this.teamCreateWithHttpInfo(teamCreateRequest).getData();
    }

    public ApiResponse<TeamGetResponse> teamCreateWithHttpInfo(TeamCreateRequest teamCreateRequest) throws ApiException {
        if (teamCreateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'teamCreateRequest' when calling teamCreate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = teamCreateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamGetResponse> localVarReturnType = new GenericType<TeamGetResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamCreate", "/team/create", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : teamCreateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void teamDelete() throws ApiException {
        this.teamDeleteWithHttpInfo();
    }

    public ApiResponse<Void> teamDeleteWithHttpInfo() throws ApiException {
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.apiClient.invokeAPI("TeamApi.teamDelete", "/team/destroy", "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public TeamGetResponse teamGet() throws ApiException {
        return this.teamGetWithHttpInfo().getData();
    }

    public ApiResponse<TeamGetResponse> teamGetWithHttpInfo() throws ApiException {
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamGetResponse> localVarReturnType = new GenericType<TeamGetResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamGet", "/team", "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamGetInfoResponse teamInfo(String teamId) throws ApiException {
        return this.teamInfoWithHttpInfo(teamId).getData();
    }

    public TeamGetInfoResponse teamInfo() throws ApiException {
        String teamId = null;
        return this.teamInfoWithHttpInfo(teamId).getData();
    }

    public ApiResponse<TeamGetInfoResponse> teamInfoWithHttpInfo() throws ApiException {
        String teamId = null;
        return this.teamInfoWithHttpInfo(teamId);
    }

    public ApiResponse<TeamGetInfoResponse> teamInfoWithHttpInfo(String teamId) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "team_id", teamId));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamGetInfoResponse> localVarReturnType = new GenericType<TeamGetInfoResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamInfo", "/team/info", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamInvitesResponse teamInvites(String emailAddress) throws ApiException {
        return this.teamInvitesWithHttpInfo(emailAddress).getData();
    }

    public TeamInvitesResponse teamInvites() throws ApiException {
        String emailAddress = null;
        return this.teamInvitesWithHttpInfo(emailAddress).getData();
    }

    public ApiResponse<TeamInvitesResponse> teamInvitesWithHttpInfo() throws ApiException {
        String emailAddress = null;
        return this.teamInvitesWithHttpInfo(emailAddress);
    }

    public ApiResponse<TeamInvitesResponse> teamInvitesWithHttpInfo(String emailAddress) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "email_address", emailAddress));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamInvitesResponse> localVarReturnType = new GenericType<TeamInvitesResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamInvites", "/team/invites", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamMembersResponse teamMembers(String teamId, Integer page, Integer pageSize) throws ApiException {
        return this.teamMembersWithHttpInfo(teamId, page, pageSize).getData();
    }

    public TeamMembersResponse teamMembers(String teamId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.teamMembersWithHttpInfo(teamId, page, pageSize).getData();
    }

    public ApiResponse<TeamMembersResponse> teamMembersWithHttpInfo(String teamId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.teamMembersWithHttpInfo(teamId, page, pageSize);
    }

    public TeamMembersResponse teamMembers(String teamId, Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.teamMembersWithHttpInfo(teamId, page, pageSize).getData();
    }

    public ApiResponse<TeamMembersResponse> teamMembersWithHttpInfo(String teamId, Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.teamMembersWithHttpInfo(teamId, page, pageSize);
    }

    public ApiResponse<TeamMembersResponse> teamMembersWithHttpInfo(String teamId, Integer page, Integer pageSize) throws ApiException {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling teamMembers");
        }
        String localVarPath = "/team/members/{team_id}".replaceAll("\\{team_id}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamMembersResponse> localVarReturnType = new GenericType<TeamMembersResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamMembers", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamGetResponse teamRemoveMember(TeamRemoveMemberRequest teamRemoveMemberRequest) throws ApiException {
        return this.teamRemoveMemberWithHttpInfo(teamRemoveMemberRequest).getData();
    }

    public ApiResponse<TeamGetResponse> teamRemoveMemberWithHttpInfo(TeamRemoveMemberRequest teamRemoveMemberRequest) throws ApiException {
        if (teamRemoveMemberRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'teamRemoveMemberRequest' when calling teamRemoveMember");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = teamRemoveMemberRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamGetResponse> localVarReturnType = new GenericType<TeamGetResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamRemoveMember", "/team/remove_member", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : teamRemoveMemberRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamSubTeamsResponse teamSubTeams(String teamId, Integer page, Integer pageSize) throws ApiException {
        return this.teamSubTeamsWithHttpInfo(teamId, page, pageSize).getData();
    }

    public TeamSubTeamsResponse teamSubTeams(String teamId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.teamSubTeamsWithHttpInfo(teamId, page, pageSize).getData();
    }

    public ApiResponse<TeamSubTeamsResponse> teamSubTeamsWithHttpInfo(String teamId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.teamSubTeamsWithHttpInfo(teamId, page, pageSize);
    }

    public TeamSubTeamsResponse teamSubTeams(String teamId, Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.teamSubTeamsWithHttpInfo(teamId, page, pageSize).getData();
    }

    public ApiResponse<TeamSubTeamsResponse> teamSubTeamsWithHttpInfo(String teamId, Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.teamSubTeamsWithHttpInfo(teamId, page, pageSize);
    }

    public ApiResponse<TeamSubTeamsResponse> teamSubTeamsWithHttpInfo(String teamId, Integer page, Integer pageSize) throws ApiException {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling teamSubTeams");
        }
        String localVarPath = "/team/sub_teams/{team_id}".replaceAll("\\{team_id}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamSubTeamsResponse> localVarReturnType = new GenericType<TeamSubTeamsResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamSubTeams", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public TeamGetResponse teamUpdate(TeamUpdateRequest teamUpdateRequest) throws ApiException {
        return this.teamUpdateWithHttpInfo(teamUpdateRequest).getData();
    }

    public ApiResponse<TeamGetResponse> teamUpdateWithHttpInfo(TeamUpdateRequest teamUpdateRequest) throws ApiException {
        if (teamUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'teamUpdateRequest' when calling teamUpdate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = teamUpdateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<TeamGetResponse> localVarReturnType = new GenericType<TeamGetResponse>(){};
        return this.apiClient.invokeAPI("TeamApi.teamUpdate", "/team", "PUT", new ArrayList<Pair>(), isFileTypeFound ? null : teamUpdateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

