/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.BulkSendJobSendResponse;
import com.dropbox.sign.model.FileResponse;
import com.dropbox.sign.model.FileResponseDataUri;
import com.dropbox.sign.model.SignatureRequestBulkCreateEmbeddedWithTemplateRequest;
import com.dropbox.sign.model.SignatureRequestBulkSendWithTemplateRequest;
import com.dropbox.sign.model.SignatureRequestCreateEmbeddedRequest;
import com.dropbox.sign.model.SignatureRequestCreateEmbeddedWithTemplateRequest;
import com.dropbox.sign.model.SignatureRequestGetResponse;
import com.dropbox.sign.model.SignatureRequestListResponse;
import com.dropbox.sign.model.SignatureRequestRemindRequest;
import com.dropbox.sign.model.SignatureRequestSendRequest;
import com.dropbox.sign.model.SignatureRequestSendWithTemplateRequest;
import com.dropbox.sign.model.SignatureRequestUpdateRequest;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SignatureRequestApi {
    private ApiClient apiClient;

    public SignatureRequestApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SignatureRequestApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BulkSendJobSendResponse signatureRequestBulkCreateEmbeddedWithTemplate(SignatureRequestBulkCreateEmbeddedWithTemplateRequest signatureRequestBulkCreateEmbeddedWithTemplateRequest) throws ApiException {
        return this.signatureRequestBulkCreateEmbeddedWithTemplateWithHttpInfo(signatureRequestBulkCreateEmbeddedWithTemplateRequest).getData();
    }

    public ApiResponse<BulkSendJobSendResponse> signatureRequestBulkCreateEmbeddedWithTemplateWithHttpInfo(SignatureRequestBulkCreateEmbeddedWithTemplateRequest signatureRequestBulkCreateEmbeddedWithTemplateRequest) throws ApiException {
        if (signatureRequestBulkCreateEmbeddedWithTemplateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestBulkCreateEmbeddedWithTemplateRequest' when calling signatureRequestBulkCreateEmbeddedWithTemplate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestBulkCreateEmbeddedWithTemplateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key"};
        GenericType<BulkSendJobSendResponse> localVarReturnType = new GenericType<BulkSendJobSendResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestBulkCreateEmbeddedWithTemplate", "/signature_request/bulk_create_embedded_with_template", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestBulkCreateEmbeddedWithTemplateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public BulkSendJobSendResponse signatureRequestBulkSendWithTemplate(SignatureRequestBulkSendWithTemplateRequest signatureRequestBulkSendWithTemplateRequest) throws ApiException {
        return this.signatureRequestBulkSendWithTemplateWithHttpInfo(signatureRequestBulkSendWithTemplateRequest).getData();
    }

    public ApiResponse<BulkSendJobSendResponse> signatureRequestBulkSendWithTemplateWithHttpInfo(SignatureRequestBulkSendWithTemplateRequest signatureRequestBulkSendWithTemplateRequest) throws ApiException {
        if (signatureRequestBulkSendWithTemplateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestBulkSendWithTemplateRequest' when calling signatureRequestBulkSendWithTemplate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestBulkSendWithTemplateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<BulkSendJobSendResponse> localVarReturnType = new GenericType<BulkSendJobSendResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestBulkSendWithTemplate", "/signature_request/bulk_send_with_template", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestBulkSendWithTemplateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void signatureRequestCancel(String signatureRequestId) throws ApiException {
        this.signatureRequestCancelWithHttpInfo(signatureRequestId);
    }

    public ApiResponse<Void> signatureRequestCancelWithHttpInfo(String signatureRequestId) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestCancel");
        }
        String localVarPath = "/signature_request/cancel/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestCancel", localVarPath, "POST", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public SignatureRequestGetResponse signatureRequestCreateEmbedded(SignatureRequestCreateEmbeddedRequest signatureRequestCreateEmbeddedRequest) throws ApiException {
        return this.signatureRequestCreateEmbeddedWithHttpInfo(signatureRequestCreateEmbeddedRequest).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestCreateEmbeddedWithHttpInfo(SignatureRequestCreateEmbeddedRequest signatureRequestCreateEmbeddedRequest) throws ApiException {
        if (signatureRequestCreateEmbeddedRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestCreateEmbeddedRequest' when calling signatureRequestCreateEmbedded");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestCreateEmbeddedRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestCreateEmbedded", "/signature_request/create_embedded", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestCreateEmbeddedRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestGetResponse signatureRequestCreateEmbeddedWithTemplate(SignatureRequestCreateEmbeddedWithTemplateRequest signatureRequestCreateEmbeddedWithTemplateRequest) throws ApiException {
        return this.signatureRequestCreateEmbeddedWithTemplateWithHttpInfo(signatureRequestCreateEmbeddedWithTemplateRequest).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestCreateEmbeddedWithTemplateWithHttpInfo(SignatureRequestCreateEmbeddedWithTemplateRequest signatureRequestCreateEmbeddedWithTemplateRequest) throws ApiException {
        if (signatureRequestCreateEmbeddedWithTemplateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestCreateEmbeddedWithTemplateRequest' when calling signatureRequestCreateEmbeddedWithTemplate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestCreateEmbeddedWithTemplateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestCreateEmbeddedWithTemplate", "/signature_request/create_embedded_with_template", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestCreateEmbeddedWithTemplateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public File signatureRequestFiles(String signatureRequestId, String fileType) throws ApiException {
        return this.signatureRequestFilesWithHttpInfo(signatureRequestId, fileType).getData();
    }

    public File signatureRequestFiles(String signatureRequestId) throws ApiException {
        String fileType = "pdf";
        return this.signatureRequestFilesWithHttpInfo(signatureRequestId, fileType).getData();
    }

    public ApiResponse<File> signatureRequestFilesWithHttpInfo(String signatureRequestId) throws ApiException {
        String fileType = "pdf";
        return this.signatureRequestFilesWithHttpInfo(signatureRequestId, fileType);
    }

    public ApiResponse<File> signatureRequestFilesWithHttpInfo(String signatureRequestId, String fileType) throws ApiException {
        if (fileType == null) {
            fileType = "pdf";
        }
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestFiles");
        }
        String localVarPath = "/signature_request/files/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "file_type", fileType));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/pdf", "application/zip", "application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestFiles", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FileResponseDataUri signatureRequestFilesAsDataUri(String signatureRequestId) throws ApiException {
        return this.signatureRequestFilesAsDataUriWithHttpInfo(signatureRequestId).getData();
    }

    public ApiResponse<FileResponseDataUri> signatureRequestFilesAsDataUriWithHttpInfo(String signatureRequestId) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestFilesAsDataUri");
        }
        String localVarPath = "/signature_request/files_as_data_uri/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<FileResponseDataUri> localVarReturnType = new GenericType<FileResponseDataUri>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestFilesAsDataUri", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FileResponse signatureRequestFilesAsFileUrl(String signatureRequestId, Integer forceDownload) throws ApiException {
        return this.signatureRequestFilesAsFileUrlWithHttpInfo(signatureRequestId, forceDownload).getData();
    }

    public FileResponse signatureRequestFilesAsFileUrl(String signatureRequestId) throws ApiException {
        Integer forceDownload = 1;
        return this.signatureRequestFilesAsFileUrlWithHttpInfo(signatureRequestId, forceDownload).getData();
    }

    public ApiResponse<FileResponse> signatureRequestFilesAsFileUrlWithHttpInfo(String signatureRequestId) throws ApiException {
        Integer forceDownload = 1;
        return this.signatureRequestFilesAsFileUrlWithHttpInfo(signatureRequestId, forceDownload);
    }

    public ApiResponse<FileResponse> signatureRequestFilesAsFileUrlWithHttpInfo(String signatureRequestId, Integer forceDownload) throws ApiException {
        if (forceDownload == null) {
            forceDownload = 1;
        }
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestFilesAsFileUrl");
        }
        String localVarPath = "/signature_request/files_as_file_url/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "force_download", forceDownload));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<FileResponse> localVarReturnType = new GenericType<FileResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestFilesAsFileUrl", localVarPath, "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestGetResponse signatureRequestGet(String signatureRequestId) throws ApiException {
        return this.signatureRequestGetWithHttpInfo(signatureRequestId).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestGetWithHttpInfo(String signatureRequestId) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestGet");
        }
        String localVarPath = "/signature_request/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestGet", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestListResponse signatureRequestList(String accountId, Integer page, Integer pageSize, String query) throws ApiException {
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public SignatureRequestListResponse signatureRequestList() throws ApiException {
        String accountId = null;
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<SignatureRequestListResponse> signatureRequestListWithHttpInfo() throws ApiException {
        String accountId = null;
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query);
    }

    public SignatureRequestListResponse signatureRequestList(String accountId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<SignatureRequestListResponse> signatureRequestListWithHttpInfo(String accountId) throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query);
    }

    public SignatureRequestListResponse signatureRequestList(String accountId, Integer page) throws ApiException {
        Integer pageSize = 20;
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<SignatureRequestListResponse> signatureRequestListWithHttpInfo(String accountId, Integer page) throws ApiException {
        Integer pageSize = 20;
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query);
    }

    public SignatureRequestListResponse signatureRequestList(String accountId, Integer page, Integer pageSize) throws ApiException {
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query).getData();
    }

    public ApiResponse<SignatureRequestListResponse> signatureRequestListWithHttpInfo(String accountId, Integer page, Integer pageSize) throws ApiException {
        String query = null;
        return this.signatureRequestListWithHttpInfo(accountId, page, pageSize, query);
    }

    public ApiResponse<SignatureRequestListResponse> signatureRequestListWithHttpInfo(String accountId, Integer page, Integer pageSize, String query) throws ApiException {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestListResponse> localVarReturnType = new GenericType<SignatureRequestListResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestList", "/signature_request/list", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestGetResponse signatureRequestReleaseHold(String signatureRequestId) throws ApiException {
        return this.signatureRequestReleaseHoldWithHttpInfo(signatureRequestId).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestReleaseHoldWithHttpInfo(String signatureRequestId) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestReleaseHold");
        }
        String localVarPath = "/signature_request/release_hold/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestReleaseHold", localVarPath, "POST", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestGetResponse signatureRequestRemind(String signatureRequestId, SignatureRequestRemindRequest signatureRequestRemindRequest) throws ApiException {
        return this.signatureRequestRemindWithHttpInfo(signatureRequestId, signatureRequestRemindRequest).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestRemindWithHttpInfo(String signatureRequestId, SignatureRequestRemindRequest signatureRequestRemindRequest) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestRemind");
        }
        if (signatureRequestRemindRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestRemindRequest' when calling signatureRequestRemind");
        }
        String localVarPath = "/signature_request/remind/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestRemindRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestRemind", localVarPath, "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestRemindRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void signatureRequestRemove(String signatureRequestId) throws ApiException {
        this.signatureRequestRemoveWithHttpInfo(signatureRequestId);
    }

    public ApiResponse<Void> signatureRequestRemoveWithHttpInfo(String signatureRequestId) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestRemove");
        }
        String localVarPath = "/signature_request/remove/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestRemove", localVarPath, "POST", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public SignatureRequestGetResponse signatureRequestSend(SignatureRequestSendRequest signatureRequestSendRequest) throws ApiException {
        return this.signatureRequestSendWithHttpInfo(signatureRequestSendRequest).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestSendWithHttpInfo(SignatureRequestSendRequest signatureRequestSendRequest) throws ApiException {
        if (signatureRequestSendRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestSendRequest' when calling signatureRequestSend");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestSendRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestSend", "/signature_request/send", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestSendRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestGetResponse signatureRequestSendWithTemplate(SignatureRequestSendWithTemplateRequest signatureRequestSendWithTemplateRequest) throws ApiException {
        return this.signatureRequestSendWithTemplateWithHttpInfo(signatureRequestSendWithTemplateRequest).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestSendWithTemplateWithHttpInfo(SignatureRequestSendWithTemplateRequest signatureRequestSendWithTemplateRequest) throws ApiException {
        if (signatureRequestSendWithTemplateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestSendWithTemplateRequest' when calling signatureRequestSendWithTemplate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestSendWithTemplateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestSendWithTemplate", "/signature_request/send_with_template", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestSendWithTemplateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SignatureRequestGetResponse signatureRequestUpdate(String signatureRequestId, SignatureRequestUpdateRequest signatureRequestUpdateRequest) throws ApiException {
        return this.signatureRequestUpdateWithHttpInfo(signatureRequestId, signatureRequestUpdateRequest).getData();
    }

    public ApiResponse<SignatureRequestGetResponse> signatureRequestUpdateWithHttpInfo(String signatureRequestId, SignatureRequestUpdateRequest signatureRequestUpdateRequest) throws ApiException {
        if (signatureRequestId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestId' when calling signatureRequestUpdate");
        }
        if (signatureRequestUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureRequestUpdateRequest' when calling signatureRequestUpdate");
        }
        String localVarPath = "/signature_request/update/{signature_request_id}".replaceAll("\\{signature_request_id}", this.apiClient.escapeString(signatureRequestId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = signatureRequestUpdateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<SignatureRequestGetResponse> localVarReturnType = new GenericType<SignatureRequestGetResponse>(){};
        return this.apiClient.invokeAPI("SignatureRequestApi.signatureRequestUpdate", localVarPath, "POST", new ArrayList<Pair>(), isFileTypeFound ? null : signatureRequestUpdateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

