/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.FaxGetResponse;
import com.dropbox.sign.model.FaxListResponse;
import com.dropbox.sign.model.FaxSendRequest;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class FaxApi {
    private ApiClient apiClient;

    public FaxApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FaxApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void faxDelete(String faxId) throws ApiException {
        this.faxDeleteWithHttpInfo(faxId);
    }

    public ApiResponse<Void> faxDeleteWithHttpInfo(String faxId) throws ApiException {
        if (faxId == null) {
            throw new ApiException(400, "Missing the required parameter 'faxId' when calling faxDelete");
        }
        String localVarPath = "/fax/{fax_id}".replaceAll("\\{fax_id}", this.apiClient.escapeString(faxId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.apiClient.invokeAPI("FaxApi.faxDelete", localVarPath, "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public File faxFiles(String faxId) throws ApiException {
        return this.faxFilesWithHttpInfo(faxId).getData();
    }

    public ApiResponse<File> faxFilesWithHttpInfo(String faxId) throws ApiException {
        if (faxId == null) {
            throw new ApiException(400, "Missing the required parameter 'faxId' when calling faxFiles");
        }
        String localVarPath = "/fax/files/{fax_id}".replaceAll("\\{fax_id}", this.apiClient.escapeString(faxId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/pdf", "application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key"};
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI("FaxApi.faxFiles", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FaxGetResponse faxGet(String faxId) throws ApiException {
        return this.faxGetWithHttpInfo(faxId).getData();
    }

    public ApiResponse<FaxGetResponse> faxGetWithHttpInfo(String faxId) throws ApiException {
        if (faxId == null) {
            throw new ApiException(400, "Missing the required parameter 'faxId' when calling faxGet");
        }
        String localVarPath = "/fax/{fax_id}".replaceAll("\\{fax_id}", this.apiClient.escapeString(faxId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key"};
        GenericType<FaxGetResponse> localVarReturnType = new GenericType<FaxGetResponse>(){};
        return this.apiClient.invokeAPI("FaxApi.faxGet", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FaxListResponse faxList(Integer page, Integer pageSize) throws ApiException {
        return this.faxListWithHttpInfo(page, pageSize).getData();
    }

    public FaxListResponse faxList() throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.faxListWithHttpInfo(page, pageSize).getData();
    }

    public ApiResponse<FaxListResponse> faxListWithHttpInfo() throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.faxListWithHttpInfo(page, pageSize);
    }

    public FaxListResponse faxList(Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.faxListWithHttpInfo(page, pageSize).getData();
    }

    public ApiResponse<FaxListResponse> faxListWithHttpInfo(Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.faxListWithHttpInfo(page, pageSize);
    }

    public ApiResponse<FaxListResponse> faxListWithHttpInfo(Integer page, Integer pageSize) throws ApiException {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key"};
        GenericType<FaxListResponse> localVarReturnType = new GenericType<FaxListResponse>(){};
        return this.apiClient.invokeAPI("FaxApi.faxList", "/fax/list", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public FaxGetResponse faxSend(FaxSendRequest faxSendRequest) throws ApiException {
        return this.faxSendWithHttpInfo(faxSendRequest).getData();
    }

    public ApiResponse<FaxGetResponse> faxSendWithHttpInfo(FaxSendRequest faxSendRequest) throws ApiException {
        if (faxSendRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'faxSendRequest' when calling faxSend");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = faxSendRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key"};
        GenericType<FaxGetResponse> localVarReturnType = new GenericType<FaxGetResponse>(){};
        return this.apiClient.invokeAPI("FaxApi.faxSend", "/fax/send", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : faxSendRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

