/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.EmbeddedEditUrlRequest;
import com.dropbox.sign.model.EmbeddedEditUrlResponse;
import com.dropbox.sign.model.EmbeddedSignUrlResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class EmbeddedApi {
    private ApiClient apiClient;

    public EmbeddedApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmbeddedApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EmbeddedEditUrlResponse embeddedEditUrl(String templateId, EmbeddedEditUrlRequest embeddedEditUrlRequest) throws ApiException {
        return this.embeddedEditUrlWithHttpInfo(templateId, embeddedEditUrlRequest).getData();
    }

    public ApiResponse<EmbeddedEditUrlResponse> embeddedEditUrlWithHttpInfo(String templateId, EmbeddedEditUrlRequest embeddedEditUrlRequest) throws ApiException {
        if (templateId == null) {
            throw new ApiException(400, "Missing the required parameter 'templateId' when calling embeddedEditUrl");
        }
        if (embeddedEditUrlRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'embeddedEditUrlRequest' when calling embeddedEditUrl");
        }
        String localVarPath = "/embedded/edit_url/{template_id}".replaceAll("\\{template_id}", this.apiClient.escapeString(templateId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = embeddedEditUrlRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<EmbeddedEditUrlResponse> localVarReturnType = new GenericType<EmbeddedEditUrlResponse>(){};
        return this.apiClient.invokeAPI("EmbeddedApi.embeddedEditUrl", localVarPath, "POST", new ArrayList<Pair>(), isFileTypeFound ? null : embeddedEditUrlRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public EmbeddedSignUrlResponse embeddedSignUrl(String signatureId) throws ApiException {
        return this.embeddedSignUrlWithHttpInfo(signatureId).getData();
    }

    public ApiResponse<EmbeddedSignUrlResponse> embeddedSignUrlWithHttpInfo(String signatureId) throws ApiException {
        if (signatureId == null) {
            throw new ApiException(400, "Missing the required parameter 'signatureId' when calling embeddedSignUrl");
        }
        String localVarPath = "/embedded/sign_url/{signature_id}".replaceAll("\\{signature_id}", this.apiClient.escapeString(signatureId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<EmbeddedSignUrlResponse> localVarReturnType = new GenericType<EmbeddedSignUrlResponse>(){};
        return this.apiClient.invokeAPI("EmbeddedApi.embeddedSignUrl", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

