/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.ApiAppCreateRequest;
import com.dropbox.sign.model.ApiAppGetResponse;
import com.dropbox.sign.model.ApiAppListResponse;
import com.dropbox.sign.model.ApiAppUpdateRequest;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ApiAppApi {
    private ApiClient apiClient;

    public ApiAppApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiAppApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiAppGetResponse apiAppCreate(ApiAppCreateRequest apiAppCreateRequest) throws ApiException {
        return this.apiAppCreateWithHttpInfo(apiAppCreateRequest).getData();
    }

    public ApiResponse<ApiAppGetResponse> apiAppCreateWithHttpInfo(ApiAppCreateRequest apiAppCreateRequest) throws ApiException {
        if (apiAppCreateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'apiAppCreateRequest' when calling apiAppCreate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = apiAppCreateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<ApiAppGetResponse> localVarReturnType = new GenericType<ApiAppGetResponse>(){};
        return this.apiClient.invokeAPI("ApiAppApi.apiAppCreate", "/api_app", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : apiAppCreateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void apiAppDelete(String clientId) throws ApiException {
        this.apiAppDeleteWithHttpInfo(clientId);
    }

    public ApiResponse<Void> apiAppDeleteWithHttpInfo(String clientId) throws ApiException {
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling apiAppDelete");
        }
        String localVarPath = "/api_app/{client_id}".replaceAll("\\{client_id}", this.apiClient.escapeString(clientId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        return this.apiClient.invokeAPI("ApiAppApi.apiAppDelete", localVarPath, "DELETE", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public ApiAppGetResponse apiAppGet(String clientId) throws ApiException {
        return this.apiAppGetWithHttpInfo(clientId).getData();
    }

    public ApiResponse<ApiAppGetResponse> apiAppGetWithHttpInfo(String clientId) throws ApiException {
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling apiAppGet");
        }
        String localVarPath = "/api_app/{client_id}".replaceAll("\\{client_id}", this.apiClient.escapeString(clientId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<ApiAppGetResponse> localVarReturnType = new GenericType<ApiAppGetResponse>(){};
        return this.apiClient.invokeAPI("ApiAppApi.apiAppGet", localVarPath, "GET", new ArrayList<Pair>(), null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ApiAppListResponse apiAppList(Integer page, Integer pageSize) throws ApiException {
        return this.apiAppListWithHttpInfo(page, pageSize).getData();
    }

    public ApiAppListResponse apiAppList() throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.apiAppListWithHttpInfo(page, pageSize).getData();
    }

    public ApiResponse<ApiAppListResponse> apiAppListWithHttpInfo() throws ApiException {
        Integer page = 1;
        Integer pageSize = 20;
        return this.apiAppListWithHttpInfo(page, pageSize);
    }

    public ApiAppListResponse apiAppList(Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.apiAppListWithHttpInfo(page, pageSize).getData();
    }

    public ApiResponse<ApiAppListResponse> apiAppListWithHttpInfo(Integer page) throws ApiException {
        Integer pageSize = 20;
        return this.apiAppListWithHttpInfo(page, pageSize);
    }

    public ApiResponse<ApiAppListResponse> apiAppListWithHttpInfo(Integer page, Integer pageSize) throws ApiException {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page_size", pageSize));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<ApiAppListResponse> localVarReturnType = new GenericType<ApiAppListResponse>(){};
        return this.apiClient.invokeAPI("ApiAppApi.apiAppList", "/api_app/list", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ApiAppGetResponse apiAppUpdate(String clientId, ApiAppUpdateRequest apiAppUpdateRequest) throws ApiException {
        return this.apiAppUpdateWithHttpInfo(clientId, apiAppUpdateRequest).getData();
    }

    public ApiResponse<ApiAppGetResponse> apiAppUpdateWithHttpInfo(String clientId, ApiAppUpdateRequest apiAppUpdateRequest) throws ApiException {
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling apiAppUpdate");
        }
        if (apiAppUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'apiAppUpdateRequest' when calling apiAppUpdate");
        }
        String localVarPath = "/api_app/{client_id}".replaceAll("\\{client_id}", this.apiClient.escapeString(clientId.toString()));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = apiAppUpdateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json", "multipart/form-data");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<ApiAppGetResponse> localVarReturnType = new GenericType<ApiAppGetResponse>(){};
        return this.apiClient.invokeAPI("ApiAppApi.apiAppUpdate", localVarPath, "PUT", new ArrayList<Pair>(), isFileTypeFound ? null : apiAppUpdateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

