/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.sign.api;

import com.dropbox.sign.ApiClient;
import com.dropbox.sign.ApiException;
import com.dropbox.sign.ApiResponse;
import com.dropbox.sign.Configuration;
import com.dropbox.sign.Pair;
import com.dropbox.sign.model.AccountCreateRequest;
import com.dropbox.sign.model.AccountCreateResponse;
import com.dropbox.sign.model.AccountGetResponse;
import com.dropbox.sign.model.AccountUpdateRequest;
import com.dropbox.sign.model.AccountVerifyRequest;
import com.dropbox.sign.model.AccountVerifyResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccountApi {
    private ApiClient apiClient;

    public AccountApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AccountCreateResponse accountCreate(AccountCreateRequest accountCreateRequest) throws ApiException {
        return this.accountCreateWithHttpInfo(accountCreateRequest).getData();
    }

    public ApiResponse<AccountCreateResponse> accountCreateWithHttpInfo(AccountCreateRequest accountCreateRequest) throws ApiException {
        if (accountCreateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'accountCreateRequest' when calling accountCreate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = accountCreateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<AccountCreateResponse> localVarReturnType = new GenericType<AccountCreateResponse>(){};
        return this.apiClient.invokeAPI("AccountApi.accountCreate", "/account/create", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : accountCreateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public AccountGetResponse accountGet(String accountId, String emailAddress) throws ApiException {
        return this.accountGetWithHttpInfo(accountId, emailAddress).getData();
    }

    public AccountGetResponse accountGet() throws ApiException {
        String accountId = null;
        String emailAddress = null;
        return this.accountGetWithHttpInfo(accountId, emailAddress).getData();
    }

    public ApiResponse<AccountGetResponse> accountGetWithHttpInfo() throws ApiException {
        String accountId = null;
        String emailAddress = null;
        return this.accountGetWithHttpInfo(accountId, emailAddress);
    }

    public AccountGetResponse accountGet(String accountId) throws ApiException {
        String emailAddress = null;
        return this.accountGetWithHttpInfo(accountId, emailAddress).getData();
    }

    public ApiResponse<AccountGetResponse> accountGetWithHttpInfo(String accountId) throws ApiException {
        String emailAddress = null;
        return this.accountGetWithHttpInfo(accountId, emailAddress);
    }

    public ApiResponse<AccountGetResponse> accountGetWithHttpInfo(String accountId, String emailAddress) throws ApiException {
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "email_address", emailAddress));
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        HashMap localVarFormParams = new LinkedHashMap();
        localVarFormParams = new HashMap();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType(new String[0]);
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<AccountGetResponse> localVarReturnType = new GenericType<AccountGetResponse>(){};
        return this.apiClient.invokeAPI("AccountApi.accountGet", "/account", "GET", localVarQueryParams, null, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public AccountGetResponse accountUpdate(AccountUpdateRequest accountUpdateRequest) throws ApiException {
        return this.accountUpdateWithHttpInfo(accountUpdateRequest).getData();
    }

    public ApiResponse<AccountGetResponse> accountUpdateWithHttpInfo(AccountUpdateRequest accountUpdateRequest) throws ApiException {
        if (accountUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'accountUpdateRequest' when calling accountUpdate");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = accountUpdateRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<AccountGetResponse> localVarReturnType = new GenericType<AccountGetResponse>(){};
        return this.apiClient.invokeAPI("AccountApi.accountUpdate", "/account", "PUT", new ArrayList<Pair>(), isFileTypeFound ? null : accountUpdateRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public AccountVerifyResponse accountVerify(AccountVerifyRequest accountVerifyRequest) throws ApiException {
        return this.accountVerifyWithHttpInfo(accountVerifyRequest).getData();
    }

    public ApiResponse<AccountVerifyResponse> accountVerifyWithHttpInfo(AccountVerifyRequest accountVerifyRequest) throws ApiException {
        if (accountVerifyRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'accountVerifyRequest' when calling accountVerify");
        }
        String localVarAccept = this.apiClient.selectHeaderAccept("application/json");
        Map<Object, Object> localVarFormParams = new LinkedHashMap();
        localVarFormParams = accountVerifyRequest.createFormData();
        boolean isFileTypeFound = !localVarFormParams.isEmpty();
        String localVarContentType = isFileTypeFound ? "multipart/form-data" : this.apiClient.selectHeaderContentType("application/json");
        String[] localVarAuthNames = new String[]{"api_key", "oauth2"};
        GenericType<AccountVerifyResponse> localVarReturnType = new GenericType<AccountVerifyResponse>(){};
        return this.apiClient.invokeAPI("AccountApi.accountVerify", "/account/verify", "POST", new ArrayList<Pair>(), isFileTypeFound ? null : accountVerifyRequest, new LinkedHashMap<String, String>(), new LinkedHashMap<String, String>(), localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

