/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.dropbox.sign.model.SubAttachment;
import com.dropbox.sign.model.SubEditorOptions;
import com.dropbox.sign.model.SubFieldOptions;
import com.dropbox.sign.model.SubFormFieldGroup;
import com.dropbox.sign.model.SubFormFieldRule;
import com.dropbox.sign.model.SubFormFieldsPerDocumentBase;
import com.dropbox.sign.model.SubMergeField;
import com.dropbox.sign.model.SubTemplateRole;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * TemplateCreateEmbeddedDraftRequest
 */
@JsonPropertyOrder({
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_CLIENT_ID,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FILES,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FILE_URLS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_ALLOW_CCS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_ALLOW_REASSIGN,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_ATTACHMENTS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_CC_ROLES,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_EDITOR_OPTIONS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FIELD_OPTIONS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FORCE_SIGNER_ROLES,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FORCE_SUBJECT_MESSAGE,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FORM_FIELD_GROUPS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FORM_FIELD_RULES,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_MERGE_FIELDS,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_MESSAGE,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_METADATA,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_SHOW_PREVIEW,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_SHOW_PROGRESS_STEPPER,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_SIGNER_ROLES,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_SKIP_ME_NOW,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_SUBJECT,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_TEST_MODE,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_TITLE,
  TemplateCreateEmbeddedDraftRequest.JSON_PROPERTY_USE_PREEXISTING_FIELDS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class TemplateCreateEmbeddedDraftRequest {
  public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
  private String clientId;

  public static final String JSON_PROPERTY_FILES = "files";
  private List<File> files = null;

  public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
  private List<String> fileUrls = null;

  public static final String JSON_PROPERTY_ALLOW_CCS = "allow_ccs";
  private Boolean allowCcs = true;

  public static final String JSON_PROPERTY_ALLOW_REASSIGN = "allow_reassign";
  private Boolean allowReassign = false;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private List<SubAttachment> attachments = null;

  public static final String JSON_PROPERTY_CC_ROLES = "cc_roles";
  private List<String> ccRoles = null;

  public static final String JSON_PROPERTY_EDITOR_OPTIONS = "editor_options";
  private SubEditorOptions editorOptions;

  public static final String JSON_PROPERTY_FIELD_OPTIONS = "field_options";
  private SubFieldOptions fieldOptions;

  public static final String JSON_PROPERTY_FORCE_SIGNER_ROLES = "force_signer_roles";
  private Boolean forceSignerRoles = false;

  public static final String JSON_PROPERTY_FORCE_SUBJECT_MESSAGE = "force_subject_message";
  private Boolean forceSubjectMessage = false;

  public static final String JSON_PROPERTY_FORM_FIELD_GROUPS = "form_field_groups";
  private List<SubFormFieldGroup> formFieldGroups = null;

  public static final String JSON_PROPERTY_FORM_FIELD_RULES = "form_field_rules";
  private List<SubFormFieldRule> formFieldRules = null;

  public static final String JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT = "form_fields_per_document";
  private List<SubFormFieldsPerDocumentBase> formFieldsPerDocument = null;

  public static final String JSON_PROPERTY_MERGE_FIELDS = "merge_fields";
  private List<SubMergeField> mergeFields = null;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, Object> metadata = null;

  public static final String JSON_PROPERTY_SHOW_PREVIEW = "show_preview";
  private Boolean showPreview = false;

  public static final String JSON_PROPERTY_SHOW_PROGRESS_STEPPER = "show_progress_stepper";
  private Boolean showProgressStepper = true;

  public static final String JSON_PROPERTY_SIGNER_ROLES = "signer_roles";
  private List<SubTemplateRole> signerRoles = null;

  public static final String JSON_PROPERTY_SKIP_ME_NOW = "skip_me_now";
  private Boolean skipMeNow = false;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject;

  public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
  private Boolean testMode = false;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_USE_PREEXISTING_FIELDS = "use_preexisting_fields";
  private Boolean usePreexistingFields = false;

  public TemplateCreateEmbeddedDraftRequest() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public TemplateCreateEmbeddedDraftRequest init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, TemplateCreateEmbeddedDraftRequest.class);
  }

  static public TemplateCreateEmbeddedDraftRequest init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      TemplateCreateEmbeddedDraftRequest.class
    );
  }

  public TemplateCreateEmbeddedDraftRequest clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * Client id of the app you&#39;re using to create this draft. Used to apply the branding and callback url defined for the app.
   * @return clientId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public TemplateCreateEmbeddedDraftRequest files(List<File> files) {
    this.files = files;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addFilesItem(File filesItem) {
    if (this.files == null) {
      this.files = new ArrayList<>();
    }
    this.files.add(filesItem);
    return this;
  }

  /**
   * Use &#x60;files[]&#x60; to indicate the uploaded file(s) to send for signature.  This endpoint requires either **files** or **file_urls[]**, but not both.
   * @return files
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<File> getFiles() {
    return files;
  }


  @JsonProperty(JSON_PROPERTY_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFiles(List<File> files) {
    this.files = files;
  }


  public TemplateCreateEmbeddedDraftRequest fileUrls(List<String> fileUrls) {
    this.fileUrls = fileUrls;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addFileUrlsItem(String fileUrlsItem) {
    if (this.fileUrls == null) {
      this.fileUrls = new ArrayList<>();
    }
    this.fileUrls.add(fileUrlsItem);
    return this;
  }

  /**
   * Use &#x60;file_urls[]&#x60; to have Dropbox Sign download the file(s) to send for signature.  This endpoint requires either **files** or **file_urls[]**, but not both.
   * @return fileUrls
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFileUrls() {
    return fileUrls;
  }


  @JsonProperty(JSON_PROPERTY_FILE_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileUrls(List<String> fileUrls) {
    this.fileUrls = fileUrls;
  }


  public TemplateCreateEmbeddedDraftRequest allowCcs(Boolean allowCcs) {
    this.allowCcs = allowCcs;
    return this;
  }

  /**
   * This allows the requester to specify whether the user is allowed to provide email addresses to CC when creating a template.
   * @return allowCcs
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_CCS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowCcs() {
    return allowCcs;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_CCS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowCcs(Boolean allowCcs) {
    this.allowCcs = allowCcs;
  }


  public TemplateCreateEmbeddedDraftRequest allowReassign(Boolean allowReassign) {
    this.allowReassign = allowReassign;
    return this;
  }

  /**
   * Allows signers to reassign their signature requests to other signers if set to &#x60;true&#x60;. Defaults to &#x60;false&#x60;.  **NOTE:** Only available for Premium plan and higher.
   * @return allowReassign
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_REASSIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowReassign() {
    return allowReassign;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_REASSIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowReassign(Boolean allowReassign) {
    this.allowReassign = allowReassign;
  }


  public TemplateCreateEmbeddedDraftRequest attachments(List<SubAttachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addAttachmentsItem(SubAttachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * A list describing the attachments
   * @return attachments
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubAttachment> getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(List<SubAttachment> attachments) {
    this.attachments = attachments;
  }


  public TemplateCreateEmbeddedDraftRequest ccRoles(List<String> ccRoles) {
    this.ccRoles = ccRoles;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addCcRolesItem(String ccRolesItem) {
    if (this.ccRoles == null) {
      this.ccRoles = new ArrayList<>();
    }
    this.ccRoles.add(ccRolesItem);
    return this;
  }

  /**
   * The CC roles that must be assigned when using the template to send a signature request
   * @return ccRoles
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCcRoles() {
    return ccRoles;
  }


  @JsonProperty(JSON_PROPERTY_CC_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCcRoles(List<String> ccRoles) {
    this.ccRoles = ccRoles;
  }


  public TemplateCreateEmbeddedDraftRequest editorOptions(SubEditorOptions editorOptions) {
    this.editorOptions = editorOptions;
    return this;
  }

  /**
   * Get editorOptions
   * @return editorOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EDITOR_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubEditorOptions getEditorOptions() {
    return editorOptions;
  }


  @JsonProperty(JSON_PROPERTY_EDITOR_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditorOptions(SubEditorOptions editorOptions) {
    this.editorOptions = editorOptions;
  }


  public TemplateCreateEmbeddedDraftRequest fieldOptions(SubFieldOptions fieldOptions) {
    this.fieldOptions = fieldOptions;
    return this;
  }

  /**
   * Get fieldOptions
   * @return fieldOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FIELD_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubFieldOptions getFieldOptions() {
    return fieldOptions;
  }


  @JsonProperty(JSON_PROPERTY_FIELD_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFieldOptions(SubFieldOptions fieldOptions) {
    this.fieldOptions = fieldOptions;
  }


  public TemplateCreateEmbeddedDraftRequest forceSignerRoles(Boolean forceSignerRoles) {
    this.forceSignerRoles = forceSignerRoles;
    return this;
  }

  /**
   * Provide users the ability to review/edit the template signer roles.
   * @return forceSignerRoles
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_SIGNER_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceSignerRoles() {
    return forceSignerRoles;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_SIGNER_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceSignerRoles(Boolean forceSignerRoles) {
    this.forceSignerRoles = forceSignerRoles;
  }


  public TemplateCreateEmbeddedDraftRequest forceSubjectMessage(Boolean forceSubjectMessage) {
    this.forceSubjectMessage = forceSubjectMessage;
    return this;
  }

  /**
   * Provide users the ability to review/edit the template subject and message.
   * @return forceSubjectMessage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_SUBJECT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceSubjectMessage() {
    return forceSubjectMessage;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_SUBJECT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceSubjectMessage(Boolean forceSubjectMessage) {
    this.forceSubjectMessage = forceSubjectMessage;
  }


  public TemplateCreateEmbeddedDraftRequest formFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
    this.formFieldGroups = formFieldGroups;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addFormFieldGroupsItem(SubFormFieldGroup formFieldGroupsItem) {
    if (this.formFieldGroups == null) {
      this.formFieldGroups = new ArrayList<>();
    }
    this.formFieldGroups.add(formFieldGroupsItem);
    return this;
  }

  /**
   * Group information for fields defined in &#x60;form_fields_per_document&#x60;. String-indexed JSON array with &#x60;group_label&#x60; and &#x60;requirement&#x60; keys. &#x60;form_fields_per_document&#x60; must contain fields referencing a group defined in &#x60;form_field_groups&#x60;.
   * @return formFieldGroups
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_FIELD_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubFormFieldGroup> getFormFieldGroups() {
    return formFieldGroups;
  }


  @JsonProperty(JSON_PROPERTY_FORM_FIELD_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFieldGroups(List<SubFormFieldGroup> formFieldGroups) {
    this.formFieldGroups = formFieldGroups;
  }


  public TemplateCreateEmbeddedDraftRequest formFieldRules(List<SubFormFieldRule> formFieldRules) {
    this.formFieldRules = formFieldRules;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addFormFieldRulesItem(SubFormFieldRule formFieldRulesItem) {
    if (this.formFieldRules == null) {
      this.formFieldRules = new ArrayList<>();
    }
    this.formFieldRules.add(formFieldRulesItem);
    return this;
  }

  /**
   * Conditional Logic rules for fields defined in &#x60;form_fields_per_document&#x60;.
   * @return formFieldRules
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_FIELD_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubFormFieldRule> getFormFieldRules() {
    return formFieldRules;
  }


  @JsonProperty(JSON_PROPERTY_FORM_FIELD_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFieldRules(List<SubFormFieldRule> formFieldRules) {
    this.formFieldRules = formFieldRules;
  }


  public TemplateCreateEmbeddedDraftRequest formFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
    this.formFieldsPerDocument = formFieldsPerDocument;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addFormFieldsPerDocumentItem(SubFormFieldsPerDocumentBase formFieldsPerDocumentItem) {
    if (this.formFieldsPerDocument == null) {
      this.formFieldsPerDocument = new ArrayList<>();
    }
    this.formFieldsPerDocument.add(formFieldsPerDocumentItem);
    return this;
  }

  /**
   * The fields that should appear on the document, expressed as an array of objects. (For more details you can read about it here: [Using Form Fields per Document](/docs/openapi/form-fields-per-document).)  **NOTE:** Fields like **text**, **dropdown**, **checkbox**, **radio**, and **hyperlink** have additional required and optional parameters. Check out the list of [additional parameters](/api/reference/constants/#form-fields-per-document) for these field types.  * Text Field use &#x60;SubFormFieldsPerDocumentText&#x60; * Dropdown Field use &#x60;SubFormFieldsPerDocumentDropdown&#x60; * Hyperlink Field use &#x60;SubFormFieldsPerDocumentHyperlink&#x60; * Checkbox Field use &#x60;SubFormFieldsPerDocumentCheckbox&#x60; * Radio Field use &#x60;SubFormFieldsPerDocumentRadio&#x60; * Signature Field use &#x60;SubFormFieldsPerDocumentSignature&#x60; * Date Signed Field use &#x60;SubFormFieldsPerDocumentDateSigned&#x60; * Initials Field use &#x60;SubFormFieldsPerDocumentInitials&#x60; * Text Merge Field use &#x60;SubFormFieldsPerDocumentTextMerge&#x60; * Checkbox Merge Field use &#x60;SubFormFieldsPerDocumentCheckboxMerge&#x60;
   * @return formFieldsPerDocument
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubFormFieldsPerDocumentBase> getFormFieldsPerDocument() {
    return formFieldsPerDocument;
  }


  @JsonProperty(JSON_PROPERTY_FORM_FIELDS_PER_DOCUMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormFieldsPerDocument(List<SubFormFieldsPerDocumentBase> formFieldsPerDocument) {
    this.formFieldsPerDocument = formFieldsPerDocument;
  }


  public TemplateCreateEmbeddedDraftRequest mergeFields(List<SubMergeField> mergeFields) {
    this.mergeFields = mergeFields;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addMergeFieldsItem(SubMergeField mergeFieldsItem) {
    if (this.mergeFields == null) {
      this.mergeFields = new ArrayList<>();
    }
    this.mergeFields.add(mergeFieldsItem);
    return this;
  }

  /**
   * Add merge fields to the template. Merge fields are placed by the user creating the template and used to pre-fill data by passing values into signature requests with the &#x60;custom_fields&#x60; parameter. If the signature request using that template *does not* pass a value into a merge field, then an empty field remains in the document.
   * @return mergeFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MERGE_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubMergeField> getMergeFields() {
    return mergeFields;
  }


  @JsonProperty(JSON_PROPERTY_MERGE_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMergeFields(List<SubMergeField> mergeFields) {
    this.mergeFields = mergeFields;
  }


  public TemplateCreateEmbeddedDraftRequest message(String message) {
    this.message = message;
    return this;
  }

  /**
   * The default template email message.
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public TemplateCreateEmbeddedDraftRequest metadata(Map<String, Object> metadata) {
    this.metadata = metadata;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest putMetadataItem(String key, Object metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * Key-value data that should be attached to the signature request. This metadata is included in all API responses and events involving the signature request. For example, use the metadata field to store a signer&#39;s order number for look up when receiving events for the signature request.  Each request can include up to 10 metadata keys (or 50 nested metadata keys), with key names up to 40 characters long and values up to 1000 characters long.
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, Object> metadata) {
    this.metadata = metadata;
  }


  public TemplateCreateEmbeddedDraftRequest showPreview(Boolean showPreview) {
    this.showPreview = showPreview;
    return this;
  }

  /**
   * This allows the requester to enable the editor/preview experience.  - &#x60;show_preview&#x3D;true&#x60;: Allows requesters to enable the editor/preview experience. - &#x60;show_preview&#x3D;false&#x60;: Allows requesters to disable the editor/preview experience.
   * @return showPreview
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_PREVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPreview() {
    return showPreview;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PREVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPreview(Boolean showPreview) {
    this.showPreview = showPreview;
  }


  public TemplateCreateEmbeddedDraftRequest showProgressStepper(Boolean showProgressStepper) {
    this.showProgressStepper = showProgressStepper;
    return this;
  }

  /**
   * When only one step remains in the signature request process and this parameter is set to &#x60;false&#x60; then the progress stepper will be hidden.
   * @return showProgressStepper
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_PROGRESS_STEPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowProgressStepper() {
    return showProgressStepper;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PROGRESS_STEPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowProgressStepper(Boolean showProgressStepper) {
    this.showProgressStepper = showProgressStepper;
  }


  public TemplateCreateEmbeddedDraftRequest signerRoles(List<SubTemplateRole> signerRoles) {
    this.signerRoles = signerRoles;
    return this;
  }

  public TemplateCreateEmbeddedDraftRequest addSignerRolesItem(SubTemplateRole signerRolesItem) {
    if (this.signerRoles == null) {
      this.signerRoles = new ArrayList<>();
    }
    this.signerRoles.add(signerRolesItem);
    return this;
  }

  /**
   * An array of the designated signer roles that must be specified when sending a SignatureRequest using this Template.
   * @return signerRoles
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNER_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubTemplateRole> getSignerRoles() {
    return signerRoles;
  }


  @JsonProperty(JSON_PROPERTY_SIGNER_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignerRoles(List<SubTemplateRole> signerRoles) {
    this.signerRoles = signerRoles;
  }


  public TemplateCreateEmbeddedDraftRequest skipMeNow(Boolean skipMeNow) {
    this.skipMeNow = skipMeNow;
    return this;
  }

  /**
   * Disables the \&quot;Me (Now)\&quot; option for the person preparing the document. Does not work with type &#x60;send_document&#x60;. Defaults to &#x60;false&#x60;.
   * @return skipMeNow
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SKIP_ME_NOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSkipMeNow() {
    return skipMeNow;
  }


  @JsonProperty(JSON_PROPERTY_SKIP_ME_NOW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSkipMeNow(Boolean skipMeNow) {
    this.skipMeNow = skipMeNow;
  }


  public TemplateCreateEmbeddedDraftRequest subject(String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * The template title (alias).
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public TemplateCreateEmbeddedDraftRequest testMode(Boolean testMode) {
    this.testMode = testMode;
    return this;
  }

  /**
   * Whether this is a test, the signature request created from this draft will not be legally binding if set to &#x60;true&#x60;. Defaults to &#x60;false&#x60;.
   * @return testMode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTestMode() {
    return testMode;
  }


  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestMode(Boolean testMode) {
    this.testMode = testMode;
  }


  public TemplateCreateEmbeddedDraftRequest title(String title) {
    this.title = title;
    return this;
  }

  /**
   * The title you want to assign to the SignatureRequest.
   * @return title
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public TemplateCreateEmbeddedDraftRequest usePreexistingFields(Boolean usePreexistingFields) {
    this.usePreexistingFields = usePreexistingFields;
    return this;
  }

  /**
   * Enable the detection of predefined PDF fields by setting the &#x60;use_preexisting_fields&#x60; to &#x60;true&#x60; (defaults to disabled, or &#x60;false&#x60;).
   * @return usePreexistingFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USE_PREEXISTING_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUsePreexistingFields() {
    return usePreexistingFields;
  }


  @JsonProperty(JSON_PROPERTY_USE_PREEXISTING_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsePreexistingFields(Boolean usePreexistingFields) {
    this.usePreexistingFields = usePreexistingFields;
  }


  /**
   * Return true if this TemplateCreateEmbeddedDraftRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TemplateCreateEmbeddedDraftRequest templateCreateEmbeddedDraftRequest = (TemplateCreateEmbeddedDraftRequest) o;
    return Objects.equals(this.clientId, templateCreateEmbeddedDraftRequest.clientId) &&
        Objects.equals(this.files, templateCreateEmbeddedDraftRequest.files) &&
        Objects.equals(this.fileUrls, templateCreateEmbeddedDraftRequest.fileUrls) &&
        Objects.equals(this.allowCcs, templateCreateEmbeddedDraftRequest.allowCcs) &&
        Objects.equals(this.allowReassign, templateCreateEmbeddedDraftRequest.allowReassign) &&
        Objects.equals(this.attachments, templateCreateEmbeddedDraftRequest.attachments) &&
        Objects.equals(this.ccRoles, templateCreateEmbeddedDraftRequest.ccRoles) &&
        Objects.equals(this.editorOptions, templateCreateEmbeddedDraftRequest.editorOptions) &&
        Objects.equals(this.fieldOptions, templateCreateEmbeddedDraftRequest.fieldOptions) &&
        Objects.equals(this.forceSignerRoles, templateCreateEmbeddedDraftRequest.forceSignerRoles) &&
        Objects.equals(this.forceSubjectMessage, templateCreateEmbeddedDraftRequest.forceSubjectMessage) &&
        Objects.equals(this.formFieldGroups, templateCreateEmbeddedDraftRequest.formFieldGroups) &&
        Objects.equals(this.formFieldRules, templateCreateEmbeddedDraftRequest.formFieldRules) &&
        Objects.equals(this.formFieldsPerDocument, templateCreateEmbeddedDraftRequest.formFieldsPerDocument) &&
        Objects.equals(this.mergeFields, templateCreateEmbeddedDraftRequest.mergeFields) &&
        Objects.equals(this.message, templateCreateEmbeddedDraftRequest.message) &&
        Objects.equals(this.metadata, templateCreateEmbeddedDraftRequest.metadata) &&
        Objects.equals(this.showPreview, templateCreateEmbeddedDraftRequest.showPreview) &&
        Objects.equals(this.showProgressStepper, templateCreateEmbeddedDraftRequest.showProgressStepper) &&
        Objects.equals(this.signerRoles, templateCreateEmbeddedDraftRequest.signerRoles) &&
        Objects.equals(this.skipMeNow, templateCreateEmbeddedDraftRequest.skipMeNow) &&
        Objects.equals(this.subject, templateCreateEmbeddedDraftRequest.subject) &&
        Objects.equals(this.testMode, templateCreateEmbeddedDraftRequest.testMode) &&
        Objects.equals(this.title, templateCreateEmbeddedDraftRequest.title) &&
        Objects.equals(this.usePreexistingFields, templateCreateEmbeddedDraftRequest.usePreexistingFields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, files, fileUrls, allowCcs, allowReassign, attachments, ccRoles, editorOptions, fieldOptions, forceSignerRoles, forceSubjectMessage, formFieldGroups, formFieldRules, formFieldsPerDocument, mergeFields, message, metadata, showPreview, showProgressStepper, signerRoles, skipMeNow, subject, testMode, title, usePreexistingFields);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TemplateCreateEmbeddedDraftRequest {\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("    fileUrls: ").append(toIndentedString(fileUrls)).append("\n");
    sb.append("    allowCcs: ").append(toIndentedString(allowCcs)).append("\n");
    sb.append("    allowReassign: ").append(toIndentedString(allowReassign)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    ccRoles: ").append(toIndentedString(ccRoles)).append("\n");
    sb.append("    editorOptions: ").append(toIndentedString(editorOptions)).append("\n");
    sb.append("    fieldOptions: ").append(toIndentedString(fieldOptions)).append("\n");
    sb.append("    forceSignerRoles: ").append(toIndentedString(forceSignerRoles)).append("\n");
    sb.append("    forceSubjectMessage: ").append(toIndentedString(forceSubjectMessage)).append("\n");
    sb.append("    formFieldGroups: ").append(toIndentedString(formFieldGroups)).append("\n");
    sb.append("    formFieldRules: ").append(toIndentedString(formFieldRules)).append("\n");
    sb.append("    formFieldsPerDocument: ").append(toIndentedString(formFieldsPerDocument)).append("\n");
    sb.append("    mergeFields: ").append(toIndentedString(mergeFields)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    showPreview: ").append(toIndentedString(showPreview)).append("\n");
    sb.append("    showProgressStepper: ").append(toIndentedString(showProgressStepper)).append("\n");
    sb.append("    signerRoles: ").append(toIndentedString(signerRoles)).append("\n");
    sb.append("    skipMeNow: ").append(toIndentedString(skipMeNow)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    testMode: ").append(toIndentedString(testMode)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    usePreexistingFields: ").append(toIndentedString(usePreexistingFields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (clientId != null) {
        if (isFileTypeOrListOfFiles(clientId)) {
            fileTypeFound = true;
        }

        if (clientId.getClass().equals(java.io.File.class) ||
            clientId.getClass().equals(Integer.class) ||
            clientId.getClass().equals(String.class) ||
            clientId.getClass().isEnum()) {
            map.put("client_id", clientId);
        } else if (isListOfFile(clientId)) {
            for(int i = 0; i< getListSize(clientId); i++) {
                map.put("client_id[" + i + "]", getFromList(clientId, i));
            }
        }
        else {
            map.put("client_id", JSON.getDefault().getMapper().writeValueAsString(clientId));
        }
    }
    if (files != null) {
        if (isFileTypeOrListOfFiles(files)) {
            fileTypeFound = true;
        }

        if (files.getClass().equals(java.io.File.class) ||
            files.getClass().equals(Integer.class) ||
            files.getClass().equals(String.class) ||
            files.getClass().isEnum()) {
            map.put("files", files);
        } else if (isListOfFile(files)) {
            for(int i = 0; i< getListSize(files); i++) {
                map.put("files[" + i + "]", getFromList(files, i));
            }
        }
        else {
            map.put("files", JSON.getDefault().getMapper().writeValueAsString(files));
        }
    }
    if (fileUrls != null) {
        if (isFileTypeOrListOfFiles(fileUrls)) {
            fileTypeFound = true;
        }

        if (fileUrls.getClass().equals(java.io.File.class) ||
            fileUrls.getClass().equals(Integer.class) ||
            fileUrls.getClass().equals(String.class) ||
            fileUrls.getClass().isEnum()) {
            map.put("file_urls", fileUrls);
        } else if (isListOfFile(fileUrls)) {
            for(int i = 0; i< getListSize(fileUrls); i++) {
                map.put("file_urls[" + i + "]", getFromList(fileUrls, i));
            }
        }
        else {
            map.put("file_urls", JSON.getDefault().getMapper().writeValueAsString(fileUrls));
        }
    }
    if (allowCcs != null) {
        if (isFileTypeOrListOfFiles(allowCcs)) {
            fileTypeFound = true;
        }

        if (allowCcs.getClass().equals(java.io.File.class) ||
            allowCcs.getClass().equals(Integer.class) ||
            allowCcs.getClass().equals(String.class) ||
            allowCcs.getClass().isEnum()) {
            map.put("allow_ccs", allowCcs);
        } else if (isListOfFile(allowCcs)) {
            for(int i = 0; i< getListSize(allowCcs); i++) {
                map.put("allow_ccs[" + i + "]", getFromList(allowCcs, i));
            }
        }
        else {
            map.put("allow_ccs", JSON.getDefault().getMapper().writeValueAsString(allowCcs));
        }
    }
    if (allowReassign != null) {
        if (isFileTypeOrListOfFiles(allowReassign)) {
            fileTypeFound = true;
        }

        if (allowReassign.getClass().equals(java.io.File.class) ||
            allowReassign.getClass().equals(Integer.class) ||
            allowReassign.getClass().equals(String.class) ||
            allowReassign.getClass().isEnum()) {
            map.put("allow_reassign", allowReassign);
        } else if (isListOfFile(allowReassign)) {
            for(int i = 0; i< getListSize(allowReassign); i++) {
                map.put("allow_reassign[" + i + "]", getFromList(allowReassign, i));
            }
        }
        else {
            map.put("allow_reassign", JSON.getDefault().getMapper().writeValueAsString(allowReassign));
        }
    }
    if (attachments != null) {
        if (isFileTypeOrListOfFiles(attachments)) {
            fileTypeFound = true;
        }

        if (attachments.getClass().equals(java.io.File.class) ||
            attachments.getClass().equals(Integer.class) ||
            attachments.getClass().equals(String.class) ||
            attachments.getClass().isEnum()) {
            map.put("attachments", attachments);
        } else if (isListOfFile(attachments)) {
            for(int i = 0; i< getListSize(attachments); i++) {
                map.put("attachments[" + i + "]", getFromList(attachments, i));
            }
        }
        else {
            map.put("attachments", JSON.getDefault().getMapper().writeValueAsString(attachments));
        }
    }
    if (ccRoles != null) {
        if (isFileTypeOrListOfFiles(ccRoles)) {
            fileTypeFound = true;
        }

        if (ccRoles.getClass().equals(java.io.File.class) ||
            ccRoles.getClass().equals(Integer.class) ||
            ccRoles.getClass().equals(String.class) ||
            ccRoles.getClass().isEnum()) {
            map.put("cc_roles", ccRoles);
        } else if (isListOfFile(ccRoles)) {
            for(int i = 0; i< getListSize(ccRoles); i++) {
                map.put("cc_roles[" + i + "]", getFromList(ccRoles, i));
            }
        }
        else {
            map.put("cc_roles", JSON.getDefault().getMapper().writeValueAsString(ccRoles));
        }
    }
    if (editorOptions != null) {
        if (isFileTypeOrListOfFiles(editorOptions)) {
            fileTypeFound = true;
        }

        if (editorOptions.getClass().equals(java.io.File.class) ||
            editorOptions.getClass().equals(Integer.class) ||
            editorOptions.getClass().equals(String.class) ||
            editorOptions.getClass().isEnum()) {
            map.put("editor_options", editorOptions);
        } else if (isListOfFile(editorOptions)) {
            for(int i = 0; i< getListSize(editorOptions); i++) {
                map.put("editor_options[" + i + "]", getFromList(editorOptions, i));
            }
        }
        else {
            map.put("editor_options", JSON.getDefault().getMapper().writeValueAsString(editorOptions));
        }
    }
    if (fieldOptions != null) {
        if (isFileTypeOrListOfFiles(fieldOptions)) {
            fileTypeFound = true;
        }

        if (fieldOptions.getClass().equals(java.io.File.class) ||
            fieldOptions.getClass().equals(Integer.class) ||
            fieldOptions.getClass().equals(String.class) ||
            fieldOptions.getClass().isEnum()) {
            map.put("field_options", fieldOptions);
        } else if (isListOfFile(fieldOptions)) {
            for(int i = 0; i< getListSize(fieldOptions); i++) {
                map.put("field_options[" + i + "]", getFromList(fieldOptions, i));
            }
        }
        else {
            map.put("field_options", JSON.getDefault().getMapper().writeValueAsString(fieldOptions));
        }
    }
    if (forceSignerRoles != null) {
        if (isFileTypeOrListOfFiles(forceSignerRoles)) {
            fileTypeFound = true;
        }

        if (forceSignerRoles.getClass().equals(java.io.File.class) ||
            forceSignerRoles.getClass().equals(Integer.class) ||
            forceSignerRoles.getClass().equals(String.class) ||
            forceSignerRoles.getClass().isEnum()) {
            map.put("force_signer_roles", forceSignerRoles);
        } else if (isListOfFile(forceSignerRoles)) {
            for(int i = 0; i< getListSize(forceSignerRoles); i++) {
                map.put("force_signer_roles[" + i + "]", getFromList(forceSignerRoles, i));
            }
        }
        else {
            map.put("force_signer_roles", JSON.getDefault().getMapper().writeValueAsString(forceSignerRoles));
        }
    }
    if (forceSubjectMessage != null) {
        if (isFileTypeOrListOfFiles(forceSubjectMessage)) {
            fileTypeFound = true;
        }

        if (forceSubjectMessage.getClass().equals(java.io.File.class) ||
            forceSubjectMessage.getClass().equals(Integer.class) ||
            forceSubjectMessage.getClass().equals(String.class) ||
            forceSubjectMessage.getClass().isEnum()) {
            map.put("force_subject_message", forceSubjectMessage);
        } else if (isListOfFile(forceSubjectMessage)) {
            for(int i = 0; i< getListSize(forceSubjectMessage); i++) {
                map.put("force_subject_message[" + i + "]", getFromList(forceSubjectMessage, i));
            }
        }
        else {
            map.put("force_subject_message", JSON.getDefault().getMapper().writeValueAsString(forceSubjectMessage));
        }
    }
    if (formFieldGroups != null) {
        if (isFileTypeOrListOfFiles(formFieldGroups)) {
            fileTypeFound = true;
        }

        if (formFieldGroups.getClass().equals(java.io.File.class) ||
            formFieldGroups.getClass().equals(Integer.class) ||
            formFieldGroups.getClass().equals(String.class) ||
            formFieldGroups.getClass().isEnum()) {
            map.put("form_field_groups", formFieldGroups);
        } else if (isListOfFile(formFieldGroups)) {
            for(int i = 0; i< getListSize(formFieldGroups); i++) {
                map.put("form_field_groups[" + i + "]", getFromList(formFieldGroups, i));
            }
        }
        else {
            map.put("form_field_groups", JSON.getDefault().getMapper().writeValueAsString(formFieldGroups));
        }
    }
    if (formFieldRules != null) {
        if (isFileTypeOrListOfFiles(formFieldRules)) {
            fileTypeFound = true;
        }

        if (formFieldRules.getClass().equals(java.io.File.class) ||
            formFieldRules.getClass().equals(Integer.class) ||
            formFieldRules.getClass().equals(String.class) ||
            formFieldRules.getClass().isEnum()) {
            map.put("form_field_rules", formFieldRules);
        } else if (isListOfFile(formFieldRules)) {
            for(int i = 0; i< getListSize(formFieldRules); i++) {
                map.put("form_field_rules[" + i + "]", getFromList(formFieldRules, i));
            }
        }
        else {
            map.put("form_field_rules", JSON.getDefault().getMapper().writeValueAsString(formFieldRules));
        }
    }
    if (formFieldsPerDocument != null) {
        if (isFileTypeOrListOfFiles(formFieldsPerDocument)) {
            fileTypeFound = true;
        }

        if (formFieldsPerDocument.getClass().equals(java.io.File.class) ||
            formFieldsPerDocument.getClass().equals(Integer.class) ||
            formFieldsPerDocument.getClass().equals(String.class) ||
            formFieldsPerDocument.getClass().isEnum()) {
            map.put("form_fields_per_document", formFieldsPerDocument);
        } else if (isListOfFile(formFieldsPerDocument)) {
            for(int i = 0; i< getListSize(formFieldsPerDocument); i++) {
                map.put("form_fields_per_document[" + i + "]", getFromList(formFieldsPerDocument, i));
            }
        }
        else {
            map.put("form_fields_per_document", JSON.getDefault().getMapper().writeValueAsString(formFieldsPerDocument));
        }
    }
    if (mergeFields != null) {
        if (isFileTypeOrListOfFiles(mergeFields)) {
            fileTypeFound = true;
        }

        if (mergeFields.getClass().equals(java.io.File.class) ||
            mergeFields.getClass().equals(Integer.class) ||
            mergeFields.getClass().equals(String.class) ||
            mergeFields.getClass().isEnum()) {
            map.put("merge_fields", mergeFields);
        } else if (isListOfFile(mergeFields)) {
            for(int i = 0; i< getListSize(mergeFields); i++) {
                map.put("merge_fields[" + i + "]", getFromList(mergeFields, i));
            }
        }
        else {
            map.put("merge_fields", JSON.getDefault().getMapper().writeValueAsString(mergeFields));
        }
    }
    if (message != null) {
        if (isFileTypeOrListOfFiles(message)) {
            fileTypeFound = true;
        }

        if (message.getClass().equals(java.io.File.class) ||
            message.getClass().equals(Integer.class) ||
            message.getClass().equals(String.class) ||
            message.getClass().isEnum()) {
            map.put("message", message);
        } else if (isListOfFile(message)) {
            for(int i = 0; i< getListSize(message); i++) {
                map.put("message[" + i + "]", getFromList(message, i));
            }
        }
        else {
            map.put("message", JSON.getDefault().getMapper().writeValueAsString(message));
        }
    }
    if (metadata != null) {
        if (isFileTypeOrListOfFiles(metadata)) {
            fileTypeFound = true;
        }

        if (metadata.getClass().equals(java.io.File.class) ||
            metadata.getClass().equals(Integer.class) ||
            metadata.getClass().equals(String.class) ||
            metadata.getClass().isEnum()) {
            map.put("metadata", metadata);
        } else if (isListOfFile(metadata)) {
            for(int i = 0; i< getListSize(metadata); i++) {
                map.put("metadata[" + i + "]", getFromList(metadata, i));
            }
        }
        else {
            map.put("metadata", JSON.getDefault().getMapper().writeValueAsString(metadata));
        }
    }
    if (showPreview != null) {
        if (isFileTypeOrListOfFiles(showPreview)) {
            fileTypeFound = true;
        }

        if (showPreview.getClass().equals(java.io.File.class) ||
            showPreview.getClass().equals(Integer.class) ||
            showPreview.getClass().equals(String.class) ||
            showPreview.getClass().isEnum()) {
            map.put("show_preview", showPreview);
        } else if (isListOfFile(showPreview)) {
            for(int i = 0; i< getListSize(showPreview); i++) {
                map.put("show_preview[" + i + "]", getFromList(showPreview, i));
            }
        }
        else {
            map.put("show_preview", JSON.getDefault().getMapper().writeValueAsString(showPreview));
        }
    }
    if (showProgressStepper != null) {
        if (isFileTypeOrListOfFiles(showProgressStepper)) {
            fileTypeFound = true;
        }

        if (showProgressStepper.getClass().equals(java.io.File.class) ||
            showProgressStepper.getClass().equals(Integer.class) ||
            showProgressStepper.getClass().equals(String.class) ||
            showProgressStepper.getClass().isEnum()) {
            map.put("show_progress_stepper", showProgressStepper);
        } else if (isListOfFile(showProgressStepper)) {
            for(int i = 0; i< getListSize(showProgressStepper); i++) {
                map.put("show_progress_stepper[" + i + "]", getFromList(showProgressStepper, i));
            }
        }
        else {
            map.put("show_progress_stepper", JSON.getDefault().getMapper().writeValueAsString(showProgressStepper));
        }
    }
    if (signerRoles != null) {
        if (isFileTypeOrListOfFiles(signerRoles)) {
            fileTypeFound = true;
        }

        if (signerRoles.getClass().equals(java.io.File.class) ||
            signerRoles.getClass().equals(Integer.class) ||
            signerRoles.getClass().equals(String.class) ||
            signerRoles.getClass().isEnum()) {
            map.put("signer_roles", signerRoles);
        } else if (isListOfFile(signerRoles)) {
            for(int i = 0; i< getListSize(signerRoles); i++) {
                map.put("signer_roles[" + i + "]", getFromList(signerRoles, i));
            }
        }
        else {
            map.put("signer_roles", JSON.getDefault().getMapper().writeValueAsString(signerRoles));
        }
    }
    if (skipMeNow != null) {
        if (isFileTypeOrListOfFiles(skipMeNow)) {
            fileTypeFound = true;
        }

        if (skipMeNow.getClass().equals(java.io.File.class) ||
            skipMeNow.getClass().equals(Integer.class) ||
            skipMeNow.getClass().equals(String.class) ||
            skipMeNow.getClass().isEnum()) {
            map.put("skip_me_now", skipMeNow);
        } else if (isListOfFile(skipMeNow)) {
            for(int i = 0; i< getListSize(skipMeNow); i++) {
                map.put("skip_me_now[" + i + "]", getFromList(skipMeNow, i));
            }
        }
        else {
            map.put("skip_me_now", JSON.getDefault().getMapper().writeValueAsString(skipMeNow));
        }
    }
    if (subject != null) {
        if (isFileTypeOrListOfFiles(subject)) {
            fileTypeFound = true;
        }

        if (subject.getClass().equals(java.io.File.class) ||
            subject.getClass().equals(Integer.class) ||
            subject.getClass().equals(String.class) ||
            subject.getClass().isEnum()) {
            map.put("subject", subject);
        } else if (isListOfFile(subject)) {
            for(int i = 0; i< getListSize(subject); i++) {
                map.put("subject[" + i + "]", getFromList(subject, i));
            }
        }
        else {
            map.put("subject", JSON.getDefault().getMapper().writeValueAsString(subject));
        }
    }
    if (testMode != null) {
        if (isFileTypeOrListOfFiles(testMode)) {
            fileTypeFound = true;
        }

        if (testMode.getClass().equals(java.io.File.class) ||
            testMode.getClass().equals(Integer.class) ||
            testMode.getClass().equals(String.class) ||
            testMode.getClass().isEnum()) {
            map.put("test_mode", testMode);
        } else if (isListOfFile(testMode)) {
            for(int i = 0; i< getListSize(testMode); i++) {
                map.put("test_mode[" + i + "]", getFromList(testMode, i));
            }
        }
        else {
            map.put("test_mode", JSON.getDefault().getMapper().writeValueAsString(testMode));
        }
    }
    if (title != null) {
        if (isFileTypeOrListOfFiles(title)) {
            fileTypeFound = true;
        }

        if (title.getClass().equals(java.io.File.class) ||
            title.getClass().equals(Integer.class) ||
            title.getClass().equals(String.class) ||
            title.getClass().isEnum()) {
            map.put("title", title);
        } else if (isListOfFile(title)) {
            for(int i = 0; i< getListSize(title); i++) {
                map.put("title[" + i + "]", getFromList(title, i));
            }
        }
        else {
            map.put("title", JSON.getDefault().getMapper().writeValueAsString(title));
        }
    }
    if (usePreexistingFields != null) {
        if (isFileTypeOrListOfFiles(usePreexistingFields)) {
            fileTypeFound = true;
        }

        if (usePreexistingFields.getClass().equals(java.io.File.class) ||
            usePreexistingFields.getClass().equals(Integer.class) ||
            usePreexistingFields.getClass().equals(String.class) ||
            usePreexistingFields.getClass().isEnum()) {
            map.put("use_preexisting_fields", usePreexistingFields);
        } else if (isListOfFile(usePreexistingFields)) {
            for(int i = 0; i< getListSize(usePreexistingFields); i++) {
                map.put("use_preexisting_fields[" + i + "]", getFromList(usePreexistingFields, i));
            }
        }
        else {
            map.put("use_preexisting_fields", JSON.getDefault().getMapper().writeValueAsString(usePreexistingFields));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

