/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.TeamMemberResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * TeamMembersResponse
 */
@JsonPropertyOrder({
  TeamMembersResponse.JSON_PROPERTY_TEAM_MEMBERS,
  TeamMembersResponse.JSON_PROPERTY_LIST_INFO,
  TeamMembersResponse.JSON_PROPERTY_WARNINGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class TeamMembersResponse {
  public static final String JSON_PROPERTY_TEAM_MEMBERS = "team_members";
  private List<TeamMemberResponse> teamMembers = new ArrayList<>();

  public static final String JSON_PROPERTY_LIST_INFO = "list_info";
  private ListInfoResponse listInfo;

  public static final String JSON_PROPERTY_WARNINGS = "warnings";
  private List<WarningResponse> warnings = null;

  public TeamMembersResponse() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public TeamMembersResponse init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, TeamMembersResponse.class);
  }

  static public TeamMembersResponse init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      TeamMembersResponse.class
    );
  }

  public TeamMembersResponse teamMembers(List<TeamMemberResponse> teamMembers) {
    this.teamMembers = teamMembers;
    return this;
  }

  public TeamMembersResponse addTeamMembersItem(TeamMemberResponse teamMembersItem) {
    if (this.teamMembers == null) {
      this.teamMembers = new ArrayList<>();
    }
    this.teamMembers.add(teamMembersItem);
    return this;
  }

  /**
   * Contains a list of team members and their roles for a specific team.
   * @return teamMembers
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEAM_MEMBERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<TeamMemberResponse> getTeamMembers() {
    return teamMembers;
  }


  @JsonProperty(JSON_PROPERTY_TEAM_MEMBERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTeamMembers(List<TeamMemberResponse> teamMembers) {
    this.teamMembers = teamMembers;
  }


  public TeamMembersResponse listInfo(ListInfoResponse listInfo) {
    this.listInfo = listInfo;
    return this;
  }

  /**
   * Get listInfo
   * @return listInfo
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LIST_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ListInfoResponse getListInfo() {
    return listInfo;
  }


  @JsonProperty(JSON_PROPERTY_LIST_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListInfo(ListInfoResponse listInfo) {
    this.listInfo = listInfo;
  }


  public TeamMembersResponse warnings(List<WarningResponse> warnings) {
    this.warnings = warnings;
    return this;
  }

  public TeamMembersResponse addWarningsItem(WarningResponse warningsItem) {
    if (this.warnings == null) {
      this.warnings = new ArrayList<>();
    }
    this.warnings.add(warningsItem);
    return this;
  }

  /**
   * Get warnings
   * @return warnings
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WARNINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<WarningResponse> getWarnings() {
    return warnings;
  }


  @JsonProperty(JSON_PROPERTY_WARNINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWarnings(List<WarningResponse> warnings) {
    this.warnings = warnings;
  }


  /**
   * Return true if this TeamMembersResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TeamMembersResponse teamMembersResponse = (TeamMembersResponse) o;
    return Objects.equals(this.teamMembers, teamMembersResponse.teamMembers) &&
        Objects.equals(this.listInfo, teamMembersResponse.listInfo) &&
        Objects.equals(this.warnings, teamMembersResponse.warnings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(teamMembers, listInfo, warnings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TeamMembersResponse {\n");
    sb.append("    teamMembers: ").append(toIndentedString(teamMembers)).append("\n");
    sb.append("    listInfo: ").append(toIndentedString(listInfo)).append("\n");
    sb.append("    warnings: ").append(toIndentedString(warnings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (teamMembers != null) {
        if (isFileTypeOrListOfFiles(teamMembers)) {
            fileTypeFound = true;
        }

        if (teamMembers.getClass().equals(java.io.File.class) ||
            teamMembers.getClass().equals(Integer.class) ||
            teamMembers.getClass().equals(String.class) ||
            teamMembers.getClass().isEnum()) {
            map.put("team_members", teamMembers);
        } else if (isListOfFile(teamMembers)) {
            for(int i = 0; i< getListSize(teamMembers); i++) {
                map.put("team_members[" + i + "]", getFromList(teamMembers, i));
            }
        }
        else {
            map.put("team_members", JSON.getDefault().getMapper().writeValueAsString(teamMembers));
        }
    }
    if (listInfo != null) {
        if (isFileTypeOrListOfFiles(listInfo)) {
            fileTypeFound = true;
        }

        if (listInfo.getClass().equals(java.io.File.class) ||
            listInfo.getClass().equals(Integer.class) ||
            listInfo.getClass().equals(String.class) ||
            listInfo.getClass().isEnum()) {
            map.put("list_info", listInfo);
        } else if (isListOfFile(listInfo)) {
            for(int i = 0; i< getListSize(listInfo); i++) {
                map.put("list_info[" + i + "]", getFromList(listInfo, i));
            }
        }
        else {
            map.put("list_info", JSON.getDefault().getMapper().writeValueAsString(listInfo));
        }
    }
    if (warnings != null) {
        if (isFileTypeOrListOfFiles(warnings)) {
            fileTypeFound = true;
        }

        if (warnings.getClass().equals(java.io.File.class) ||
            warnings.getClass().equals(Integer.class) ||
            warnings.getClass().equals(String.class) ||
            warnings.getClass().isEnum()) {
            map.put("warnings", warnings);
        } else if (isListOfFile(warnings)) {
            for(int i = 0; i< getListSize(warnings); i++) {
                map.put("warnings[" + i + "]", getFromList(warnings, i));
            }
        }
        else {
            map.put("warnings", JSON.getDefault().getMapper().writeValueAsString(warnings));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

