/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * SubAttachment
 */
@JsonPropertyOrder({
  SubAttachment.JSON_PROPERTY_NAME,
  SubAttachment.JSON_PROPERTY_SIGNER_INDEX,
  SubAttachment.JSON_PROPERTY_INSTRUCTIONS,
  SubAttachment.JSON_PROPERTY_REQUIRED
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SubAttachment {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SIGNER_INDEX = "signer_index";
  private Integer signerIndex;

  public static final String JSON_PROPERTY_INSTRUCTIONS = "instructions";
  private String instructions;

  public static final String JSON_PROPERTY_REQUIRED = "required";
  private Boolean required = false;

  public SubAttachment() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public SubAttachment init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, SubAttachment.class);
  }

  static public SubAttachment init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      SubAttachment.class
    );
  }

  public SubAttachment name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of attachment.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public SubAttachment signerIndex(Integer signerIndex) {
    this.signerIndex = signerIndex;
    return this;
  }

  /**
   * The signer&#39;s index in the &#x60;signers&#x60; parameter (0-based indexing).  **NOTE:** Only one signer can be assigned per attachment.
   * @return signerIndex
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SIGNER_INDEX)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSignerIndex() {
    return signerIndex;
  }


  @JsonProperty(JSON_PROPERTY_SIGNER_INDEX)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSignerIndex(Integer signerIndex) {
    this.signerIndex = signerIndex;
  }


  public SubAttachment instructions(String instructions) {
    this.instructions = instructions;
    return this;
  }

  /**
   * The instructions for uploading the attachment.
   * @return instructions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInstructions() {
    return instructions;
  }


  @JsonProperty(JSON_PROPERTY_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInstructions(String instructions) {
    this.instructions = instructions;
  }


  public SubAttachment required(Boolean required) {
    this.required = required;
    return this;
  }

  /**
   * Determines if the attachment must be uploaded.
   * @return required
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRequired() {
    return required;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequired(Boolean required) {
    this.required = required;
  }


  /**
   * Return true if this SubAttachment object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubAttachment subAttachment = (SubAttachment) o;
    return Objects.equals(this.name, subAttachment.name) &&
        Objects.equals(this.signerIndex, subAttachment.signerIndex) &&
        Objects.equals(this.instructions, subAttachment.instructions) &&
        Objects.equals(this.required, subAttachment.required);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, signerIndex, instructions, required);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubAttachment {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    signerIndex: ").append(toIndentedString(signerIndex)).append("\n");
    sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (name != null) {
        if (isFileTypeOrListOfFiles(name)) {
            fileTypeFound = true;
        }

        if (name.getClass().equals(java.io.File.class) ||
            name.getClass().equals(Integer.class) ||
            name.getClass().equals(String.class) ||
            name.getClass().isEnum()) {
            map.put("name", name);
        } else if (isListOfFile(name)) {
            for(int i = 0; i< getListSize(name); i++) {
                map.put("name[" + i + "]", getFromList(name, i));
            }
        }
        else {
            map.put("name", JSON.getDefault().getMapper().writeValueAsString(name));
        }
    }
    if (signerIndex != null) {
        if (isFileTypeOrListOfFiles(signerIndex)) {
            fileTypeFound = true;
        }

        if (signerIndex.getClass().equals(java.io.File.class) ||
            signerIndex.getClass().equals(Integer.class) ||
            signerIndex.getClass().equals(String.class) ||
            signerIndex.getClass().isEnum()) {
            map.put("signer_index", signerIndex);
        } else if (isListOfFile(signerIndex)) {
            for(int i = 0; i< getListSize(signerIndex); i++) {
                map.put("signer_index[" + i + "]", getFromList(signerIndex, i));
            }
        }
        else {
            map.put("signer_index", JSON.getDefault().getMapper().writeValueAsString(signerIndex));
        }
    }
    if (instructions != null) {
        if (isFileTypeOrListOfFiles(instructions)) {
            fileTypeFound = true;
        }

        if (instructions.getClass().equals(java.io.File.class) ||
            instructions.getClass().equals(Integer.class) ||
            instructions.getClass().equals(String.class) ||
            instructions.getClass().isEnum()) {
            map.put("instructions", instructions);
        } else if (isListOfFile(instructions)) {
            for(int i = 0; i< getListSize(instructions); i++) {
                map.put("instructions[" + i + "]", getFromList(instructions, i));
            }
        }
        else {
            map.put("instructions", JSON.getDefault().getMapper().writeValueAsString(instructions));
        }
    }
    if (required != null) {
        if (isFileTypeOrListOfFiles(required)) {
            fileTypeFound = true;
        }

        if (required.getClass().equals(java.io.File.class) ||
            required.getClass().equals(Integer.class) ||
            required.getClass().equals(String.class) ||
            required.getClass().isEnum()) {
            map.put("required", required);
        } else if (isListOfFile(required)) {
            for(int i = 0; i< getListSize(required); i++) {
                map.put("required[" + i + "]", getFromList(required, i));
            }
        }
        else {
            map.put("required", JSON.getDefault().getMapper().writeValueAsString(required));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

