/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.dropbox.sign.model.SignatureRequestResponseAttachment;
import com.dropbox.sign.model.SignatureRequestResponseCustomFieldBase;
import com.dropbox.sign.model.SignatureRequestResponseDataBase;
import com.dropbox.sign.model.SignatureRequestResponseSignatures;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * Contains information about a signature request.
 */
@JsonPropertyOrder({
  SignatureRequestResponse.JSON_PROPERTY_TEST_MODE,
  SignatureRequestResponse.JSON_PROPERTY_SIGNATURE_REQUEST_ID,
  SignatureRequestResponse.JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS,
  SignatureRequestResponse.JSON_PROPERTY_TITLE,
  SignatureRequestResponse.JSON_PROPERTY_ORIGINAL_TITLE,
  SignatureRequestResponse.JSON_PROPERTY_SUBJECT,
  SignatureRequestResponse.JSON_PROPERTY_MESSAGE,
  SignatureRequestResponse.JSON_PROPERTY_METADATA,
  SignatureRequestResponse.JSON_PROPERTY_CREATED_AT,
  SignatureRequestResponse.JSON_PROPERTY_EXPIRES_AT,
  SignatureRequestResponse.JSON_PROPERTY_IS_COMPLETE,
  SignatureRequestResponse.JSON_PROPERTY_IS_DECLINED,
  SignatureRequestResponse.JSON_PROPERTY_HAS_ERROR,
  SignatureRequestResponse.JSON_PROPERTY_FILES_URL,
  SignatureRequestResponse.JSON_PROPERTY_SIGNING_URL,
  SignatureRequestResponse.JSON_PROPERTY_DETAILS_URL,
  SignatureRequestResponse.JSON_PROPERTY_CC_EMAIL_ADDRESSES,
  SignatureRequestResponse.JSON_PROPERTY_SIGNING_REDIRECT_URL,
  SignatureRequestResponse.JSON_PROPERTY_FINAL_COPY_URI,
  SignatureRequestResponse.JSON_PROPERTY_TEMPLATE_IDS,
  SignatureRequestResponse.JSON_PROPERTY_CUSTOM_FIELDS,
  SignatureRequestResponse.JSON_PROPERTY_ATTACHMENTS,
  SignatureRequestResponse.JSON_PROPERTY_RESPONSE_DATA,
  SignatureRequestResponse.JSON_PROPERTY_SIGNATURES,
  SignatureRequestResponse.JSON_PROPERTY_BULK_SEND_JOB_ID
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class SignatureRequestResponse {
  public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
  private Boolean testMode = false;

  public static final String JSON_PROPERTY_SIGNATURE_REQUEST_ID = "signature_request_id";
  private String signatureRequestId;

  public static final String JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS = "requester_email_address";
  private String requesterEmailAddress;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_ORIGINAL_TITLE = "original_title";
  private String originalTitle;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, Object> metadata = null;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private Integer createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
  private Integer expiresAt;

  public static final String JSON_PROPERTY_IS_COMPLETE = "is_complete";
  private Boolean isComplete;

  public static final String JSON_PROPERTY_IS_DECLINED = "is_declined";
  private Boolean isDeclined;

  public static final String JSON_PROPERTY_HAS_ERROR = "has_error";
  private Boolean hasError;

  public static final String JSON_PROPERTY_FILES_URL = "files_url";
  private String filesUrl;

  public static final String JSON_PROPERTY_SIGNING_URL = "signing_url";
  private String signingUrl;

  public static final String JSON_PROPERTY_DETAILS_URL = "details_url";
  private String detailsUrl;

  public static final String JSON_PROPERTY_CC_EMAIL_ADDRESSES = "cc_email_addresses";
  private List<String> ccEmailAddresses = null;

  public static final String JSON_PROPERTY_SIGNING_REDIRECT_URL = "signing_redirect_url";
  private String signingRedirectUrl;

  public static final String JSON_PROPERTY_FINAL_COPY_URI = "final_copy_uri";
  private String finalCopyUri;

  public static final String JSON_PROPERTY_TEMPLATE_IDS = "template_ids";
  private List<String> templateIds = null;

  public static final String JSON_PROPERTY_CUSTOM_FIELDS = "custom_fields";
  private List<SignatureRequestResponseCustomFieldBase> customFields = null;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private List<SignatureRequestResponseAttachment> attachments = null;

  public static final String JSON_PROPERTY_RESPONSE_DATA = "response_data";
  private List<SignatureRequestResponseDataBase> responseData = null;

  public static final String JSON_PROPERTY_SIGNATURES = "signatures";
  private List<SignatureRequestResponseSignatures> signatures = null;

  public static final String JSON_PROPERTY_BULK_SEND_JOB_ID = "bulk_send_job_id";
  private String bulkSendJobId;

  public SignatureRequestResponse() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public SignatureRequestResponse init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, SignatureRequestResponse.class);
  }

  static public SignatureRequestResponse init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      SignatureRequestResponse.class
    );
  }

  public SignatureRequestResponse testMode(Boolean testMode) {
    this.testMode = testMode;
    return this;
  }

  /**
   * Whether this is a test signature request. Test requests have no legal value. Defaults to &#x60;false&#x60;.
   * @return testMode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTestMode() {
    return testMode;
  }


  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestMode(Boolean testMode) {
    this.testMode = testMode;
  }


  public SignatureRequestResponse signatureRequestId(String signatureRequestId) {
    this.signatureRequestId = signatureRequestId;
    return this;
  }

  /**
   * The id of the SignatureRequest.
   * @return signatureRequestId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNATURE_REQUEST_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSignatureRequestId() {
    return signatureRequestId;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURE_REQUEST_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatureRequestId(String signatureRequestId) {
    this.signatureRequestId = signatureRequestId;
  }


  public SignatureRequestResponse requesterEmailAddress(String requesterEmailAddress) {
    this.requesterEmailAddress = requesterEmailAddress;
    return this;
  }

  /**
   * The email address of the initiator of the SignatureRequest.
   * @return requesterEmailAddress
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRequesterEmailAddress() {
    return requesterEmailAddress;
  }


  @JsonProperty(JSON_PROPERTY_REQUESTER_EMAIL_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequesterEmailAddress(String requesterEmailAddress) {
    this.requesterEmailAddress = requesterEmailAddress;
  }


  public SignatureRequestResponse title(String title) {
    this.title = title;
    return this;
  }

  /**
   * The title the specified Account uses for the SignatureRequest.
   * @return title
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public SignatureRequestResponse originalTitle(String originalTitle) {
    this.originalTitle = originalTitle;
    return this;
  }

  /**
   * Default Label for account.
   * @return originalTitle
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORIGINAL_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOriginalTitle() {
    return originalTitle;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalTitle(String originalTitle) {
    this.originalTitle = originalTitle;
  }


  public SignatureRequestResponse subject(String subject) {
    this.subject = subject;
    return this;
  }

  /**
   * The subject in the email that was initially sent to the signers.
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public SignatureRequestResponse message(String message) {
    this.message = message;
    return this;
  }

  /**
   * The custom message in the email that was initially sent to the signers.
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(String message) {
    this.message = message;
  }


  public SignatureRequestResponse metadata(Map<String, Object> metadata) {
    this.metadata = metadata;
    return this;
  }

  public SignatureRequestResponse putMetadataItem(String key, Object metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

  /**
   * The metadata attached to the signature request.
   * @return metadata
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, Object> metadata) {
    this.metadata = metadata;
  }


  public SignatureRequestResponse createdAt(Integer createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Time the signature request was created.
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(Integer createdAt) {
    this.createdAt = createdAt;
  }


  public SignatureRequestResponse expiresAt(Integer expiresAt) {
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * The time when the signature request will expire unsigned signatures. See [Signature Request Expiration Date](https://developers.hellosign.com/docs/signature-request/expiration/) for details.
   * @return expiresAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(Integer expiresAt) {
    this.expiresAt = expiresAt;
  }


  public SignatureRequestResponse isComplete(Boolean isComplete) {
    this.isComplete = isComplete;
    return this;
  }

  /**
   * Whether or not the SignatureRequest has been fully executed by all signers.
   * @return isComplete
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsComplete() {
    return isComplete;
  }


  @JsonProperty(JSON_PROPERTY_IS_COMPLETE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsComplete(Boolean isComplete) {
    this.isComplete = isComplete;
  }


  public SignatureRequestResponse isDeclined(Boolean isDeclined) {
    this.isDeclined = isDeclined;
    return this;
  }

  /**
   * Whether or not the SignatureRequest has been declined by a signer.
   * @return isDeclined
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_DECLINED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsDeclined() {
    return isDeclined;
  }


  @JsonProperty(JSON_PROPERTY_IS_DECLINED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsDeclined(Boolean isDeclined) {
    this.isDeclined = isDeclined;
  }


  public SignatureRequestResponse hasError(Boolean hasError) {
    this.hasError = hasError;
    return this;
  }

  /**
   * Whether or not an error occurred (either during the creation of the SignatureRequest or during one of the signings).
   * @return hasError
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasError() {
    return hasError;
  }


  @JsonProperty(JSON_PROPERTY_HAS_ERROR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasError(Boolean hasError) {
    this.hasError = hasError;
  }


  public SignatureRequestResponse filesUrl(String filesUrl) {
    this.filesUrl = filesUrl;
    return this;
  }

  /**
   * The URL where a copy of the request&#39;s documents can be downloaded.
   * @return filesUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILES_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFilesUrl() {
    return filesUrl;
  }


  @JsonProperty(JSON_PROPERTY_FILES_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFilesUrl(String filesUrl) {
    this.filesUrl = filesUrl;
  }


  public SignatureRequestResponse signingUrl(String signingUrl) {
    this.signingUrl = signingUrl;
    return this;
  }

  /**
   * The URL where a signer, after authenticating, can sign the documents. This should only be used by users with existing Dropbox Sign accounts as they will be required to log in before signing.
   * @return signingUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNING_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSigningUrl() {
    return signingUrl;
  }


  @JsonProperty(JSON_PROPERTY_SIGNING_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSigningUrl(String signingUrl) {
    this.signingUrl = signingUrl;
  }


  public SignatureRequestResponse detailsUrl(String detailsUrl) {
    this.detailsUrl = detailsUrl;
    return this;
  }

  /**
   * The URL where the requester and the signers can view the current status of the SignatureRequest.
   * @return detailsUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DETAILS_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDetailsUrl() {
    return detailsUrl;
  }


  @JsonProperty(JSON_PROPERTY_DETAILS_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDetailsUrl(String detailsUrl) {
    this.detailsUrl = detailsUrl;
  }


  public SignatureRequestResponse ccEmailAddresses(List<String> ccEmailAddresses) {
    this.ccEmailAddresses = ccEmailAddresses;
    return this;
  }

  public SignatureRequestResponse addCcEmailAddressesItem(String ccEmailAddressesItem) {
    if (this.ccEmailAddresses == null) {
      this.ccEmailAddresses = new ArrayList<>();
    }
    this.ccEmailAddresses.add(ccEmailAddressesItem);
    return this;
  }

  /**
   * A list of email addresses that were CCed on the SignatureRequest. They will receive a copy of the final PDF once all the signers have signed.
   * @return ccEmailAddresses
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC_EMAIL_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCcEmailAddresses() {
    return ccEmailAddresses;
  }


  @JsonProperty(JSON_PROPERTY_CC_EMAIL_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCcEmailAddresses(List<String> ccEmailAddresses) {
    this.ccEmailAddresses = ccEmailAddresses;
  }


  public SignatureRequestResponse signingRedirectUrl(String signingRedirectUrl) {
    this.signingRedirectUrl = signingRedirectUrl;
    return this;
  }

  /**
   * The URL you want the signer redirected to after they successfully sign.
   * @return signingRedirectUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNING_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSigningRedirectUrl() {
    return signingRedirectUrl;
  }


  @JsonProperty(JSON_PROPERTY_SIGNING_REDIRECT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSigningRedirectUrl(String signingRedirectUrl) {
    this.signingRedirectUrl = signingRedirectUrl;
  }


  public SignatureRequestResponse finalCopyUri(String finalCopyUri) {
    this.finalCopyUri = finalCopyUri;
    return this;
  }

  /**
   * The path where the completed document can be downloaded
   * @return finalCopyUri
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FINAL_COPY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFinalCopyUri() {
    return finalCopyUri;
  }


  @JsonProperty(JSON_PROPERTY_FINAL_COPY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFinalCopyUri(String finalCopyUri) {
    this.finalCopyUri = finalCopyUri;
  }


  public SignatureRequestResponse templateIds(List<String> templateIds) {
    this.templateIds = templateIds;
    return this;
  }

  public SignatureRequestResponse addTemplateIdsItem(String templateIdsItem) {
    if (this.templateIds == null) {
      this.templateIds = new ArrayList<>();
    }
    this.templateIds.add(templateIdsItem);
    return this;
  }

  /**
   * Templates IDs used in this SignatureRequest (if any).
   * @return templateIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEMPLATE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTemplateIds() {
    return templateIds;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTemplateIds(List<String> templateIds) {
    this.templateIds = templateIds;
  }


  public SignatureRequestResponse customFields(List<SignatureRequestResponseCustomFieldBase> customFields) {
    this.customFields = customFields;
    return this;
  }

  public SignatureRequestResponse addCustomFieldsItem(SignatureRequestResponseCustomFieldBase customFieldsItem) {
    if (this.customFields == null) {
      this.customFields = new ArrayList<>();
    }
    this.customFields.add(customFieldsItem);
    return this;
  }

  /**
   * An array of Custom Field objects containing the name and type of each custom field.  * Text Field uses &#x60;SignatureRequestResponseCustomFieldText&#x60; * Checkbox Field uses &#x60;SignatureRequestResponseCustomFieldCheckbox&#x60;
   * @return customFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SignatureRequestResponseCustomFieldBase> getCustomFields() {
    return customFields;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustomFields(List<SignatureRequestResponseCustomFieldBase> customFields) {
    this.customFields = customFields;
  }


  public SignatureRequestResponse attachments(List<SignatureRequestResponseAttachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  public SignatureRequestResponse addAttachmentsItem(SignatureRequestResponseAttachment attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * Signer attachments.
   * @return attachments
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SignatureRequestResponseAttachment> getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(List<SignatureRequestResponseAttachment> attachments) {
    this.attachments = attachments;
  }


  public SignatureRequestResponse responseData(List<SignatureRequestResponseDataBase> responseData) {
    this.responseData = responseData;
    return this;
  }

  public SignatureRequestResponse addResponseDataItem(SignatureRequestResponseDataBase responseDataItem) {
    if (this.responseData == null) {
      this.responseData = new ArrayList<>();
    }
    this.responseData.add(responseDataItem);
    return this;
  }

  /**
   * An array of form field objects containing the name, value, and type of each textbox or checkmark field filled in by the signers.
   * @return responseData
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESPONSE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SignatureRequestResponseDataBase> getResponseData() {
    return responseData;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_DATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseData(List<SignatureRequestResponseDataBase> responseData) {
    this.responseData = responseData;
  }


  public SignatureRequestResponse signatures(List<SignatureRequestResponseSignatures> signatures) {
    this.signatures = signatures;
    return this;
  }

  public SignatureRequestResponse addSignaturesItem(SignatureRequestResponseSignatures signaturesItem) {
    if (this.signatures == null) {
      this.signatures = new ArrayList<>();
    }
    this.signatures.add(signaturesItem);
    return this;
  }

  /**
   * An array of signature objects, 1 for each signer.
   * @return signatures
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SIGNATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SignatureRequestResponseSignatures> getSignatures() {
    return signatures;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignatures(List<SignatureRequestResponseSignatures> signatures) {
    this.signatures = signatures;
  }


  public SignatureRequestResponse bulkSendJobId(String bulkSendJobId) {
    this.bulkSendJobId = bulkSendJobId;
    return this;
  }

  /**
   * The ID of the Bulk Send job which sent the signature request, if applicable.
   * @return bulkSendJobId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BULK_SEND_JOB_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBulkSendJobId() {
    return bulkSendJobId;
  }


  @JsonProperty(JSON_PROPERTY_BULK_SEND_JOB_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBulkSendJobId(String bulkSendJobId) {
    this.bulkSendJobId = bulkSendJobId;
  }


  /**
   * Return true if this SignatureRequestResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SignatureRequestResponse signatureRequestResponse = (SignatureRequestResponse) o;
    return Objects.equals(this.testMode, signatureRequestResponse.testMode) &&
        Objects.equals(this.signatureRequestId, signatureRequestResponse.signatureRequestId) &&
        Objects.equals(this.requesterEmailAddress, signatureRequestResponse.requesterEmailAddress) &&
        Objects.equals(this.title, signatureRequestResponse.title) &&
        Objects.equals(this.originalTitle, signatureRequestResponse.originalTitle) &&
        Objects.equals(this.subject, signatureRequestResponse.subject) &&
        Objects.equals(this.message, signatureRequestResponse.message) &&
        Objects.equals(this.metadata, signatureRequestResponse.metadata) &&
        Objects.equals(this.createdAt, signatureRequestResponse.createdAt) &&
        Objects.equals(this.expiresAt, signatureRequestResponse.expiresAt) &&
        Objects.equals(this.isComplete, signatureRequestResponse.isComplete) &&
        Objects.equals(this.isDeclined, signatureRequestResponse.isDeclined) &&
        Objects.equals(this.hasError, signatureRequestResponse.hasError) &&
        Objects.equals(this.filesUrl, signatureRequestResponse.filesUrl) &&
        Objects.equals(this.signingUrl, signatureRequestResponse.signingUrl) &&
        Objects.equals(this.detailsUrl, signatureRequestResponse.detailsUrl) &&
        Objects.equals(this.ccEmailAddresses, signatureRequestResponse.ccEmailAddresses) &&
        Objects.equals(this.signingRedirectUrl, signatureRequestResponse.signingRedirectUrl) &&
        Objects.equals(this.finalCopyUri, signatureRequestResponse.finalCopyUri) &&
        Objects.equals(this.templateIds, signatureRequestResponse.templateIds) &&
        Objects.equals(this.customFields, signatureRequestResponse.customFields) &&
        Objects.equals(this.attachments, signatureRequestResponse.attachments) &&
        Objects.equals(this.responseData, signatureRequestResponse.responseData) &&
        Objects.equals(this.signatures, signatureRequestResponse.signatures) &&
        Objects.equals(this.bulkSendJobId, signatureRequestResponse.bulkSendJobId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(testMode, signatureRequestId, requesterEmailAddress, title, originalTitle, subject, message, metadata, createdAt, expiresAt, isComplete, isDeclined, hasError, filesUrl, signingUrl, detailsUrl, ccEmailAddresses, signingRedirectUrl, finalCopyUri, templateIds, customFields, attachments, responseData, signatures, bulkSendJobId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SignatureRequestResponse {\n");
    sb.append("    testMode: ").append(toIndentedString(testMode)).append("\n");
    sb.append("    signatureRequestId: ").append(toIndentedString(signatureRequestId)).append("\n");
    sb.append("    requesterEmailAddress: ").append(toIndentedString(requesterEmailAddress)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    originalTitle: ").append(toIndentedString(originalTitle)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    isComplete: ").append(toIndentedString(isComplete)).append("\n");
    sb.append("    isDeclined: ").append(toIndentedString(isDeclined)).append("\n");
    sb.append("    hasError: ").append(toIndentedString(hasError)).append("\n");
    sb.append("    filesUrl: ").append(toIndentedString(filesUrl)).append("\n");
    sb.append("    signingUrl: ").append(toIndentedString(signingUrl)).append("\n");
    sb.append("    detailsUrl: ").append(toIndentedString(detailsUrl)).append("\n");
    sb.append("    ccEmailAddresses: ").append(toIndentedString(ccEmailAddresses)).append("\n");
    sb.append("    signingRedirectUrl: ").append(toIndentedString(signingRedirectUrl)).append("\n");
    sb.append("    finalCopyUri: ").append(toIndentedString(finalCopyUri)).append("\n");
    sb.append("    templateIds: ").append(toIndentedString(templateIds)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    responseData: ").append(toIndentedString(responseData)).append("\n");
    sb.append("    signatures: ").append(toIndentedString(signatures)).append("\n");
    sb.append("    bulkSendJobId: ").append(toIndentedString(bulkSendJobId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (testMode != null) {
        if (isFileTypeOrListOfFiles(testMode)) {
            fileTypeFound = true;
        }

        if (testMode.getClass().equals(java.io.File.class) ||
            testMode.getClass().equals(Integer.class) ||
            testMode.getClass().equals(String.class) ||
            testMode.getClass().isEnum()) {
            map.put("test_mode", testMode);
        } else if (isListOfFile(testMode)) {
            for(int i = 0; i< getListSize(testMode); i++) {
                map.put("test_mode[" + i + "]", getFromList(testMode, i));
            }
        }
        else {
            map.put("test_mode", JSON.getDefault().getMapper().writeValueAsString(testMode));
        }
    }
    if (signatureRequestId != null) {
        if (isFileTypeOrListOfFiles(signatureRequestId)) {
            fileTypeFound = true;
        }

        if (signatureRequestId.getClass().equals(java.io.File.class) ||
            signatureRequestId.getClass().equals(Integer.class) ||
            signatureRequestId.getClass().equals(String.class) ||
            signatureRequestId.getClass().isEnum()) {
            map.put("signature_request_id", signatureRequestId);
        } else if (isListOfFile(signatureRequestId)) {
            for(int i = 0; i< getListSize(signatureRequestId); i++) {
                map.put("signature_request_id[" + i + "]", getFromList(signatureRequestId, i));
            }
        }
        else {
            map.put("signature_request_id", JSON.getDefault().getMapper().writeValueAsString(signatureRequestId));
        }
    }
    if (requesterEmailAddress != null) {
        if (isFileTypeOrListOfFiles(requesterEmailAddress)) {
            fileTypeFound = true;
        }

        if (requesterEmailAddress.getClass().equals(java.io.File.class) ||
            requesterEmailAddress.getClass().equals(Integer.class) ||
            requesterEmailAddress.getClass().equals(String.class) ||
            requesterEmailAddress.getClass().isEnum()) {
            map.put("requester_email_address", requesterEmailAddress);
        } else if (isListOfFile(requesterEmailAddress)) {
            for(int i = 0; i< getListSize(requesterEmailAddress); i++) {
                map.put("requester_email_address[" + i + "]", getFromList(requesterEmailAddress, i));
            }
        }
        else {
            map.put("requester_email_address", JSON.getDefault().getMapper().writeValueAsString(requesterEmailAddress));
        }
    }
    if (title != null) {
        if (isFileTypeOrListOfFiles(title)) {
            fileTypeFound = true;
        }

        if (title.getClass().equals(java.io.File.class) ||
            title.getClass().equals(Integer.class) ||
            title.getClass().equals(String.class) ||
            title.getClass().isEnum()) {
            map.put("title", title);
        } else if (isListOfFile(title)) {
            for(int i = 0; i< getListSize(title); i++) {
                map.put("title[" + i + "]", getFromList(title, i));
            }
        }
        else {
            map.put("title", JSON.getDefault().getMapper().writeValueAsString(title));
        }
    }
    if (originalTitle != null) {
        if (isFileTypeOrListOfFiles(originalTitle)) {
            fileTypeFound = true;
        }

        if (originalTitle.getClass().equals(java.io.File.class) ||
            originalTitle.getClass().equals(Integer.class) ||
            originalTitle.getClass().equals(String.class) ||
            originalTitle.getClass().isEnum()) {
            map.put("original_title", originalTitle);
        } else if (isListOfFile(originalTitle)) {
            for(int i = 0; i< getListSize(originalTitle); i++) {
                map.put("original_title[" + i + "]", getFromList(originalTitle, i));
            }
        }
        else {
            map.put("original_title", JSON.getDefault().getMapper().writeValueAsString(originalTitle));
        }
    }
    if (subject != null) {
        if (isFileTypeOrListOfFiles(subject)) {
            fileTypeFound = true;
        }

        if (subject.getClass().equals(java.io.File.class) ||
            subject.getClass().equals(Integer.class) ||
            subject.getClass().equals(String.class) ||
            subject.getClass().isEnum()) {
            map.put("subject", subject);
        } else if (isListOfFile(subject)) {
            for(int i = 0; i< getListSize(subject); i++) {
                map.put("subject[" + i + "]", getFromList(subject, i));
            }
        }
        else {
            map.put("subject", JSON.getDefault().getMapper().writeValueAsString(subject));
        }
    }
    if (message != null) {
        if (isFileTypeOrListOfFiles(message)) {
            fileTypeFound = true;
        }

        if (message.getClass().equals(java.io.File.class) ||
            message.getClass().equals(Integer.class) ||
            message.getClass().equals(String.class) ||
            message.getClass().isEnum()) {
            map.put("message", message);
        } else if (isListOfFile(message)) {
            for(int i = 0; i< getListSize(message); i++) {
                map.put("message[" + i + "]", getFromList(message, i));
            }
        }
        else {
            map.put("message", JSON.getDefault().getMapper().writeValueAsString(message));
        }
    }
    if (metadata != null) {
        if (isFileTypeOrListOfFiles(metadata)) {
            fileTypeFound = true;
        }

        if (metadata.getClass().equals(java.io.File.class) ||
            metadata.getClass().equals(Integer.class) ||
            metadata.getClass().equals(String.class) ||
            metadata.getClass().isEnum()) {
            map.put("metadata", metadata);
        } else if (isListOfFile(metadata)) {
            for(int i = 0; i< getListSize(metadata); i++) {
                map.put("metadata[" + i + "]", getFromList(metadata, i));
            }
        }
        else {
            map.put("metadata", JSON.getDefault().getMapper().writeValueAsString(metadata));
        }
    }
    if (createdAt != null) {
        if (isFileTypeOrListOfFiles(createdAt)) {
            fileTypeFound = true;
        }

        if (createdAt.getClass().equals(java.io.File.class) ||
            createdAt.getClass().equals(Integer.class) ||
            createdAt.getClass().equals(String.class) ||
            createdAt.getClass().isEnum()) {
            map.put("created_at", createdAt);
        } else if (isListOfFile(createdAt)) {
            for(int i = 0; i< getListSize(createdAt); i++) {
                map.put("created_at[" + i + "]", getFromList(createdAt, i));
            }
        }
        else {
            map.put("created_at", JSON.getDefault().getMapper().writeValueAsString(createdAt));
        }
    }
    if (expiresAt != null) {
        if (isFileTypeOrListOfFiles(expiresAt)) {
            fileTypeFound = true;
        }

        if (expiresAt.getClass().equals(java.io.File.class) ||
            expiresAt.getClass().equals(Integer.class) ||
            expiresAt.getClass().equals(String.class) ||
            expiresAt.getClass().isEnum()) {
            map.put("expires_at", expiresAt);
        } else if (isListOfFile(expiresAt)) {
            for(int i = 0; i< getListSize(expiresAt); i++) {
                map.put("expires_at[" + i + "]", getFromList(expiresAt, i));
            }
        }
        else {
            map.put("expires_at", JSON.getDefault().getMapper().writeValueAsString(expiresAt));
        }
    }
    if (isComplete != null) {
        if (isFileTypeOrListOfFiles(isComplete)) {
            fileTypeFound = true;
        }

        if (isComplete.getClass().equals(java.io.File.class) ||
            isComplete.getClass().equals(Integer.class) ||
            isComplete.getClass().equals(String.class) ||
            isComplete.getClass().isEnum()) {
            map.put("is_complete", isComplete);
        } else if (isListOfFile(isComplete)) {
            for(int i = 0; i< getListSize(isComplete); i++) {
                map.put("is_complete[" + i + "]", getFromList(isComplete, i));
            }
        }
        else {
            map.put("is_complete", JSON.getDefault().getMapper().writeValueAsString(isComplete));
        }
    }
    if (isDeclined != null) {
        if (isFileTypeOrListOfFiles(isDeclined)) {
            fileTypeFound = true;
        }

        if (isDeclined.getClass().equals(java.io.File.class) ||
            isDeclined.getClass().equals(Integer.class) ||
            isDeclined.getClass().equals(String.class) ||
            isDeclined.getClass().isEnum()) {
            map.put("is_declined", isDeclined);
        } else if (isListOfFile(isDeclined)) {
            for(int i = 0; i< getListSize(isDeclined); i++) {
                map.put("is_declined[" + i + "]", getFromList(isDeclined, i));
            }
        }
        else {
            map.put("is_declined", JSON.getDefault().getMapper().writeValueAsString(isDeclined));
        }
    }
    if (hasError != null) {
        if (isFileTypeOrListOfFiles(hasError)) {
            fileTypeFound = true;
        }

        if (hasError.getClass().equals(java.io.File.class) ||
            hasError.getClass().equals(Integer.class) ||
            hasError.getClass().equals(String.class) ||
            hasError.getClass().isEnum()) {
            map.put("has_error", hasError);
        } else if (isListOfFile(hasError)) {
            for(int i = 0; i< getListSize(hasError); i++) {
                map.put("has_error[" + i + "]", getFromList(hasError, i));
            }
        }
        else {
            map.put("has_error", JSON.getDefault().getMapper().writeValueAsString(hasError));
        }
    }
    if (filesUrl != null) {
        if (isFileTypeOrListOfFiles(filesUrl)) {
            fileTypeFound = true;
        }

        if (filesUrl.getClass().equals(java.io.File.class) ||
            filesUrl.getClass().equals(Integer.class) ||
            filesUrl.getClass().equals(String.class) ||
            filesUrl.getClass().isEnum()) {
            map.put("files_url", filesUrl);
        } else if (isListOfFile(filesUrl)) {
            for(int i = 0; i< getListSize(filesUrl); i++) {
                map.put("files_url[" + i + "]", getFromList(filesUrl, i));
            }
        }
        else {
            map.put("files_url", JSON.getDefault().getMapper().writeValueAsString(filesUrl));
        }
    }
    if (signingUrl != null) {
        if (isFileTypeOrListOfFiles(signingUrl)) {
            fileTypeFound = true;
        }

        if (signingUrl.getClass().equals(java.io.File.class) ||
            signingUrl.getClass().equals(Integer.class) ||
            signingUrl.getClass().equals(String.class) ||
            signingUrl.getClass().isEnum()) {
            map.put("signing_url", signingUrl);
        } else if (isListOfFile(signingUrl)) {
            for(int i = 0; i< getListSize(signingUrl); i++) {
                map.put("signing_url[" + i + "]", getFromList(signingUrl, i));
            }
        }
        else {
            map.put("signing_url", JSON.getDefault().getMapper().writeValueAsString(signingUrl));
        }
    }
    if (detailsUrl != null) {
        if (isFileTypeOrListOfFiles(detailsUrl)) {
            fileTypeFound = true;
        }

        if (detailsUrl.getClass().equals(java.io.File.class) ||
            detailsUrl.getClass().equals(Integer.class) ||
            detailsUrl.getClass().equals(String.class) ||
            detailsUrl.getClass().isEnum()) {
            map.put("details_url", detailsUrl);
        } else if (isListOfFile(detailsUrl)) {
            for(int i = 0; i< getListSize(detailsUrl); i++) {
                map.put("details_url[" + i + "]", getFromList(detailsUrl, i));
            }
        }
        else {
            map.put("details_url", JSON.getDefault().getMapper().writeValueAsString(detailsUrl));
        }
    }
    if (ccEmailAddresses != null) {
        if (isFileTypeOrListOfFiles(ccEmailAddresses)) {
            fileTypeFound = true;
        }

        if (ccEmailAddresses.getClass().equals(java.io.File.class) ||
            ccEmailAddresses.getClass().equals(Integer.class) ||
            ccEmailAddresses.getClass().equals(String.class) ||
            ccEmailAddresses.getClass().isEnum()) {
            map.put("cc_email_addresses", ccEmailAddresses);
        } else if (isListOfFile(ccEmailAddresses)) {
            for(int i = 0; i< getListSize(ccEmailAddresses); i++) {
                map.put("cc_email_addresses[" + i + "]", getFromList(ccEmailAddresses, i));
            }
        }
        else {
            map.put("cc_email_addresses", JSON.getDefault().getMapper().writeValueAsString(ccEmailAddresses));
        }
    }
    if (signingRedirectUrl != null) {
        if (isFileTypeOrListOfFiles(signingRedirectUrl)) {
            fileTypeFound = true;
        }

        if (signingRedirectUrl.getClass().equals(java.io.File.class) ||
            signingRedirectUrl.getClass().equals(Integer.class) ||
            signingRedirectUrl.getClass().equals(String.class) ||
            signingRedirectUrl.getClass().isEnum()) {
            map.put("signing_redirect_url", signingRedirectUrl);
        } else if (isListOfFile(signingRedirectUrl)) {
            for(int i = 0; i< getListSize(signingRedirectUrl); i++) {
                map.put("signing_redirect_url[" + i + "]", getFromList(signingRedirectUrl, i));
            }
        }
        else {
            map.put("signing_redirect_url", JSON.getDefault().getMapper().writeValueAsString(signingRedirectUrl));
        }
    }
    if (finalCopyUri != null) {
        if (isFileTypeOrListOfFiles(finalCopyUri)) {
            fileTypeFound = true;
        }

        if (finalCopyUri.getClass().equals(java.io.File.class) ||
            finalCopyUri.getClass().equals(Integer.class) ||
            finalCopyUri.getClass().equals(String.class) ||
            finalCopyUri.getClass().isEnum()) {
            map.put("final_copy_uri", finalCopyUri);
        } else if (isListOfFile(finalCopyUri)) {
            for(int i = 0; i< getListSize(finalCopyUri); i++) {
                map.put("final_copy_uri[" + i + "]", getFromList(finalCopyUri, i));
            }
        }
        else {
            map.put("final_copy_uri", JSON.getDefault().getMapper().writeValueAsString(finalCopyUri));
        }
    }
    if (templateIds != null) {
        if (isFileTypeOrListOfFiles(templateIds)) {
            fileTypeFound = true;
        }

        if (templateIds.getClass().equals(java.io.File.class) ||
            templateIds.getClass().equals(Integer.class) ||
            templateIds.getClass().equals(String.class) ||
            templateIds.getClass().isEnum()) {
            map.put("template_ids", templateIds);
        } else if (isListOfFile(templateIds)) {
            for(int i = 0; i< getListSize(templateIds); i++) {
                map.put("template_ids[" + i + "]", getFromList(templateIds, i));
            }
        }
        else {
            map.put("template_ids", JSON.getDefault().getMapper().writeValueAsString(templateIds));
        }
    }
    if (customFields != null) {
        if (isFileTypeOrListOfFiles(customFields)) {
            fileTypeFound = true;
        }

        if (customFields.getClass().equals(java.io.File.class) ||
            customFields.getClass().equals(Integer.class) ||
            customFields.getClass().equals(String.class) ||
            customFields.getClass().isEnum()) {
            map.put("custom_fields", customFields);
        } else if (isListOfFile(customFields)) {
            for(int i = 0; i< getListSize(customFields); i++) {
                map.put("custom_fields[" + i + "]", getFromList(customFields, i));
            }
        }
        else {
            map.put("custom_fields", JSON.getDefault().getMapper().writeValueAsString(customFields));
        }
    }
    if (attachments != null) {
        if (isFileTypeOrListOfFiles(attachments)) {
            fileTypeFound = true;
        }

        if (attachments.getClass().equals(java.io.File.class) ||
            attachments.getClass().equals(Integer.class) ||
            attachments.getClass().equals(String.class) ||
            attachments.getClass().isEnum()) {
            map.put("attachments", attachments);
        } else if (isListOfFile(attachments)) {
            for(int i = 0; i< getListSize(attachments); i++) {
                map.put("attachments[" + i + "]", getFromList(attachments, i));
            }
        }
        else {
            map.put("attachments", JSON.getDefault().getMapper().writeValueAsString(attachments));
        }
    }
    if (responseData != null) {
        if (isFileTypeOrListOfFiles(responseData)) {
            fileTypeFound = true;
        }

        if (responseData.getClass().equals(java.io.File.class) ||
            responseData.getClass().equals(Integer.class) ||
            responseData.getClass().equals(String.class) ||
            responseData.getClass().isEnum()) {
            map.put("response_data", responseData);
        } else if (isListOfFile(responseData)) {
            for(int i = 0; i< getListSize(responseData); i++) {
                map.put("response_data[" + i + "]", getFromList(responseData, i));
            }
        }
        else {
            map.put("response_data", JSON.getDefault().getMapper().writeValueAsString(responseData));
        }
    }
    if (signatures != null) {
        if (isFileTypeOrListOfFiles(signatures)) {
            fileTypeFound = true;
        }

        if (signatures.getClass().equals(java.io.File.class) ||
            signatures.getClass().equals(Integer.class) ||
            signatures.getClass().equals(String.class) ||
            signatures.getClass().isEnum()) {
            map.put("signatures", signatures);
        } else if (isListOfFile(signatures)) {
            for(int i = 0; i< getListSize(signatures); i++) {
                map.put("signatures[" + i + "]", getFromList(signatures, i));
            }
        }
        else {
            map.put("signatures", JSON.getDefault().getMapper().writeValueAsString(signatures));
        }
    }
    if (bulkSendJobId != null) {
        if (isFileTypeOrListOfFiles(bulkSendJobId)) {
            fileTypeFound = true;
        }

        if (bulkSendJobId.getClass().equals(java.io.File.class) ||
            bulkSendJobId.getClass().equals(Integer.class) ||
            bulkSendJobId.getClass().equals(String.class) ||
            bulkSendJobId.getClass().isEnum()) {
            map.put("bulk_send_job_id", bulkSendJobId);
        } else if (isListOfFile(bulkSendJobId)) {
            for(int i = 0; i< getListSize(bulkSendJobId); i++) {
                map.put("bulk_send_job_id[" + i + "]", getFromList(bulkSendJobId, i));
            }
        }
        else {
            map.put("bulk_send_job_id", JSON.getDefault().getMapper().writeValueAsString(bulkSendJobId));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

