/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * OAuthTokenRefreshRequest
 */
@JsonPropertyOrder({
  OAuthTokenRefreshRequest.JSON_PROPERTY_GRANT_TYPE,
  OAuthTokenRefreshRequest.JSON_PROPERTY_REFRESH_TOKEN,
  OAuthTokenRefreshRequest.JSON_PROPERTY_CLIENT_ID,
  OAuthTokenRefreshRequest.JSON_PROPERTY_CLIENT_SECRET
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OAuthTokenRefreshRequest {
  public static final String JSON_PROPERTY_GRANT_TYPE = "grant_type";
  private String grantType = "refresh_token";

  public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
  private String refreshToken;

  public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
  private String clientId;

  public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
  private String clientSecret;

  public OAuthTokenRefreshRequest() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public OAuthTokenRefreshRequest init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, OAuthTokenRefreshRequest.class);
  }

  static public OAuthTokenRefreshRequest init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      OAuthTokenRefreshRequest.class
    );
  }

  public OAuthTokenRefreshRequest grantType(String grantType) {
    this.grantType = grantType;
    return this;
  }

  /**
   * When refreshing an existing token use &#x60;refresh_token&#x60;.
   * @return grantType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_GRANT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGrantType() {
    return grantType;
  }


  @JsonProperty(JSON_PROPERTY_GRANT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGrantType(String grantType) {
    this.grantType = grantType;
  }


  public OAuthTokenRefreshRequest refreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
    return this;
  }

  /**
   * The token provided when you got the expired access token.
   * @return refreshToken
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRefreshToken() {
    return refreshToken;
  }


  @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefreshToken(String refreshToken) {
    this.refreshToken = refreshToken;
  }


  public OAuthTokenRefreshRequest clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * The client ID for your API app. Mandatory from August 1st, 2025. Until then, required if the \&quot;Client Credentials Required\&quot; setting is enabled for token refresh; optional if disabled.
   * @return clientId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientId() {
    return clientId;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientId(String clientId) {
    this.clientId = clientId;
  }


  public OAuthTokenRefreshRequest clientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
    return this;
  }

  /**
   * The client secret for your API app. Mandatory from August 1st, 2025. Until then, required if the \&quot;Client Credentials Required\&quot; setting is enabled for token refresh; optional if disabled.
   * @return clientSecret
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClientSecret() {
    return clientSecret;
  }


  @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
  }


  /**
   * Return true if this OAuthTokenRefreshRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OAuthTokenRefreshRequest oauthTokenRefreshRequest = (OAuthTokenRefreshRequest) o;
    return Objects.equals(this.grantType, oauthTokenRefreshRequest.grantType) &&
        Objects.equals(this.refreshToken, oauthTokenRefreshRequest.refreshToken) &&
        Objects.equals(this.clientId, oauthTokenRefreshRequest.clientId) &&
        Objects.equals(this.clientSecret, oauthTokenRefreshRequest.clientSecret);
  }

  @Override
  public int hashCode() {
    return Objects.hash(grantType, refreshToken, clientId, clientSecret);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuthTokenRefreshRequest {\n");
    sb.append("    grantType: ").append(toIndentedString(grantType)).append("\n");
    sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (grantType != null) {
        if (isFileTypeOrListOfFiles(grantType)) {
            fileTypeFound = true;
        }

        if (grantType.getClass().equals(java.io.File.class) ||
            grantType.getClass().equals(Integer.class) ||
            grantType.getClass().equals(String.class) ||
            grantType.getClass().isEnum()) {
            map.put("grant_type", grantType);
        } else if (isListOfFile(grantType)) {
            for(int i = 0; i< getListSize(grantType); i++) {
                map.put("grant_type[" + i + "]", getFromList(grantType, i));
            }
        }
        else {
            map.put("grant_type", JSON.getDefault().getMapper().writeValueAsString(grantType));
        }
    }
    if (refreshToken != null) {
        if (isFileTypeOrListOfFiles(refreshToken)) {
            fileTypeFound = true;
        }

        if (refreshToken.getClass().equals(java.io.File.class) ||
            refreshToken.getClass().equals(Integer.class) ||
            refreshToken.getClass().equals(String.class) ||
            refreshToken.getClass().isEnum()) {
            map.put("refresh_token", refreshToken);
        } else if (isListOfFile(refreshToken)) {
            for(int i = 0; i< getListSize(refreshToken); i++) {
                map.put("refresh_token[" + i + "]", getFromList(refreshToken, i));
            }
        }
        else {
            map.put("refresh_token", JSON.getDefault().getMapper().writeValueAsString(refreshToken));
        }
    }
    if (clientId != null) {
        if (isFileTypeOrListOfFiles(clientId)) {
            fileTypeFound = true;
        }

        if (clientId.getClass().equals(java.io.File.class) ||
            clientId.getClass().equals(Integer.class) ||
            clientId.getClass().equals(String.class) ||
            clientId.getClass().isEnum()) {
            map.put("client_id", clientId);
        } else if (isListOfFile(clientId)) {
            for(int i = 0; i< getListSize(clientId); i++) {
                map.put("client_id[" + i + "]", getFromList(clientId, i));
            }
        }
        else {
            map.put("client_id", JSON.getDefault().getMapper().writeValueAsString(clientId));
        }
    }
    if (clientSecret != null) {
        if (isFileTypeOrListOfFiles(clientSecret)) {
            fileTypeFound = true;
        }

        if (clientSecret.getClass().equals(java.io.File.class) ||
            clientSecret.getClass().equals(Integer.class) ||
            clientSecret.getClass().equals(String.class) ||
            clientSecret.getClass().isEnum()) {
            map.put("client_secret", clientSecret);
        } else if (isListOfFile(clientSecret)) {
            for(int i = 0; i< getListSize(clientSecret); i++) {
                map.put("client_secret[" + i + "]", getFromList(clientSecret, i));
            }
        }
        else {
            map.put("client_secret", JSON.getDefault().getMapper().writeValueAsString(clientSecret));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

