/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * FaxSendRequest
 */
@JsonPropertyOrder({
  FaxSendRequest.JSON_PROPERTY_RECIPIENT,
  FaxSendRequest.JSON_PROPERTY_SENDER,
  FaxSendRequest.JSON_PROPERTY_FILES,
  FaxSendRequest.JSON_PROPERTY_FILE_URLS,
  FaxSendRequest.JSON_PROPERTY_TEST_MODE,
  FaxSendRequest.JSON_PROPERTY_COVER_PAGE_TO,
  FaxSendRequest.JSON_PROPERTY_COVER_PAGE_FROM,
  FaxSendRequest.JSON_PROPERTY_COVER_PAGE_MESSAGE,
  FaxSendRequest.JSON_PROPERTY_TITLE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxSendRequest {
  public static final String JSON_PROPERTY_RECIPIENT = "recipient";
  private String recipient;

  public static final String JSON_PROPERTY_SENDER = "sender";
  private String sender;

  public static final String JSON_PROPERTY_FILES = "files";
  private List<File> files = null;

  public static final String JSON_PROPERTY_FILE_URLS = "file_urls";
  private List<String> fileUrls = null;

  public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
  private Boolean testMode = false;

  public static final String JSON_PROPERTY_COVER_PAGE_TO = "cover_page_to";
  private String coverPageTo;

  public static final String JSON_PROPERTY_COVER_PAGE_FROM = "cover_page_from";
  private String coverPageFrom;

  public static final String JSON_PROPERTY_COVER_PAGE_MESSAGE = "cover_page_message";
  private String coverPageMessage;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public FaxSendRequest() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public FaxSendRequest init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, FaxSendRequest.class);
  }

  static public FaxSendRequest init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      FaxSendRequest.class
    );
  }

  public FaxSendRequest recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

  /**
   * Fax Send To Recipient
   * @return recipient
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipient() {
    return recipient;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }


  public FaxSendRequest sender(String sender) {
    this.sender = sender;
    return this;
  }

  /**
   * Fax Send From Sender (used only with fax number)
   * @return sender
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSender() {
    return sender;
  }


  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSender(String sender) {
    this.sender = sender;
  }


  public FaxSendRequest files(List<File> files) {
    this.files = files;
    return this;
  }

  public FaxSendRequest addFilesItem(File filesItem) {
    if (this.files == null) {
      this.files = new ArrayList<>();
    }
    this.files.add(filesItem);
    return this;
  }

  /**
   * Fax File to Send
   * @return files
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<File> getFiles() {
    return files;
  }


  @JsonProperty(JSON_PROPERTY_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFiles(List<File> files) {
    this.files = files;
  }


  public FaxSendRequest fileUrls(List<String> fileUrls) {
    this.fileUrls = fileUrls;
    return this;
  }

  public FaxSendRequest addFileUrlsItem(String fileUrlsItem) {
    if (this.fileUrls == null) {
      this.fileUrls = new ArrayList<>();
    }
    this.fileUrls.add(fileUrlsItem);
    return this;
  }

  /**
   * Fax File URL to Send
   * @return fileUrls
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFileUrls() {
    return fileUrls;
  }


  @JsonProperty(JSON_PROPERTY_FILE_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFileUrls(List<String> fileUrls) {
    this.fileUrls = fileUrls;
  }


  public FaxSendRequest testMode(Boolean testMode) {
    this.testMode = testMode;
    return this;
  }

  /**
   * API Test Mode Setting
   * @return testMode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTestMode() {
    return testMode;
  }


  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestMode(Boolean testMode) {
    this.testMode = testMode;
  }


  public FaxSendRequest coverPageTo(String coverPageTo) {
    this.coverPageTo = coverPageTo;
    return this;
  }

  /**
   * Fax Cover Page for Recipient
   * @return coverPageTo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COVER_PAGE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCoverPageTo() {
    return coverPageTo;
  }


  @JsonProperty(JSON_PROPERTY_COVER_PAGE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoverPageTo(String coverPageTo) {
    this.coverPageTo = coverPageTo;
  }


  public FaxSendRequest coverPageFrom(String coverPageFrom) {
    this.coverPageFrom = coverPageFrom;
    return this;
  }

  /**
   * Fax Cover Page for Sender
   * @return coverPageFrom
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COVER_PAGE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCoverPageFrom() {
    return coverPageFrom;
  }


  @JsonProperty(JSON_PROPERTY_COVER_PAGE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoverPageFrom(String coverPageFrom) {
    this.coverPageFrom = coverPageFrom;
  }


  public FaxSendRequest coverPageMessage(String coverPageMessage) {
    this.coverPageMessage = coverPageMessage;
    return this;
  }

  /**
   * Fax Cover Page Message
   * @return coverPageMessage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COVER_PAGE_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCoverPageMessage() {
    return coverPageMessage;
  }


  @JsonProperty(JSON_PROPERTY_COVER_PAGE_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoverPageMessage(String coverPageMessage) {
    this.coverPageMessage = coverPageMessage;
  }


  public FaxSendRequest title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Fax Title
   * @return title
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  /**
   * Return true if this FaxSendRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FaxSendRequest faxSendRequest = (FaxSendRequest) o;
    return Objects.equals(this.recipient, faxSendRequest.recipient) &&
        Objects.equals(this.sender, faxSendRequest.sender) &&
        Objects.equals(this.files, faxSendRequest.files) &&
        Objects.equals(this.fileUrls, faxSendRequest.fileUrls) &&
        Objects.equals(this.testMode, faxSendRequest.testMode) &&
        Objects.equals(this.coverPageTo, faxSendRequest.coverPageTo) &&
        Objects.equals(this.coverPageFrom, faxSendRequest.coverPageFrom) &&
        Objects.equals(this.coverPageMessage, faxSendRequest.coverPageMessage) &&
        Objects.equals(this.title, faxSendRequest.title);
  }

  @Override
  public int hashCode() {
    return Objects.hash(recipient, sender, files, fileUrls, testMode, coverPageTo, coverPageFrom, coverPageMessage, title);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FaxSendRequest {\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    files: ").append(toIndentedString(files)).append("\n");
    sb.append("    fileUrls: ").append(toIndentedString(fileUrls)).append("\n");
    sb.append("    testMode: ").append(toIndentedString(testMode)).append("\n");
    sb.append("    coverPageTo: ").append(toIndentedString(coverPageTo)).append("\n");
    sb.append("    coverPageFrom: ").append(toIndentedString(coverPageFrom)).append("\n");
    sb.append("    coverPageMessage: ").append(toIndentedString(coverPageMessage)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (recipient != null) {
        if (isFileTypeOrListOfFiles(recipient)) {
            fileTypeFound = true;
        }

        if (recipient.getClass().equals(java.io.File.class) ||
            recipient.getClass().equals(Integer.class) ||
            recipient.getClass().equals(String.class) ||
            recipient.getClass().isEnum()) {
            map.put("recipient", recipient);
        } else if (isListOfFile(recipient)) {
            for(int i = 0; i< getListSize(recipient); i++) {
                map.put("recipient[" + i + "]", getFromList(recipient, i));
            }
        }
        else {
            map.put("recipient", JSON.getDefault().getMapper().writeValueAsString(recipient));
        }
    }
    if (sender != null) {
        if (isFileTypeOrListOfFiles(sender)) {
            fileTypeFound = true;
        }

        if (sender.getClass().equals(java.io.File.class) ||
            sender.getClass().equals(Integer.class) ||
            sender.getClass().equals(String.class) ||
            sender.getClass().isEnum()) {
            map.put("sender", sender);
        } else if (isListOfFile(sender)) {
            for(int i = 0; i< getListSize(sender); i++) {
                map.put("sender[" + i + "]", getFromList(sender, i));
            }
        }
        else {
            map.put("sender", JSON.getDefault().getMapper().writeValueAsString(sender));
        }
    }
    if (files != null) {
        if (isFileTypeOrListOfFiles(files)) {
            fileTypeFound = true;
        }

        if (files.getClass().equals(java.io.File.class) ||
            files.getClass().equals(Integer.class) ||
            files.getClass().equals(String.class) ||
            files.getClass().isEnum()) {
            map.put("files", files);
        } else if (isListOfFile(files)) {
            for(int i = 0; i< getListSize(files); i++) {
                map.put("files[" + i + "]", getFromList(files, i));
            }
        }
        else {
            map.put("files", JSON.getDefault().getMapper().writeValueAsString(files));
        }
    }
    if (fileUrls != null) {
        if (isFileTypeOrListOfFiles(fileUrls)) {
            fileTypeFound = true;
        }

        if (fileUrls.getClass().equals(java.io.File.class) ||
            fileUrls.getClass().equals(Integer.class) ||
            fileUrls.getClass().equals(String.class) ||
            fileUrls.getClass().isEnum()) {
            map.put("file_urls", fileUrls);
        } else if (isListOfFile(fileUrls)) {
            for(int i = 0; i< getListSize(fileUrls); i++) {
                map.put("file_urls[" + i + "]", getFromList(fileUrls, i));
            }
        }
        else {
            map.put("file_urls", JSON.getDefault().getMapper().writeValueAsString(fileUrls));
        }
    }
    if (testMode != null) {
        if (isFileTypeOrListOfFiles(testMode)) {
            fileTypeFound = true;
        }

        if (testMode.getClass().equals(java.io.File.class) ||
            testMode.getClass().equals(Integer.class) ||
            testMode.getClass().equals(String.class) ||
            testMode.getClass().isEnum()) {
            map.put("test_mode", testMode);
        } else if (isListOfFile(testMode)) {
            for(int i = 0; i< getListSize(testMode); i++) {
                map.put("test_mode[" + i + "]", getFromList(testMode, i));
            }
        }
        else {
            map.put("test_mode", JSON.getDefault().getMapper().writeValueAsString(testMode));
        }
    }
    if (coverPageTo != null) {
        if (isFileTypeOrListOfFiles(coverPageTo)) {
            fileTypeFound = true;
        }

        if (coverPageTo.getClass().equals(java.io.File.class) ||
            coverPageTo.getClass().equals(Integer.class) ||
            coverPageTo.getClass().equals(String.class) ||
            coverPageTo.getClass().isEnum()) {
            map.put("cover_page_to", coverPageTo);
        } else if (isListOfFile(coverPageTo)) {
            for(int i = 0; i< getListSize(coverPageTo); i++) {
                map.put("cover_page_to[" + i + "]", getFromList(coverPageTo, i));
            }
        }
        else {
            map.put("cover_page_to", JSON.getDefault().getMapper().writeValueAsString(coverPageTo));
        }
    }
    if (coverPageFrom != null) {
        if (isFileTypeOrListOfFiles(coverPageFrom)) {
            fileTypeFound = true;
        }

        if (coverPageFrom.getClass().equals(java.io.File.class) ||
            coverPageFrom.getClass().equals(Integer.class) ||
            coverPageFrom.getClass().equals(String.class) ||
            coverPageFrom.getClass().isEnum()) {
            map.put("cover_page_from", coverPageFrom);
        } else if (isListOfFile(coverPageFrom)) {
            for(int i = 0; i< getListSize(coverPageFrom); i++) {
                map.put("cover_page_from[" + i + "]", getFromList(coverPageFrom, i));
            }
        }
        else {
            map.put("cover_page_from", JSON.getDefault().getMapper().writeValueAsString(coverPageFrom));
        }
    }
    if (coverPageMessage != null) {
        if (isFileTypeOrListOfFiles(coverPageMessage)) {
            fileTypeFound = true;
        }

        if (coverPageMessage.getClass().equals(java.io.File.class) ||
            coverPageMessage.getClass().equals(Integer.class) ||
            coverPageMessage.getClass().equals(String.class) ||
            coverPageMessage.getClass().isEnum()) {
            map.put("cover_page_message", coverPageMessage);
        } else if (isListOfFile(coverPageMessage)) {
            for(int i = 0; i< getListSize(coverPageMessage); i++) {
                map.put("cover_page_message[" + i + "]", getFromList(coverPageMessage, i));
            }
        }
        else {
            map.put("cover_page_message", JSON.getDefault().getMapper().writeValueAsString(coverPageMessage));
        }
    }
    if (title != null) {
        if (isFileTypeOrListOfFiles(title)) {
            fileTypeFound = true;
        }

        if (title.getClass().equals(java.io.File.class) ||
            title.getClass().equals(Integer.class) ||
            title.getClass().equals(String.class) ||
            title.getClass().isEnum()) {
            map.put("title", title);
        } else if (isListOfFile(title)) {
            for(int i = 0; i< getListSize(title); i++) {
                map.put("title[" + i + "]", getFromList(title, i));
            }
        }
        else {
            map.put("title", JSON.getDefault().getMapper().writeValueAsString(title));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

