/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * Contains information about an error that occurred.
 */
@JsonPropertyOrder({
  ErrorResponseError.JSON_PROPERTY_ERROR_MSG,
  ErrorResponseError.JSON_PROPERTY_ERROR_NAME,
  ErrorResponseError.JSON_PROPERTY_ERROR_PATH
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorResponseError {
  public static final String JSON_PROPERTY_ERROR_MSG = "error_msg";
  private String errorMsg;

  public static final String JSON_PROPERTY_ERROR_NAME = "error_name";
  private String errorName;

  public static final String JSON_PROPERTY_ERROR_PATH = "error_path";
  private String errorPath;

  public ErrorResponseError() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public ErrorResponseError init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, ErrorResponseError.class);
  }

  static public ErrorResponseError init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      ErrorResponseError.class
    );
  }

  public ErrorResponseError errorMsg(String errorMsg) {
    this.errorMsg = errorMsg;
    return this;
  }

  /**
   * Message describing an error.
   * @return errorMsg
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ERROR_MSG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getErrorMsg() {
    return errorMsg;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MSG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setErrorMsg(String errorMsg) {
    this.errorMsg = errorMsg;
  }


  public ErrorResponseError errorName(String errorName) {
    this.errorName = errorName;
    return this;
  }

  /**
   * Name of the error.
   * @return errorName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ERROR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getErrorName() {
    return errorName;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setErrorName(String errorName) {
    this.errorName = errorName;
  }


  public ErrorResponseError errorPath(String errorPath) {
    this.errorPath = errorPath;
    return this;
  }

  /**
   * Path at which an error occurred.
   * @return errorPath
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getErrorPath() {
    return errorPath;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorPath(String errorPath) {
    this.errorPath = errorPath;
  }


  /**
   * Return true if this ErrorResponseError object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ErrorResponseError errorResponseError = (ErrorResponseError) o;
    return Objects.equals(this.errorMsg, errorResponseError.errorMsg) &&
        Objects.equals(this.errorName, errorResponseError.errorName) &&
        Objects.equals(this.errorPath, errorResponseError.errorPath);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorMsg, errorName, errorPath);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ErrorResponseError {\n");
    sb.append("    errorMsg: ").append(toIndentedString(errorMsg)).append("\n");
    sb.append("    errorName: ").append(toIndentedString(errorName)).append("\n");
    sb.append("    errorPath: ").append(toIndentedString(errorPath)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (errorMsg != null) {
        if (isFileTypeOrListOfFiles(errorMsg)) {
            fileTypeFound = true;
        }

        if (errorMsg.getClass().equals(java.io.File.class) ||
            errorMsg.getClass().equals(Integer.class) ||
            errorMsg.getClass().equals(String.class) ||
            errorMsg.getClass().isEnum()) {
            map.put("error_msg", errorMsg);
        } else if (isListOfFile(errorMsg)) {
            for(int i = 0; i< getListSize(errorMsg); i++) {
                map.put("error_msg[" + i + "]", getFromList(errorMsg, i));
            }
        }
        else {
            map.put("error_msg", JSON.getDefault().getMapper().writeValueAsString(errorMsg));
        }
    }
    if (errorName != null) {
        if (isFileTypeOrListOfFiles(errorName)) {
            fileTypeFound = true;
        }

        if (errorName.getClass().equals(java.io.File.class) ||
            errorName.getClass().equals(Integer.class) ||
            errorName.getClass().equals(String.class) ||
            errorName.getClass().isEnum()) {
            map.put("error_name", errorName);
        } else if (isListOfFile(errorName)) {
            for(int i = 0; i< getListSize(errorName); i++) {
                map.put("error_name[" + i + "]", getFromList(errorName, i));
            }
        }
        else {
            map.put("error_name", JSON.getDefault().getMapper().writeValueAsString(errorName));
        }
    }
    if (errorPath != null) {
        if (isFileTypeOrListOfFiles(errorPath)) {
            fileTypeFound = true;
        }

        if (errorPath.getClass().equals(java.io.File.class) ||
            errorPath.getClass().equals(Integer.class) ||
            errorPath.getClass().equals(String.class) ||
            errorPath.getClass().isEnum()) {
            map.put("error_path", errorPath);
        } else if (isListOfFile(errorPath)) {
            for(int i = 0; i< getListSize(errorPath); i++) {
                map.put("error_path[" + i + "]", getFromList(errorPath, i));
            }
        }
        else {
            map.put("error_path", JSON.getDefault().getMapper().writeValueAsString(errorPath));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

