/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.dropbox.sign.model.SubEditorOptions;
import com.dropbox.sign.model.SubMergeField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * EmbeddedEditUrlRequest
 */
@JsonPropertyOrder({
  EmbeddedEditUrlRequest.JSON_PROPERTY_ALLOW_EDIT_CCS,
  EmbeddedEditUrlRequest.JSON_PROPERTY_CC_ROLES,
  EmbeddedEditUrlRequest.JSON_PROPERTY_EDITOR_OPTIONS,
  EmbeddedEditUrlRequest.JSON_PROPERTY_FORCE_SIGNER_ROLES,
  EmbeddedEditUrlRequest.JSON_PROPERTY_FORCE_SUBJECT_MESSAGE,
  EmbeddedEditUrlRequest.JSON_PROPERTY_MERGE_FIELDS,
  EmbeddedEditUrlRequest.JSON_PROPERTY_PREVIEW_ONLY,
  EmbeddedEditUrlRequest.JSON_PROPERTY_SHOW_PREVIEW,
  EmbeddedEditUrlRequest.JSON_PROPERTY_SHOW_PROGRESS_STEPPER,
  EmbeddedEditUrlRequest.JSON_PROPERTY_TEST_MODE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class EmbeddedEditUrlRequest {
  public static final String JSON_PROPERTY_ALLOW_EDIT_CCS = "allow_edit_ccs";
  private Boolean allowEditCcs = false;

  public static final String JSON_PROPERTY_CC_ROLES = "cc_roles";
  private List<String> ccRoles = null;

  public static final String JSON_PROPERTY_EDITOR_OPTIONS = "editor_options";
  private SubEditorOptions editorOptions;

  public static final String JSON_PROPERTY_FORCE_SIGNER_ROLES = "force_signer_roles";
  private Boolean forceSignerRoles = false;

  public static final String JSON_PROPERTY_FORCE_SUBJECT_MESSAGE = "force_subject_message";
  private Boolean forceSubjectMessage = false;

  public static final String JSON_PROPERTY_MERGE_FIELDS = "merge_fields";
  private List<SubMergeField> mergeFields = null;

  public static final String JSON_PROPERTY_PREVIEW_ONLY = "preview_only";
  private Boolean previewOnly = false;

  public static final String JSON_PROPERTY_SHOW_PREVIEW = "show_preview";
  private Boolean showPreview = false;

  public static final String JSON_PROPERTY_SHOW_PROGRESS_STEPPER = "show_progress_stepper";
  private Boolean showProgressStepper = true;

  public static final String JSON_PROPERTY_TEST_MODE = "test_mode";
  private Boolean testMode = false;

  public EmbeddedEditUrlRequest() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public EmbeddedEditUrlRequest init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, EmbeddedEditUrlRequest.class);
  }

  static public EmbeddedEditUrlRequest init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      EmbeddedEditUrlRequest.class
    );
  }

  public EmbeddedEditUrlRequest allowEditCcs(Boolean allowEditCcs) {
    this.allowEditCcs = allowEditCcs;
    return this;
  }

  /**
   * This allows the requester to enable/disable to add or change CC roles when editing the template.
   * @return allowEditCcs
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ALLOW_EDIT_CCS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowEditCcs() {
    return allowEditCcs;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_EDIT_CCS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowEditCcs(Boolean allowEditCcs) {
    this.allowEditCcs = allowEditCcs;
  }


  public EmbeddedEditUrlRequest ccRoles(List<String> ccRoles) {
    this.ccRoles = ccRoles;
    return this;
  }

  public EmbeddedEditUrlRequest addCcRolesItem(String ccRolesItem) {
    if (this.ccRoles == null) {
      this.ccRoles = new ArrayList<>();
    }
    this.ccRoles.add(ccRolesItem);
    return this;
  }

  /**
   * The CC roles that must be assigned when using the template to send a signature request. To remove all CC roles, pass in a single role with no name. For use in a POST request.
   * @return ccRoles
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCcRoles() {
    return ccRoles;
  }


  @JsonProperty(JSON_PROPERTY_CC_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCcRoles(List<String> ccRoles) {
    this.ccRoles = ccRoles;
  }


  public EmbeddedEditUrlRequest editorOptions(SubEditorOptions editorOptions) {
    this.editorOptions = editorOptions;
    return this;
  }

  /**
   * Get editorOptions
   * @return editorOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EDITOR_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SubEditorOptions getEditorOptions() {
    return editorOptions;
  }


  @JsonProperty(JSON_PROPERTY_EDITOR_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditorOptions(SubEditorOptions editorOptions) {
    this.editorOptions = editorOptions;
  }


  public EmbeddedEditUrlRequest forceSignerRoles(Boolean forceSignerRoles) {
    this.forceSignerRoles = forceSignerRoles;
    return this;
  }

  /**
   * Provide users the ability to review/edit the template signer roles.
   * @return forceSignerRoles
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_SIGNER_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceSignerRoles() {
    return forceSignerRoles;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_SIGNER_ROLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceSignerRoles(Boolean forceSignerRoles) {
    this.forceSignerRoles = forceSignerRoles;
  }


  public EmbeddedEditUrlRequest forceSubjectMessage(Boolean forceSubjectMessage) {
    this.forceSubjectMessage = forceSubjectMessage;
    return this;
  }

  /**
   * Provide users the ability to review/edit the template subject and message.
   * @return forceSubjectMessage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORCE_SUBJECT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getForceSubjectMessage() {
    return forceSubjectMessage;
  }


  @JsonProperty(JSON_PROPERTY_FORCE_SUBJECT_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForceSubjectMessage(Boolean forceSubjectMessage) {
    this.forceSubjectMessage = forceSubjectMessage;
  }


  public EmbeddedEditUrlRequest mergeFields(List<SubMergeField> mergeFields) {
    this.mergeFields = mergeFields;
    return this;
  }

  public EmbeddedEditUrlRequest addMergeFieldsItem(SubMergeField mergeFieldsItem) {
    if (this.mergeFields == null) {
      this.mergeFields = new ArrayList<>();
    }
    this.mergeFields.add(mergeFieldsItem);
    return this;
  }

  /**
   * Add additional merge fields to the template, which can be used used to pre-fill data by passing values into signature requests made with that template.  Remove all merge fields on the template by passing an empty array &#x60;[]&#x60;.
   * @return mergeFields
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MERGE_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SubMergeField> getMergeFields() {
    return mergeFields;
  }


  @JsonProperty(JSON_PROPERTY_MERGE_FIELDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMergeFields(List<SubMergeField> mergeFields) {
    this.mergeFields = mergeFields;
  }


  public EmbeddedEditUrlRequest previewOnly(Boolean previewOnly) {
    this.previewOnly = previewOnly;
    return this;
  }

  /**
   * This allows the requester to enable the preview experience (i.e. does not allow the requester&#39;s end user to add any additional fields via the editor).  **NOTE:** This parameter overwrites &#x60;show_preview&#x3D;true&#x60; (if set).
   * @return previewOnly
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PREVIEW_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPreviewOnly() {
    return previewOnly;
  }


  @JsonProperty(JSON_PROPERTY_PREVIEW_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreviewOnly(Boolean previewOnly) {
    this.previewOnly = previewOnly;
  }


  public EmbeddedEditUrlRequest showPreview(Boolean showPreview) {
    this.showPreview = showPreview;
    return this;
  }

  /**
   * This allows the requester to enable the editor/preview experience.
   * @return showPreview
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_PREVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPreview() {
    return showPreview;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PREVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPreview(Boolean showPreview) {
    this.showPreview = showPreview;
  }


  public EmbeddedEditUrlRequest showProgressStepper(Boolean showProgressStepper) {
    this.showProgressStepper = showProgressStepper;
    return this;
  }

  /**
   * When only one step remains in the signature request process and this parameter is set to &#x60;false&#x60; then the progress stepper will be hidden.
   * @return showProgressStepper
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SHOW_PROGRESS_STEPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowProgressStepper() {
    return showProgressStepper;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PROGRESS_STEPPER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowProgressStepper(Boolean showProgressStepper) {
    this.showProgressStepper = showProgressStepper;
  }


  public EmbeddedEditUrlRequest testMode(Boolean testMode) {
    this.testMode = testMode;
    return this;
  }

  /**
   * Whether this is a test, locked templates will only be available for editing if this is set to &#x60;true&#x60;. Defaults to &#x60;false&#x60;.
   * @return testMode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTestMode() {
    return testMode;
  }


  @JsonProperty(JSON_PROPERTY_TEST_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTestMode(Boolean testMode) {
    this.testMode = testMode;
  }


  /**
   * Return true if this EmbeddedEditUrlRequest object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedEditUrlRequest embeddedEditUrlRequest = (EmbeddedEditUrlRequest) o;
    return Objects.equals(this.allowEditCcs, embeddedEditUrlRequest.allowEditCcs) &&
        Objects.equals(this.ccRoles, embeddedEditUrlRequest.ccRoles) &&
        Objects.equals(this.editorOptions, embeddedEditUrlRequest.editorOptions) &&
        Objects.equals(this.forceSignerRoles, embeddedEditUrlRequest.forceSignerRoles) &&
        Objects.equals(this.forceSubjectMessage, embeddedEditUrlRequest.forceSubjectMessage) &&
        Objects.equals(this.mergeFields, embeddedEditUrlRequest.mergeFields) &&
        Objects.equals(this.previewOnly, embeddedEditUrlRequest.previewOnly) &&
        Objects.equals(this.showPreview, embeddedEditUrlRequest.showPreview) &&
        Objects.equals(this.showProgressStepper, embeddedEditUrlRequest.showProgressStepper) &&
        Objects.equals(this.testMode, embeddedEditUrlRequest.testMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowEditCcs, ccRoles, editorOptions, forceSignerRoles, forceSubjectMessage, mergeFields, previewOnly, showPreview, showProgressStepper, testMode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedEditUrlRequest {\n");
    sb.append("    allowEditCcs: ").append(toIndentedString(allowEditCcs)).append("\n");
    sb.append("    ccRoles: ").append(toIndentedString(ccRoles)).append("\n");
    sb.append("    editorOptions: ").append(toIndentedString(editorOptions)).append("\n");
    sb.append("    forceSignerRoles: ").append(toIndentedString(forceSignerRoles)).append("\n");
    sb.append("    forceSubjectMessage: ").append(toIndentedString(forceSubjectMessage)).append("\n");
    sb.append("    mergeFields: ").append(toIndentedString(mergeFields)).append("\n");
    sb.append("    previewOnly: ").append(toIndentedString(previewOnly)).append("\n");
    sb.append("    showPreview: ").append(toIndentedString(showPreview)).append("\n");
    sb.append("    showProgressStepper: ").append(toIndentedString(showProgressStepper)).append("\n");
    sb.append("    testMode: ").append(toIndentedString(testMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (allowEditCcs != null) {
        if (isFileTypeOrListOfFiles(allowEditCcs)) {
            fileTypeFound = true;
        }

        if (allowEditCcs.getClass().equals(java.io.File.class) ||
            allowEditCcs.getClass().equals(Integer.class) ||
            allowEditCcs.getClass().equals(String.class) ||
            allowEditCcs.getClass().isEnum()) {
            map.put("allow_edit_ccs", allowEditCcs);
        } else if (isListOfFile(allowEditCcs)) {
            for(int i = 0; i< getListSize(allowEditCcs); i++) {
                map.put("allow_edit_ccs[" + i + "]", getFromList(allowEditCcs, i));
            }
        }
        else {
            map.put("allow_edit_ccs", JSON.getDefault().getMapper().writeValueAsString(allowEditCcs));
        }
    }
    if (ccRoles != null) {
        if (isFileTypeOrListOfFiles(ccRoles)) {
            fileTypeFound = true;
        }

        if (ccRoles.getClass().equals(java.io.File.class) ||
            ccRoles.getClass().equals(Integer.class) ||
            ccRoles.getClass().equals(String.class) ||
            ccRoles.getClass().isEnum()) {
            map.put("cc_roles", ccRoles);
        } else if (isListOfFile(ccRoles)) {
            for(int i = 0; i< getListSize(ccRoles); i++) {
                map.put("cc_roles[" + i + "]", getFromList(ccRoles, i));
            }
        }
        else {
            map.put("cc_roles", JSON.getDefault().getMapper().writeValueAsString(ccRoles));
        }
    }
    if (editorOptions != null) {
        if (isFileTypeOrListOfFiles(editorOptions)) {
            fileTypeFound = true;
        }

        if (editorOptions.getClass().equals(java.io.File.class) ||
            editorOptions.getClass().equals(Integer.class) ||
            editorOptions.getClass().equals(String.class) ||
            editorOptions.getClass().isEnum()) {
            map.put("editor_options", editorOptions);
        } else if (isListOfFile(editorOptions)) {
            for(int i = 0; i< getListSize(editorOptions); i++) {
                map.put("editor_options[" + i + "]", getFromList(editorOptions, i));
            }
        }
        else {
            map.put("editor_options", JSON.getDefault().getMapper().writeValueAsString(editorOptions));
        }
    }
    if (forceSignerRoles != null) {
        if (isFileTypeOrListOfFiles(forceSignerRoles)) {
            fileTypeFound = true;
        }

        if (forceSignerRoles.getClass().equals(java.io.File.class) ||
            forceSignerRoles.getClass().equals(Integer.class) ||
            forceSignerRoles.getClass().equals(String.class) ||
            forceSignerRoles.getClass().isEnum()) {
            map.put("force_signer_roles", forceSignerRoles);
        } else if (isListOfFile(forceSignerRoles)) {
            for(int i = 0; i< getListSize(forceSignerRoles); i++) {
                map.put("force_signer_roles[" + i + "]", getFromList(forceSignerRoles, i));
            }
        }
        else {
            map.put("force_signer_roles", JSON.getDefault().getMapper().writeValueAsString(forceSignerRoles));
        }
    }
    if (forceSubjectMessage != null) {
        if (isFileTypeOrListOfFiles(forceSubjectMessage)) {
            fileTypeFound = true;
        }

        if (forceSubjectMessage.getClass().equals(java.io.File.class) ||
            forceSubjectMessage.getClass().equals(Integer.class) ||
            forceSubjectMessage.getClass().equals(String.class) ||
            forceSubjectMessage.getClass().isEnum()) {
            map.put("force_subject_message", forceSubjectMessage);
        } else if (isListOfFile(forceSubjectMessage)) {
            for(int i = 0; i< getListSize(forceSubjectMessage); i++) {
                map.put("force_subject_message[" + i + "]", getFromList(forceSubjectMessage, i));
            }
        }
        else {
            map.put("force_subject_message", JSON.getDefault().getMapper().writeValueAsString(forceSubjectMessage));
        }
    }
    if (mergeFields != null) {
        if (isFileTypeOrListOfFiles(mergeFields)) {
            fileTypeFound = true;
        }

        if (mergeFields.getClass().equals(java.io.File.class) ||
            mergeFields.getClass().equals(Integer.class) ||
            mergeFields.getClass().equals(String.class) ||
            mergeFields.getClass().isEnum()) {
            map.put("merge_fields", mergeFields);
        } else if (isListOfFile(mergeFields)) {
            for(int i = 0; i< getListSize(mergeFields); i++) {
                map.put("merge_fields[" + i + "]", getFromList(mergeFields, i));
            }
        }
        else {
            map.put("merge_fields", JSON.getDefault().getMapper().writeValueAsString(mergeFields));
        }
    }
    if (previewOnly != null) {
        if (isFileTypeOrListOfFiles(previewOnly)) {
            fileTypeFound = true;
        }

        if (previewOnly.getClass().equals(java.io.File.class) ||
            previewOnly.getClass().equals(Integer.class) ||
            previewOnly.getClass().equals(String.class) ||
            previewOnly.getClass().isEnum()) {
            map.put("preview_only", previewOnly);
        } else if (isListOfFile(previewOnly)) {
            for(int i = 0; i< getListSize(previewOnly); i++) {
                map.put("preview_only[" + i + "]", getFromList(previewOnly, i));
            }
        }
        else {
            map.put("preview_only", JSON.getDefault().getMapper().writeValueAsString(previewOnly));
        }
    }
    if (showPreview != null) {
        if (isFileTypeOrListOfFiles(showPreview)) {
            fileTypeFound = true;
        }

        if (showPreview.getClass().equals(java.io.File.class) ||
            showPreview.getClass().equals(Integer.class) ||
            showPreview.getClass().equals(String.class) ||
            showPreview.getClass().isEnum()) {
            map.put("show_preview", showPreview);
        } else if (isListOfFile(showPreview)) {
            for(int i = 0; i< getListSize(showPreview); i++) {
                map.put("show_preview[" + i + "]", getFromList(showPreview, i));
            }
        }
        else {
            map.put("show_preview", JSON.getDefault().getMapper().writeValueAsString(showPreview));
        }
    }
    if (showProgressStepper != null) {
        if (isFileTypeOrListOfFiles(showProgressStepper)) {
            fileTypeFound = true;
        }

        if (showProgressStepper.getClass().equals(java.io.File.class) ||
            showProgressStepper.getClass().equals(Integer.class) ||
            showProgressStepper.getClass().equals(String.class) ||
            showProgressStepper.getClass().isEnum()) {
            map.put("show_progress_stepper", showProgressStepper);
        } else if (isListOfFile(showProgressStepper)) {
            for(int i = 0; i< getListSize(showProgressStepper); i++) {
                map.put("show_progress_stepper[" + i + "]", getFromList(showProgressStepper, i));
            }
        }
        else {
            map.put("show_progress_stepper", JSON.getDefault().getMapper().writeValueAsString(showProgressStepper));
        }
    }
    if (testMode != null) {
        if (isFileTypeOrListOfFiles(testMode)) {
            fileTypeFound = true;
        }

        if (testMode.getClass().equals(java.io.File.class) ||
            testMode.getClass().equals(Integer.class) ||
            testMode.getClass().equals(String.class) ||
            testMode.getClass().isEnum()) {
            map.put("test_mode", testMode);
        } else if (isListOfFile(testMode)) {
            for(int i = 0; i< getListSize(testMode); i++) {
                map.put("test_mode[" + i + "]", getFromList(testMode, i));
            }
        }
        else {
            map.put("test_mode", JSON.getDefault().getMapper().writeValueAsString(testMode));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

