/*
 * Dropbox Sign API
 * Dropbox Sign v3 API
 *
 * The version of the OpenAPI document: 3.0.0
 * Contact: apisupport@hellosign.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.dropbox.sign.model;

import java.util.Objects;
import java.util.Map;
import java.util.HashMap;
import com.dropbox.sign.model.ApiAppResponse;
import com.dropbox.sign.model.ListInfoResponse;
import com.dropbox.sign.model.WarningResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.dropbox.sign.JSON;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;


import com.dropbox.sign.ApiException;
/**
 * ApiAppListResponse
 */
@JsonPropertyOrder({
  ApiAppListResponse.JSON_PROPERTY_API_APPS,
  ApiAppListResponse.JSON_PROPERTY_LIST_INFO,
  ApiAppListResponse.JSON_PROPERTY_WARNINGS
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiAppListResponse {
  public static final String JSON_PROPERTY_API_APPS = "api_apps";
  private List<ApiAppResponse> apiApps = new ArrayList<>();

  public static final String JSON_PROPERTY_LIST_INFO = "list_info";
  private ListInfoResponse listInfo;

  public static final String JSON_PROPERTY_WARNINGS = "warnings";
  private List<WarningResponse> warnings = null;

  public ApiAppListResponse() { 
  }

  /**
   * Attempt to instantiate and hydrate a new instance of this class
   * @param jsonData String of JSON data representing target object
   */
  static public ApiAppListResponse init(String jsonData) throws Exception {
    return new ObjectMapper().readValue(jsonData, ApiAppListResponse.class);
  }

  static public ApiAppListResponse init(HashMap data) throws Exception {
    return new ObjectMapper().readValue(
      new ObjectMapper().writeValueAsString(data),
      ApiAppListResponse.class
    );
  }

  public ApiAppListResponse apiApps(List<ApiAppResponse> apiApps) {
    this.apiApps = apiApps;
    return this;
  }

  public ApiAppListResponse addApiAppsItem(ApiAppResponse apiAppsItem) {
    if (this.apiApps == null) {
      this.apiApps = new ArrayList<>();
    }
    this.apiApps.add(apiAppsItem);
    return this;
  }

  /**
   * Contains information about API Apps.
   * @return apiApps
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_API_APPS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<ApiAppResponse> getApiApps() {
    return apiApps;
  }


  @JsonProperty(JSON_PROPERTY_API_APPS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setApiApps(List<ApiAppResponse> apiApps) {
    this.apiApps = apiApps;
  }


  public ApiAppListResponse listInfo(ListInfoResponse listInfo) {
    this.listInfo = listInfo;
    return this;
  }

  /**
   * Get listInfo
   * @return listInfo
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LIST_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ListInfoResponse getListInfo() {
    return listInfo;
  }


  @JsonProperty(JSON_PROPERTY_LIST_INFO)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListInfo(ListInfoResponse listInfo) {
    this.listInfo = listInfo;
  }


  public ApiAppListResponse warnings(List<WarningResponse> warnings) {
    this.warnings = warnings;
    return this;
  }

  public ApiAppListResponse addWarningsItem(WarningResponse warningsItem) {
    if (this.warnings == null) {
      this.warnings = new ArrayList<>();
    }
    this.warnings.add(warningsItem);
    return this;
  }

  /**
   * A list of warnings.
   * @return warnings
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WARNINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<WarningResponse> getWarnings() {
    return warnings;
  }


  @JsonProperty(JSON_PROPERTY_WARNINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWarnings(List<WarningResponse> warnings) {
    this.warnings = warnings;
  }


  /**
   * Return true if this ApiAppListResponse object is equal to o.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiAppListResponse apiAppListResponse = (ApiAppListResponse) o;
    return Objects.equals(this.apiApps, apiAppListResponse.apiApps) &&
        Objects.equals(this.listInfo, apiAppListResponse.listInfo) &&
        Objects.equals(this.warnings, apiAppListResponse.warnings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(apiApps, listInfo, warnings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiAppListResponse {\n");
    sb.append("    apiApps: ").append(toIndentedString(apiApps)).append("\n");
    sb.append("    listInfo: ").append(toIndentedString(listInfo)).append("\n");
    sb.append("    warnings: ").append(toIndentedString(warnings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public Map<String, Object> createFormData() throws ApiException {
    Map<String, Object> map = new HashMap<>();
    boolean fileTypeFound = false;
    try {
    if (apiApps != null) {
        if (isFileTypeOrListOfFiles(apiApps)) {
            fileTypeFound = true;
        }

        if (apiApps.getClass().equals(java.io.File.class) ||
            apiApps.getClass().equals(Integer.class) ||
            apiApps.getClass().equals(String.class) ||
            apiApps.getClass().isEnum()) {
            map.put("api_apps", apiApps);
        } else if (isListOfFile(apiApps)) {
            for(int i = 0; i< getListSize(apiApps); i++) {
                map.put("api_apps[" + i + "]", getFromList(apiApps, i));
            }
        }
        else {
            map.put("api_apps", JSON.getDefault().getMapper().writeValueAsString(apiApps));
        }
    }
    if (listInfo != null) {
        if (isFileTypeOrListOfFiles(listInfo)) {
            fileTypeFound = true;
        }

        if (listInfo.getClass().equals(java.io.File.class) ||
            listInfo.getClass().equals(Integer.class) ||
            listInfo.getClass().equals(String.class) ||
            listInfo.getClass().isEnum()) {
            map.put("list_info", listInfo);
        } else if (isListOfFile(listInfo)) {
            for(int i = 0; i< getListSize(listInfo); i++) {
                map.put("list_info[" + i + "]", getFromList(listInfo, i));
            }
        }
        else {
            map.put("list_info", JSON.getDefault().getMapper().writeValueAsString(listInfo));
        }
    }
    if (warnings != null) {
        if (isFileTypeOrListOfFiles(warnings)) {
            fileTypeFound = true;
        }

        if (warnings.getClass().equals(java.io.File.class) ||
            warnings.getClass().equals(Integer.class) ||
            warnings.getClass().equals(String.class) ||
            warnings.getClass().isEnum()) {
            map.put("warnings", warnings);
        } else if (isListOfFile(warnings)) {
            for(int i = 0; i< getListSize(warnings); i++) {
                map.put("warnings[" + i + "]", getFromList(warnings, i));
            }
        }
        else {
            map.put("warnings", JSON.getDefault().getMapper().writeValueAsString(warnings));
        }
    }
    } catch (Exception e) {
        throw new ApiException(e);
    }

    return fileTypeFound ? map : new HashMap<>();
  }

  private boolean isFileTypeOrListOfFiles(Object obj) throws Exception {
    return obj.getClass().equals(java.io.File.class) || isListOfFile(obj);
  }

  private boolean isListOfFile(Object obj) throws Exception {
      return obj instanceof java.util.List && !isListEmpty(obj) && getFromList(obj, 0) instanceof java.io.File;
  }

  private boolean isListEmpty(Object obj) throws Exception {
    return (boolean) Class.forName(java.util.List.class.getName()).getMethod("isEmpty").invoke(obj);
  }

  private Object getFromList(Object obj, int index) throws Exception {
    return Class.forName(java.util.List.class.getName()).getMethod("get", int.class).invoke(obj, index);
  }

  private int getListSize(Object obj) throws Exception {
    return (int) Class.forName(java.util.List.class.getName()).getMethod("size").invoke(obj);
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

