/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.FileProvider;
import droidninja.filepicker.PickerManager;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldroidninja/filepicker/utils/ImageCaptureManager;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "<set-?>", "", "currentPhotoPath", "getCurrentPhotoPath", "()Ljava/lang/String;", "setCurrentPhotoPath", "(Ljava/lang/String;)V", "createImageFile", "Ljava/io/File;", "dispatchTakePictureIntent", "Landroid/content/Intent;", "notifyMediaStoreDatabase", "onRestoreInstanceState", "", "savedInstanceState", "Landroid/os/Bundle;", "onSaveInstanceState", "Companion", "filepicker_release"})
public final class ImageCaptureManager {
    @Nullable
    private String currentPhotoPath;
    private final Context mContext;
    private static final String CAPTURED_PHOTO_PATH_KEY = "mCurrentPhotoPath";
    private static final int REQUEST_TAKE_PHOTO = 257;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getCurrentPhotoPath() {
        return this.currentPhotoPath;
    }

    private final void setCurrentPhotoPath(String string2) {
        this.currentPhotoPath = string2;
    }

    private final File createImageFile() throws IOException {
        String imageFileName = "JPEG_" + System.currentTimeMillis() + ".jpg";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!storageDir.exists() && !storageDir.mkdir()) {
            Log.e((String)"TAG", (String)"Throwing Errors....");
            throw (Throwable)new IOException();
        }
        File image = new File(storageDir, imageFileName);
        this.currentPhotoPath = image.getAbsolutePath();
        return image;
    }

    @Nullable
    public final Intent dispatchTakePictureIntent() throws IOException {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.mContext.getPackageManager()) != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                File newFile = this.createImageFile();
                takePictureIntent.addFlags(1);
                takePictureIntent.addFlags(2);
                String string2 = PickerManager.INSTANCE.getProviderAuthorities();
                if (string2 != null) {
                    String string3;
                    String it = string3 = string2;
                    Uri photoURI = FileProvider.getUriForFile((Context)this.mContext, (String)it, (File)newFile);
                    takePictureIntent.putExtra("output", (Parcelable)photoURI);
                }
            } else {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.createImageFile()));
            }
            return takePictureIntent;
        }
        return null;
    }

    @Nullable
    public final String notifyMediaStoreDatabase() {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        if (TextUtils.isEmpty((CharSequence)this.currentPhotoPath)) {
            return null;
        }
        File f = new File(this.currentPhotoPath);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        this.mContext.sendBroadcast(mediaScanIntent);
        return this.currentPhotoPath;
    }

    public final void onSaveInstanceState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null && this.currentPhotoPath != null) {
            savedInstanceState.putString(CAPTURED_PHOTO_PATH_KEY, this.currentPhotoPath);
        }
    }

    public final void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(CAPTURED_PHOTO_PATH_KEY)) {
            this.currentPhotoPath = savedInstanceState.getString(CAPTURED_PHOTO_PATH_KEY);
        }
    }

    public ImageCaptureManager(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
    }

    static {
        CAPTURED_PHOTO_PATH_KEY = CAPTURED_PHOTO_PATH_KEY;
        REQUEST_TAKE_PHOTO = 257;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldroidninja/filepicker/utils/ImageCaptureManager$Companion;", "", "()V", "CAPTURED_PHOTO_PATH_KEY", "", "REQUEST_TAKE_PHOTO", "", "getREQUEST_TAKE_PHOTO", "()I", "filepicker_release"})
    public static final class Companion {
        public final int getREQUEST_TAKE_PHOTO() {
            return REQUEST_TAKE_PHOTO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

