/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ)\u0010\n\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00062\b\u0010\r\u001a\u0004\u0018\u0001H\u000b\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u0016"}, d2={"Ldroidninja/filepicker/utils/FilePickerUtils;", "", "()V", "contains", "", "types", "", "", "path", "([Ljava/lang/String;Ljava/lang/String;)Z", "contains2", "T", "array", "v", "([Ljava/lang/Object;Ljava/lang/Object;)Z", "getFileExtension", "file", "Ljava/io/File;", "notifyMediaStore", "", "context", "Landroid/content/Context;", "filepicker_release"})
public final class FilePickerUtils {
    public static final FilePickerUtils INSTANCE;

    @NotNull
    public final String getFileExtension(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String name = file.getName();
        try {
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            String string3 = string2;
            int n = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            return string5;
        }
        catch (Exception e) {
            return "";
        }
    }

    public final boolean contains(@NotNull String[] types, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        for (String string2 : types) {
            String string3 = path;
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            if (!StringsKt.endsWith$default((String)string4, (String)string2, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    public final <T> boolean contains2(@NotNull T[] array, @Nullable T v) {
        Intrinsics.checkParameterIsNotNull(array, (String)"array");
        if (v == null) {
            for (T e : array) {
                if (e != null) continue;
                return true;
            }
        } else {
            for (T e : array) {
                if (e != v && !Intrinsics.areEqual(v, e)) continue;
                return true;
            }
        }
        return false;
    }

    public final void notifyMediaStore(@NotNull Context context, @Nullable String path) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (path != null && !TextUtils.isEmpty((CharSequence)path)) {
            Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            File f = new File(path);
            Uri contentUri = Uri.fromFile((File)f);
            mediaScanIntent.setData(contentUri);
            context.sendBroadcast(mediaScanIntent);
        }
    }

    private FilePickerUtils() {
    }

    static {
        FilePickerUtils filePickerUtils;
        INSTANCE = filePickerUtils = new FilePickerUtils();
    }
}

