/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.MediaDetailsActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FolderGridAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.fragments.PhotoPickerFragmentListener;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.utils.GridSpacingItemDecoration;
import droidninja.filepicker.utils.ImageCaptureManager;
import droidninja.filepicker.utils.MediaStoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\u0012\u0010*\u001a\u00020\u001e2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J&\u0010-\u001a\u0004\u0018\u00010!2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u00102\u001a\u00020\u001eH\u0016J\u0010\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u0006H\u0016J\u001a\u00105\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u00106\u001a\u00020\u001eH\u0002J\u0016\u00107\u001a\u00020\u001e2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006:"}, d2={"Ldroidninja/filepicker/fragments/MediaFolderPickerFragment;", "Ldroidninja/filepicker/fragments/BaseFragment;", "Ldroidninja/filepicker/adapters/FolderGridAdapter$FolderGridAdapterListener;", "()V", "data", "", "Ldroidninja/filepicker/models/PhotoDirectory;", "emptyView", "Landroid/widget/TextView;", "getEmptyView", "()Landroid/widget/TextView;", "setEmptyView", "(Landroid/widget/TextView;)V", "fileType", "", "imageCaptureManager", "Ldroidninja/filepicker/utils/ImageCaptureManager;", "mGlideRequestManager", "Lcom/bumptech/glide/RequestManager;", "mListener", "Ldroidninja/filepicker/fragments/PhotoPickerFragmentListener;", "photoGridAdapter", "Ldroidninja/filepicker/adapters/FolderGridAdapter;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "setRecyclerView", "(Landroidx/recyclerview/widget/RecyclerView;)V", "getDataFromMedia", "", "initView", "view", "Landroid/view/View;", "onActivityResult", "requestCode", "resultCode", "Landroid/content/Intent;", "onAttach", "context", "Landroid/content/Context;", "onCameraClicked", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDetach", "onFolderClicked", "photoDirectory", "onViewCreated", "resumeRequestsIfNotDestroyed", "updateList", "dirs", "Companion", "filepicker_release"})
public final class MediaFolderPickerFragment
extends BaseFragment
implements FolderGridAdapter.FolderGridAdapterListener {
    @NotNull
    public RecyclerView recyclerView;
    @NotNull
    public TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private FolderGridAdapter photoGridAdapter;
    private ImageCaptureManager imageCaptureManager;
    private RequestManager mGlideRequestManager;
    private int fileType;
    private List<PhotoDirectory> data;
    private static final String TAG;
    private static final int SCROLL_THRESHOLD = 30;
    private static final int PERMISSION_WRITE_EXTERNAL_STORAGE_RC = 908;
    public static final Companion Companion;

    @NotNull
    public final RecyclerView getRecyclerView() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        }
        return recyclerView;
    }

    public final void setRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"<set-?>");
        this.recyclerView = recyclerView;
    }

    @NotNull
    public final TextView getEmptyView() {
        TextView textView = this.emptyView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyView");
        }
        return textView;
    }

    public final void setEmptyView(@NotNull TextView textView) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
        this.emptyView = textView;
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_media_folder_picker, container, false);
    }

    public void onAttach(@Nullable Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            Context context2 = context;
            throw (Throwable)new RuntimeException(Intrinsics.stringPlus((String)(context2 != null ? context2.toString() : null), (Object)" must implement PhotoPickerFragmentListener"));
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RequestManager requestManager = Glide.with((Fragment)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)requestManager, (String)"Glide.with(this)");
        this.mGlideRequestManager = requestManager;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private final void initView(View view) {
        block5: {
            Bundle bundle;
            View view2 = view.findViewById(R.id.recyclerview);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.recyclerview)");
            this.recyclerView = (RecyclerView)view2;
            View view3 = view.findViewById(R.id.empty_view);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById(R.id.empty_view)");
            this.emptyView = (TextView)view3;
            Bundle bundle2 = this.getArguments();
            if (bundle2 == null) break block5;
            Bundle it = bundle = bundle2;
            this.fileType = it.getInt(BaseFragment.Companion.getFILE_TYPE());
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity != null) {
                FragmentActivity fragmentActivity2;
                FragmentActivity it2;
                FragmentActivity fragmentActivity3 = it2 = (fragmentActivity2 = fragmentActivity);
                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity3, (String)"it");
                this.imageCaptureManager = new ImageCaptureManager((Context)fragmentActivity3);
            }
            GridLayoutManager layoutManager = new GridLayoutManager((Context)this.getActivity(), 2);
            int spanCount = 2;
            int spacing = 5;
            boolean includeEdge = false;
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(spanCount, spacing, includeEdge));
            RecyclerView recyclerView2 = this.recyclerView;
            if (recyclerView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView2.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            RecyclerView recyclerView3 = this.recyclerView;
            if (recyclerView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView3.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            RecyclerView recyclerView4 = this.recyclerView;
            if (recyclerView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView4.addOnScrollListener(new RecyclerView.OnScrollListener(this){
                final /* synthetic */ MediaFolderPickerFragment this$0;
                {
                    this.this$0 = mediaFolderPickerFragment;
                }

                public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    super.onScrolled(recyclerView, dx, dy);
                    if (Math.abs(dy) > MediaFolderPickerFragment.access$getSCROLL_THRESHOLD$cp()) {
                        MediaFolderPickerFragment.access$getMGlideRequestManager$p(this.this$0).pauseRequests();
                    } else {
                        MediaFolderPickerFragment.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }

                public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    if (newState == 0) {
                        MediaFolderPickerFragment.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }
            });
            this.getDataFromMedia();
        }
    }

    private final void getDataFromMedia() {
        block0: {
            Context context;
            Context it;
            Bundle mediaStoreArgs = new Bundle();
            mediaStoreArgs.putBoolean("SHOW_GIF", PickerManager.INSTANCE.isShowGif());
            mediaStoreArgs.putInt("EXTRA_FILE_TYPE", this.fileType);
            Context context2 = this.getContext();
            if (context2 == null) break block0;
            Context context3 = it = (context = context2);
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"it");
            ContentResolver contentResolver = context3.getContentResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"it.contentResolver");
            MediaStoreHelper.INSTANCE.getDirs(contentResolver, mediaStoreArgs, new FileResultCallback<PhotoDirectory>(this, mediaStoreArgs){
                final /* synthetic */ MediaFolderPickerFragment this$0;
                final /* synthetic */ Bundle $mediaStoreArgs$inlined;
                {
                    this.this$0 = mediaFolderPickerFragment;
                    this.$mediaStoreArgs$inlined = bundle;
                }

                public void onResultCallback(@NotNull List<? extends PhotoDirectory> files) {
                    Intrinsics.checkParameterIsNotNull(files, (String)"files");
                    MediaFolderPickerFragment.access$updateList(this.this$0, CollectionsKt.toMutableList((Collection)files));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateList(List<PhotoDirectory> dirs) {
        block16: {
            block17: {
                FolderGridAdapter folderGridAdapter;
                Context context;
                Context it;
                RecyclerView recyclerView;
                View view;
                View view2 = this.getView();
                if (view2 == null) break block16;
                View it2 = view = view2;
                Log.i((String)"updateList", (String)("" + dirs.size()));
                this.data = dirs;
                Collection collection = dirs;
                if (!collection.isEmpty()) {
                    TextView textView = this.emptyView;
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emptyView");
                    }
                    textView.setVisibility(8);
                    recyclerView = this.recyclerView;
                    if (recyclerView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
                    }
                } else {
                    TextView textView = this.emptyView;
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emptyView");
                    }
                    textView.setVisibility(0);
                    RecyclerView recyclerView2 = this.recyclerView;
                    if (recyclerView2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
                    }
                    recyclerView2.setVisibility(8);
                    return;
                }
                recyclerView.setVisibility(0);
                PhotoDirectory photoDirectory = new PhotoDirectory();
                photoDirectory.setBucketId("ALL_PHOTOS_BUCKET_ID");
                if (this.fileType == 3) {
                    photoDirectory.setName(this.getString(R.string.all_videos));
                } else if (this.fileType == 1) {
                    photoDirectory.setName(this.getString(R.string.all_photos));
                } else {
                    photoDirectory.setName(this.getString(R.string.all_files));
                }
                if (dirs.size() > 0 && dirs.get(0).getMedias().size() > 0) {
                    photoDirectory.setDateAdded(dirs.get(0).getDateAdded());
                    Media media = dirs.get(0).getMedias().get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)media, (String)"dirs[0].medias[0]");
                    photoDirectory.setCoverPath(media.getPath());
                }
                int n = 0;
                int n2 = ((Collection)dirs).size();
                while (n < n2) {
                    void i;
                    photoDirectory.addPhotos(dirs.get((int)i).getMedias());
                    ++i;
                }
                dirs.add(0, photoDirectory);
                if (this.photoGridAdapter != null) break block17;
                Context context2 = this.getContext();
                if (context2 == null) break block16;
                Context context3 = it = (context = context2);
                Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"it");
                RequestManager requestManager = this.mGlideRequestManager;
                if (requestManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
                }
                List<PhotoDirectory> list = dirs;
                RequestManager requestManager2 = requestManager;
                Context context4 = context3;
                FolderGridAdapter folderGridAdapter2 = folderGridAdapter;
                FolderGridAdapter folderGridAdapter3 = folderGridAdapter;
                MediaFolderPickerFragment mediaFolderPickerFragment = this;
                List list2 = new ArrayList();
                folderGridAdapter2(context4, requestManager2, list, list2, this.fileType == 1 && PickerManager.INSTANCE.isEnableCamera());
                mediaFolderPickerFragment.photoGridAdapter = folderGridAdapter3;
                RecyclerView recyclerView3 = this.recyclerView;
                if (recyclerView3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
                }
                recyclerView3.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
                FolderGridAdapter folderGridAdapter4 = this.photoGridAdapter;
                if (folderGridAdapter4 != null) {
                    folderGridAdapter4.setFolderGridAdapterListener(this);
                }
                break block16;
            }
            FolderGridAdapter folderGridAdapter = this.photoGridAdapter;
            if (folderGridAdapter != null) {
                folderGridAdapter.setData(dirs);
            }
            FolderGridAdapter folderGridAdapter5 = this.photoGridAdapter;
            if (folderGridAdapter5 == null) break block16;
            folderGridAdapter5.notifyDataSetChanged();
        }
    }

    @Override
    public void onCameraClicked() {
        try {
            Context context = this.getContext();
            if (context != null) {
                Intent intent;
                Context context2;
                Context it = context2 = context;
                ImageCaptureManager imageCaptureManager = this.imageCaptureManager;
                Object object = intent = imageCaptureManager != null ? imageCaptureManager.dispatchTakePictureIntent() : null;
                if (intent != null) {
                    this.startActivityForResult(intent, ImageCaptureManager.Companion.getREQUEST_TAKE_PHOTO());
                } else {
                    Toast.makeText((Context)it, (int)R.string.no_camera_exists, (int)0).show();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onFolderClicked(@NotNull PhotoDirectory photoDirectory) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)photoDirectory, (String)"photoDirectory");
            Intent intent = new Intent((Context)this.getActivity(), MediaDetailsActivity.class);
            intent.putExtra(PhotoDirectory.class.getSimpleName(), (Parcelable)photoDirectory);
            intent.putExtra("EXTRA_FILE_TYPE", this.fileType);
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity == null) break block0;
            fragmentActivity.startActivityForResult(intent, 235);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        int n = requestCode;
        if (n == ImageCaptureManager.Companion.getREQUEST_TAKE_PHOTO() && resultCode == -1) {
            String imagePath;
            ImageCaptureManager imageCaptureManager = this.imageCaptureManager;
            String string2 = imagePath = imageCaptureManager != null ? imageCaptureManager.notifyMediaStoreDatabase() : null;
            if (imagePath != null && PickerManager.INSTANCE.getMaxCount() == 1) {
                PickerManager.INSTANCE.add(imagePath, 1);
                PhotoPickerFragmentListener photoPickerFragmentListener = this.mListener;
                if (photoPickerFragmentListener != null) {
                    photoPickerFragmentListener.onItemSelected();
                }
            } else {
                new Handler().postDelayed(new Runnable(this){
                    final /* synthetic */ MediaFolderPickerFragment this$0;

                    public final void run() {
                        MediaFolderPickerFragment.access$getDataFromMedia(this.this$0);
                    }
                    {
                        this.this$0 = mediaFolderPickerFragment;
                    }
                }, 1000L);
            }
        }
    }

    private final void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.INSTANCE.canLoadImage(this)) {
            return;
        }
        RequestManager requestManager = this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        requestManager.resumeRequests();
    }

    static {
        Companion = new Companion(null);
        TAG = MediaFolderPickerFragment.class.getSimpleName();
        SCROLL_THRESHOLD = 30;
        PERMISSION_WRITE_EXTERNAL_STORAGE_RC = 908;
    }

    public static final /* synthetic */ int access$getSCROLL_THRESHOLD$cp() {
        return SCROLL_THRESHOLD;
    }

    @NotNull
    public static final /* synthetic */ RequestManager access$getMGlideRequestManager$p(MediaFolderPickerFragment $this) {
        RequestManager requestManager = $this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        return requestManager;
    }

    public static final /* synthetic */ void access$setMGlideRequestManager$p(MediaFolderPickerFragment $this, @NotNull RequestManager requestManager) {
        $this.mGlideRequestManager = requestManager;
    }

    public static final /* synthetic */ void access$resumeRequestsIfNotDestroyed(MediaFolderPickerFragment $this) {
        $this.resumeRequestsIfNotDestroyed();
    }

    public static final /* synthetic */ void access$updateList(MediaFolderPickerFragment $this, @NotNull List dirs) {
        $this.updateList(dirs);
    }

    public static final /* synthetic */ void access$getDataFromMedia(MediaFolderPickerFragment $this) {
        $this.getDataFromMedia();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldroidninja/filepicker/fragments/MediaFolderPickerFragment$Companion;", "", "()V", "PERMISSION_WRITE_EXTERNAL_STORAGE_RC", "", "SCROLL_THRESHOLD", "TAG", "", "kotlin.jvm.PlatformType", "newInstance", "Ldroidninja/filepicker/fragments/MediaFolderPickerFragment;", "fileType", "filepicker_release"})
    public static final class Companion {
        @NotNull
        public final MediaFolderPickerFragment newInstance(int fileType) {
            MediaFolderPickerFragment photoPickerFragment = new MediaFolderPickerFragment();
            Bundle bun = new Bundle();
            bun.putInt(BaseFragment.Companion.getFILE_TYPE(), fileType);
            photoPickerFragment.setArguments(bun);
            return photoPickerFragment;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

