/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.PhotoGridAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.fragments.MediaDetailPickerFragment;
import droidninja.filepicker.fragments.PhotoPickerFragmentListener;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.utils.ImageCaptureManager;
import droidninja.filepicker.utils.MediaStoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010&\u001a\u00020\u001d2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010)\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u001c\u0010,\u001a\u00020\u001d2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J&\u00101\u001a\u0004\u0018\u00010 2\u0006\u0010/\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u00105\u001a\u00020\u001dH\u0016J\b\u00106\u001a\u00020\u001dH\u0016J\u0012\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010:\u001a\u00020\u001dH\u0016J\u001a\u0010;\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010<\u001a\u00020\u001dH\u0002J\u0016\u0010=\u001a\u00020\u001d2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Ldroidninja/filepicker/fragments/MediaDetailPickerFragment;", "Ldroidninja/filepicker/fragments/BaseFragment;", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "()V", "emptyView", "Landroid/widget/TextView;", "getEmptyView", "()Landroid/widget/TextView;", "setEmptyView", "(Landroid/widget/TextView;)V", "fileType", "", "imageCaptureManager", "Ldroidninja/filepicker/utils/ImageCaptureManager;", "mGlideRequestManager", "Lcom/bumptech/glide/RequestManager;", "mListener", "Ldroidninja/filepicker/fragments/PhotoPickerFragmentListener;", "photoGridAdapter", "Ldroidninja/filepicker/adapters/PhotoGridAdapter;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "setRecyclerView", "(Landroidx/recyclerview/widget/RecyclerView;)V", "selectAllItem", "Landroid/view/MenuItem;", "getDataFromMedia", "", "initView", "view", "Landroid/view/View;", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onAttach", "context", "Landroid/content/Context;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "inflater", "Landroid/view/MenuInflater;", "onCreateView", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "onDetach", "onItemSelected", "onOptionsItemSelected", "", "item", "onResume", "onViewCreated", "resumeRequestsIfNotDestroyed", "updateList", "dirs", "", "Ldroidninja/filepicker/models/PhotoDirectory;", "Companion", "filepicker_release"})
public final class MediaDetailPickerFragment
extends BaseFragment
implements FileAdapterListener {
    @NotNull
    public RecyclerView recyclerView;
    @NotNull
    public TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private PhotoGridAdapter photoGridAdapter;
    private ImageCaptureManager imageCaptureManager;
    private RequestManager mGlideRequestManager;
    private int fileType;
    private MenuItem selectAllItem;
    private static final String TAG;
    private static final int SCROLL_THRESHOLD = 30;
    public static final Companion Companion;

    @NotNull
    public final RecyclerView getRecyclerView() {
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
        }
        return recyclerView;
    }

    public final void setRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"<set-?>");
        this.recyclerView = recyclerView;
    }

    @NotNull
    public final TextView getEmptyView() {
        TextView textView = this.emptyView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyView");
        }
        return textView;
    }

    public final void setEmptyView(@NotNull TextView textView) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
        this.emptyView = textView;
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_photo_picker, container, false);
    }

    public void onAttach(@Nullable Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            Context context2 = context;
            throw (Throwable)new RuntimeException(Intrinsics.stringPlus((String)(context2 != null ? context2.toString() : null), (Object)" must implement PhotoPickerFragmentListener"));
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    @Override
    public void onItemSelected() {
        block3: {
            PhotoGridAdapter photoGridAdapter;
            PhotoPickerFragmentListener photoPickerFragmentListener = this.mListener;
            if (photoPickerFragmentListener != null) {
                photoPickerFragmentListener.onItemSelected();
            }
            PhotoGridAdapter photoGridAdapter2 = this.photoGridAdapter;
            if (photoGridAdapter2 == null) break block3;
            PhotoGridAdapter adapter = photoGridAdapter = photoGridAdapter2;
            MenuItem menuItem = this.selectAllItem;
            if (menuItem != null) {
                MenuItem menuItem2;
                MenuItem menuItem3 = menuItem2 = menuItem;
                if (adapter.getItemCount() == adapter.getSelectedItemCount()) {
                    menuItem3.setIcon(R.drawable.ic_select_all);
                    menuItem3.setChecked(true);
                }
            }
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(PickerManager.INSTANCE.hasSelectAll());
        RequestManager requestManager = Glide.with((Fragment)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)requestManager, (String)"Glide.with(this)");
        this.mGlideRequestManager = requestManager;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private final void initView(View view) {
        block4: {
            Bundle bundle;
            View view2 = view.findViewById(R.id.recyclerview);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.recyclerview)");
            this.recyclerView = (RecyclerView)view2;
            View view3 = view.findViewById(R.id.empty_view);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById(R.id.empty_view)");
            this.emptyView = (TextView)view3;
            Bundle bundle2 = this.getArguments();
            if (bundle2 == null) break block4;
            Bundle it = bundle = bundle2;
            this.fileType = it.getInt(BaseFragment.Companion.getFILE_TYPE());
            FragmentActivity fragmentActivity = this.getActivity();
            if (fragmentActivity != null) {
                FragmentActivity fragmentActivity2;
                FragmentActivity it2;
                FragmentActivity fragmentActivity3 = it2 = (fragmentActivity2 = fragmentActivity);
                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity3, (String)"it");
                this.imageCaptureManager = new ImageCaptureManager((Context)fragmentActivity3);
            }
            StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(3, 1);
            layoutManager.setGapStrategy(2);
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            RecyclerView recyclerView2 = this.recyclerView;
            if (recyclerView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView2.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            RecyclerView recyclerView3 = this.recyclerView;
            if (recyclerView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView3.addOnScrollListener(new RecyclerView.OnScrollListener(this){
                final /* synthetic */ MediaDetailPickerFragment this$0;
                {
                    this.this$0 = mediaDetailPickerFragment;
                }

                public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    super.onScrolled(recyclerView, dx, dy);
                    if (Math.abs(dy) > MediaDetailPickerFragment.access$getSCROLL_THRESHOLD$cp()) {
                        MediaDetailPickerFragment.access$getMGlideRequestManager$p(this.this$0).pauseRequests();
                    } else {
                        MediaDetailPickerFragment.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }

                public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    if (newState == 0) {
                        MediaDetailPickerFragment.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }
            });
        }
    }

    public void onResume() {
        super.onResume();
        this.getDataFromMedia();
    }

    private final void getDataFromMedia() {
        block0: {
            Context context;
            Context it;
            Bundle mediaStoreArgs = new Bundle();
            mediaStoreArgs.putInt("EXTRA_FILE_TYPE", this.fileType);
            Context context2 = this.getContext();
            if (context2 == null) break block0;
            Context context3 = it = (context = context2);
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"it");
            ContentResolver contentResolver = context3.getContentResolver();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"it.contentResolver");
            MediaStoreHelper.INSTANCE.getDirs(contentResolver, mediaStoreArgs, new FileResultCallback<PhotoDirectory>(this, mediaStoreArgs){
                final /* synthetic */ MediaDetailPickerFragment this$0;
                final /* synthetic */ Bundle $mediaStoreArgs$inlined;
                {
                    this.this$0 = mediaDetailPickerFragment;
                    this.$mediaStoreArgs$inlined = bundle;
                }

                public void onResultCallback(@NotNull List<? extends PhotoDirectory> files) {
                    Intrinsics.checkParameterIsNotNull(files, (String)"files");
                    MediaDetailPickerFragment.access$updateList(this.this$0, files);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateList(List<? extends PhotoDirectory> dirs) {
        block8: {
            Context it;
            ArrayList<Media> medias;
            block9: {
                Context context;
                View view;
                View view2 = this.getView();
                if (view2 == null) break block8;
                View $noName_0 = view = view2;
                medias = new ArrayList<Media>();
                int n = 0;
                int n2 = ((Collection)dirs).size();
                while (n < n2) {
                    void i;
                    medias.addAll((Collection)dirs.get((int)i).getMedias());
                    ++i;
                }
                CollectionsKt.sortWith((List)medias, (Comparator)updateList.1.1.INSTANCE);
                if (medias.size() > 0) {
                    TextView textView = this.emptyView;
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emptyView");
                    }
                    textView.setVisibility(8);
                } else {
                    TextView textView = this.emptyView;
                    if (textView == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emptyView");
                    }
                    textView.setVisibility(0);
                }
                Context context2 = this.getContext();
                if (context2 == null) break block8;
                it = context = context2;
                if (this.photoGridAdapter == null) break block9;
                PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
                if (photoGridAdapter != null) {
                    photoGridAdapter.setData((List)medias);
                }
                PhotoGridAdapter photoGridAdapter2 = this.photoGridAdapter;
                if (photoGridAdapter2 == null) break block8;
                photoGridAdapter2.notifyDataSetChanged();
                break block8;
            }
            Context context = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"it");
            RequestManager requestManager = this.mGlideRequestManager;
            if (requestManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
            }
            this.photoGridAdapter = new PhotoGridAdapter(context, requestManager, medias, PickerManager.INSTANCE.getSelectedPhotos(), this.fileType == 1 && PickerManager.INSTANCE.isEnableCamera(), this);
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recyclerView");
            }
            recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
            if (photoGridAdapter == null) break block8;
            photoGridAdapter.setCameraListener(new View.OnClickListener(medias, this, dirs){
                final /* synthetic */ ArrayList $medias$inlined;
                final /* synthetic */ MediaDetailPickerFragment this$0;
                final /* synthetic */ List $dirs$inlined;
                {
                    this.$medias$inlined = arrayList;
                    this.this$0 = mediaDetailPickerFragment;
                    this.$dirs$inlined = list;
                }

                public final void onClick(View it) {
                    try {
                        Intent intent;
                        ImageCaptureManager imageCaptureManager = MediaDetailPickerFragment.access$getImageCaptureManager$p(this.this$0);
                        Object object = intent = imageCaptureManager != null ? imageCaptureManager.dispatchTakePictureIntent() : null;
                        if (intent != null) {
                            this.this$0.startActivityForResult(intent, ImageCaptureManager.Companion.getREQUEST_TAKE_PHOTO());
                        } else {
                            Toast.makeText((Context)((Context)this.this$0.getActivity()), (int)R.string.no_camera_exists, (int)0).show();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        int n = requestCode;
        if (n == ImageCaptureManager.Companion.getREQUEST_TAKE_PHOTO() && resultCode == -1) {
            String imagePath;
            ImageCaptureManager imageCaptureManager = this.imageCaptureManager;
            String string2 = imagePath = imageCaptureManager != null ? imageCaptureManager.notifyMediaStoreDatabase() : null;
            if (imagePath != null && PickerManager.INSTANCE.getMaxCount() == 1) {
                PickerManager.INSTANCE.add(imagePath, 1);
                PhotoPickerFragmentListener photoPickerFragmentListener = this.mListener;
                if (photoPickerFragmentListener != null) {
                    photoPickerFragmentListener.onItemSelected();
                }
            } else {
                new Handler().postDelayed(new Runnable(this){
                    final /* synthetic */ MediaDetailPickerFragment this$0;

                    public final void run() {
                        MediaDetailPickerFragment.access$getDataFromMedia(this.this$0);
                    }
                    {
                        this.this$0 = mediaDetailPickerFragment;
                    }
                }, 1000L);
            }
        }
    }

    private final void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.INSTANCE.canLoadImage(this)) {
            return;
        }
        RequestManager requestManager = this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        requestManager.resumeRequests();
    }

    public void onCreateOptionsMenu(@Nullable Menu menu2, @Nullable MenuInflater inflater) {
        MenuInflater menuInflater = inflater;
        if (menuInflater != null) {
            menuInflater.inflate(R.menu.select_menu, menu2);
        }
        Menu menu3 = menu2;
        this.selectAllItem = menu3 != null ? menu3.findItem(R.id.action_select) : null;
        this.onItemSelected();
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(@Nullable MenuItem item) {
        Integer itemId;
        MenuItem menuItem = item;
        Integer n = itemId = menuItem != null ? Integer.valueOf(menuItem.getItemId()) : null;
        int n2 = R.id.action_select;
        if (n != null && n == n2) {
            PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
            if (photoGridAdapter != null) {
                PhotoGridAdapter photoGridAdapter2;
                PhotoGridAdapter adapter = photoGridAdapter2 = photoGridAdapter;
                adapter.selectAll();
                MenuItem menuItem2 = this.selectAllItem;
                if (menuItem2 != null) {
                    MenuItem menuItem3 = menuItem2;
                    MenuItem it = menuItem3;
                    if (it.isChecked()) {
                        PickerManager.INSTANCE.clearSelections();
                        adapter.clearSelection();
                        it.setIcon(R.drawable.ic_deselect_all);
                    } else {
                        adapter.selectAll();
                        PickerManager.INSTANCE.add(adapter.getSelectedPaths(), 1);
                        it.setIcon(R.drawable.ic_select_all);
                    }
                    MenuItem menuItem4 = this.selectAllItem;
                    if (menuItem4 != null) {
                        menuItem4.setChecked(!it.isChecked());
                    }
                    PhotoPickerFragmentListener photoPickerFragmentListener = this.mListener;
                    if (photoPickerFragmentListener != null) {
                        photoPickerFragmentListener.onItemSelected();
                    }
                }
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    static {
        Companion = new Companion(null);
        TAG = MediaDetailPickerFragment.class.getSimpleName();
        SCROLL_THRESHOLD = 30;
    }

    public static final /* synthetic */ int access$getSCROLL_THRESHOLD$cp() {
        return SCROLL_THRESHOLD;
    }

    @NotNull
    public static final /* synthetic */ RequestManager access$getMGlideRequestManager$p(MediaDetailPickerFragment $this) {
        RequestManager requestManager = $this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        return requestManager;
    }

    public static final /* synthetic */ void access$setMGlideRequestManager$p(MediaDetailPickerFragment $this, @NotNull RequestManager requestManager) {
        $this.mGlideRequestManager = requestManager;
    }

    public static final /* synthetic */ void access$resumeRequestsIfNotDestroyed(MediaDetailPickerFragment $this) {
        $this.resumeRequestsIfNotDestroyed();
    }

    public static final /* synthetic */ void access$updateList(MediaDetailPickerFragment $this, @NotNull List dirs) {
        $this.updateList(dirs);
    }

    @Nullable
    public static final /* synthetic */ ImageCaptureManager access$getImageCaptureManager$p(MediaDetailPickerFragment $this) {
        return $this.imageCaptureManager;
    }

    public static final /* synthetic */ void access$setImageCaptureManager$p(MediaDetailPickerFragment $this, @Nullable ImageCaptureManager imageCaptureManager) {
        $this.imageCaptureManager = imageCaptureManager;
    }

    public static final /* synthetic */ void access$getDataFromMedia(MediaDetailPickerFragment $this) {
        $this.getDataFromMedia();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldroidninja/filepicker/fragments/MediaDetailPickerFragment$Companion;", "", "()V", "SCROLL_THRESHOLD", "", "TAG", "", "kotlin.jvm.PlatformType", "newInstance", "Ldroidninja/filepicker/fragments/MediaDetailPickerFragment;", "fileType", "filepicker_release"})
    public static final class Companion {
        @NotNull
        public final MediaDetailPickerFragment newInstance(int fileType) {
            MediaDetailPickerFragment mediaDetailPickerFragment = new MediaDetailPickerFragment();
            Bundle bun = new Bundle();
            bun.putInt(BaseFragment.Companion.getFILE_TYPE(), fileType);
            mediaDetailPickerFragment.setArguments(bun);
            return mediaDetailPickerFragment;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

