/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.cursors;

import android.content.ContentResolver;
import android.database.Cursor;
import android.os.AsyncTask;
import android.provider.MediaStore;
import android.text.TextUtils;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.cursors.loadercallbacks.FileMapResultCallback;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.models.FileType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002&\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00030\u0001B5\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aH\u0002J3\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0010\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u0004\u0018\u00010\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010#\u001a\u00020\u0011H\u0002J\"\u0010$\u001a\u00020%2\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0014R\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldroidninja/filepicker/cursors/DocScannerTask;", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "", "Ldroidninja/filepicker/models/FileType;", "", "Ldroidninja/filepicker/models/Document;", "contentResolver", "Landroid/content/ContentResolver;", "fileTypes", "comparator", "Ljava/util/Comparator;", "resultCallback", "Ldroidninja/filepicker/cursors/loadercallbacks/FileMapResultCallback;", "(Landroid/content/ContentResolver;Ljava/util/List;Ljava/util/Comparator;Ldroidninja/filepicker/cursors/loadercallbacks/FileMapResultCallback;)V", "DOC_PROJECTION", "", "", "getDOC_PROJECTION", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getContentResolver", "()Landroid/content/ContentResolver;", "createDocumentType", "Ljava/util/HashMap;", "documents", "Ljava/util/ArrayList;", "doInBackground", "voids", "([Ljava/lang/Void;)Ljava/util/Map;", "getDocumentFromCursor", "data", "Landroid/database/Cursor;", "getFileType", "types", "path", "onPostExecute", "", "filepicker_release"})
public final class DocScannerTask
extends AsyncTask<Void, Void, Map<FileType, ? extends List<? extends Document>>> {
    @NotNull
    private final String[] DOC_PROJECTION;
    @NotNull
    private final ContentResolver contentResolver;
    private final List<FileType> fileTypes;
    private final Comparator<Document> comparator;
    private final FileMapResultCallback resultCallback;

    @NotNull
    public final String[] getDOC_PROJECTION() {
        return this.DOC_PROJECTION;
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<FileType, List<Document>> createDocumentType(ArrayList<Document> documents) {
        HashMap<FileType, List<Document>> documentMap = new HashMap<FileType, List<Document>>();
        for (FileType fileType : this.fileTypes) {
            Object object;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)documents;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Document document = (Document)element$iv$iv;
                if (!document.isThisType(fileType.extensions)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List documentListFilteredByType = (List)destination$iv$iv;
            Comparator<Document> comparator = this.comparator;
            if (comparator != null) {
                object = comparator;
                Comparator<Document> it = object;
                CollectionsKt.sortedWith((Iterable)documentListFilteredByType, this.comparator);
            }
            object = documentMap;
            iterable = documentListFilteredByType;
            object.put(fileType, iterable);
        }
        return documentMap;
    }

    @NotNull
    protected Map<FileType, List<Document>> doInBackground(Void ... voids) {
        Intrinsics.checkParameterIsNotNull((Object)voids, (String)"voids");
        ArrayList<Document> documents = new ArrayList<Document>();
        String selection = "media_type!=1 AND media_type!=3";
        Cursor cursor = this.contentResolver.query(MediaStore.Files.getContentUri((String)"external"), this.DOC_PROJECTION, selection, null, "date_added DESC");
        if (cursor != null) {
            documents = this.getDocumentFromCursor(cursor);
            cursor.close();
        }
        return this.createDocumentType(documents);
    }

    protected void onPostExecute(@NotNull Map<FileType, ? extends List<? extends Document>> documents) {
        block0: {
            Intrinsics.checkParameterIsNotNull(documents, (String)"documents");
            FileMapResultCallback fileMapResultCallback = this.resultCallback;
            if (fileMapResultCallback == null) break block0;
            fileMapResultCallback.onResultCallback(documents);
        }
    }

    private final ArrayList<Document> getDocumentFromCursor(Cursor data) {
        ArrayList<Document> documents = new ArrayList<Document>();
        while (data.moveToNext()) {
            int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
            String path = data.getString(data.getColumnIndexOrThrow("_data"));
            String title = data.getString(data.getColumnIndexOrThrow("title"));
            if (path == null) continue;
            FileType fileType = this.getFileType(PickerManager.INSTANCE.getFileTypes(), path);
            File file = new File(path);
            if (fileType == null || file.isDirectory() || !file.exists()) continue;
            Document document = new Document(imageId, title, path);
            document.setFileType(fileType);
            String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
            if (mimeType != null && !TextUtils.isEmpty((CharSequence)mimeType)) {
                document.setMimeType(mimeType);
            } else {
                document.setMimeType("");
            }
            document.setSize(data.getString(data.getColumnIndexOrThrow("_size")));
            if (documents.contains(document)) continue;
            documents.add(document);
        }
        return documents;
    }

    /*
     * WARNING - void declaration
     */
    private final FileType getFileType(ArrayList<FileType> types, String path) {
        int n = 0;
        int n2 = ((Collection)types).size();
        while (n < n2) {
            void index;
            String[] stringArray = types.get((int)index).extensions;
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string2;
                String string3 = string2 = stringArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"string");
                if (!StringsKt.endsWith$default((String)path, (String)string3, (boolean)false, (int)2, null)) continue;
                return types.get((int)index);
            }
            ++index;
        }
        return null;
    }

    @NotNull
    public final ContentResolver getContentResolver() {
        return this.contentResolver;
    }

    public DocScannerTask(@NotNull ContentResolver contentResolver, @NotNull List<? extends FileType> fileTypes, @Nullable Comparator<Document> comparator, @Nullable FileMapResultCallback resultCallback) {
        Intrinsics.checkParameterIsNotNull((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkParameterIsNotNull(fileTypes, (String)"fileTypes");
        this.contentResolver = contentResolver;
        this.fileTypes = fileTypes;
        this.comparator = comparator;
        this.resultCallback = resultCallback;
        this.DOC_PROJECTION = new String[]{"_id", "_data", "mime_type", "_size", "date_added", "title"};
    }
}

