/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.text.format.Formatter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.views.SmoothCheckBox;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001cB3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldroidninja/filepicker/adapters/FileListAdapter;", "Ldroidninja/filepicker/adapters/SelectableAdapter;", "Ldroidninja/filepicker/adapters/FileListAdapter$FileViewHolder;", "Ldroidninja/filepicker/models/Document;", "Landroid/widget/Filterable;", "context", "Landroid/content/Context;", "mFilteredList", "", "selectedPaths", "", "mListener", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "(Landroid/content/Context;Ljava/util/List;Ljava/util/List;Ldroidninja/filepicker/adapters/FileAdapterListener;)V", "getFilter", "Landroid/widget/Filter;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onItemClicked", "document", "FileViewHolder", "filepicker_release"})
public final class FileListAdapter
extends SelectableAdapter<FileViewHolder, Document>
implements Filterable {
    private final Context context;
    private List<? extends Document> mFilteredList;
    private final FileAdapterListener mListener;

    @NotNull
    public FileViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View itemView;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        View view = itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_doc_layout, parent, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        return new FileViewHolder(view);
    }

    public void onBindViewHolder(@NotNull FileViewHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Document document = this.mFilteredList.get(position);
        int drawable2 = document.getFileType().getDrawable();
        holder.getImageView$filepicker_release().setImageResource(drawable2);
        if (drawable2 == R.drawable.icon_file_unknown || drawable2 == R.drawable.icon_file_pdf) {
            holder.getFileTypeTv$filepicker_release().setVisibility(0);
            holder.getFileTypeTv$filepicker_release().setText((CharSequence)document.getFileType().title);
        } else {
            holder.getFileTypeTv$filepicker_release().setVisibility(8);
        }
        holder.getFileNameTextView$filepicker_release().setText((CharSequence)document.getTitle());
        holder.getFileSizeTextView$filepicker_release().setText((CharSequence)Formatter.formatShortFileSize((Context)this.context, (long)Long.parseLong(document.getSize())));
        holder.itemView.setOnClickListener(new View.OnClickListener(this, document, holder){
            final /* synthetic */ FileListAdapter this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ FileViewHolder $holder;

            public final void onClick(View it) {
                FileListAdapter.access$onItemClicked(this.this$0, this.$document, this.$holder);
            }
            {
                this.this$0 = fileListAdapter;
                this.$document = document;
                this.$holder = fileViewHolder;
            }
        });
        holder.getCheckBox$filepicker_release().setOnCheckedChangeListener(null);
        holder.getCheckBox$filepicker_release().setOnClickListener(new View.OnClickListener(this, document, holder){
            final /* synthetic */ FileListAdapter this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ FileViewHolder $holder;

            public final void onClick(View it) {
                FileListAdapter.access$onItemClicked(this.this$0, this.$document, this.$holder);
            }
            {
                this.this$0 = fileListAdapter;
                this.$document = document;
                this.$holder = fileViewHolder;
            }
        });
        holder.getCheckBox$filepicker_release().setChecked(this.isSelected((BaseFile)document));
        holder.itemView.setBackgroundResource(this.isSelected((BaseFile)document) ? R.color.bg_gray : 17170443);
        holder.getCheckBox$filepicker_release().setVisibility(this.isSelected((BaseFile)document) ? 0 : 8);
        holder.getCheckBox$filepicker_release().setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(this, document, holder){
            final /* synthetic */ FileListAdapter this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ FileViewHolder $holder;

            public void onCheckedChanged(@NotNull SmoothCheckBox checkBox, boolean isChecked) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)checkBox), (String)"checkBox");
                this.this$0.toggleSelection((BaseFile)this.$document);
                this.$holder.itemView.setBackgroundResource(isChecked ? R.color.bg_gray : 17170443);
            }
            {
                this.this$0 = $outer;
                this.$document = $captured_local_variable$1;
                this.$holder = $captured_local_variable$2;
            }
        });
    }

    private final void onItemClicked(Document document, FileViewHolder holder) {
        block5: {
            if (PickerManager.INSTANCE.getMaxCount() == 1) {
                PickerManager.INSTANCE.add(document.getPath(), 2);
            } else if (holder.getCheckBox$filepicker_release().isChecked()) {
                String string2 = document.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"document.path");
                PickerManager.INSTANCE.remove(string2, 2);
                holder.getCheckBox$filepicker_release().setChecked(!holder.getCheckBox$filepicker_release().isChecked(), true);
                holder.getCheckBox$filepicker_release().setVisibility(8);
            } else if (PickerManager.INSTANCE.shouldAdd()) {
                PickerManager.INSTANCE.add(document.getPath(), 2);
                holder.getCheckBox$filepicker_release().setChecked(!holder.getCheckBox$filepicker_release().isChecked(), true);
                holder.getCheckBox$filepicker_release().setVisibility(0);
            }
            FileAdapterListener fileAdapterListener = this.mListener;
            if (fileAdapterListener == null) break block5;
            fileAdapterListener.onItemSelected();
        }
    }

    public int getItemCount() {
        return this.mFilteredList.size();
    }

    @NotNull
    public Filter getFilter() {
        return new Filter(this){
            final /* synthetic */ FileListAdapter this$0;

            @NotNull
            protected Filter.FilterResults performFiltering(@NotNull CharSequence charSequence) {
                Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
                String charString = ((Object)charSequence).toString();
                CharSequence charSequence2 = charString;
                if (charSequence2.length() == 0) {
                    FileListAdapter.access$setMFilteredList$p(this.this$0, this.this$0.getItems());
                } else {
                    ArrayList<Document> filteredList = new ArrayList<Document>();
                    for (Document document : this.this$0.getItems()) {
                        String string2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)document.getTitle(), (String)"document.title");
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)charString, (boolean)false, (int)2, null)) continue;
                        filteredList.add(document);
                    }
                    FileListAdapter.access$setMFilteredList$p(this.this$0, filteredList);
                }
                Filter.FilterResults filterResults = new Filter.FilterResults();
                filterResults.values = FileListAdapter.access$getMFilteredList$p(this.this$0);
                return filterResults;
            }

            protected void publishResults(@NotNull CharSequence charSequence, @NotNull Filter.FilterResults filterResults) {
                Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
                Intrinsics.checkParameterIsNotNull((Object)filterResults, (String)"filterResults");
                Object object = filterResults.values;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<droidninja.filepicker.models.Document>");
                }
                FileListAdapter.access$setMFilteredList$p(this.this$0, (List)object);
                this.this$0.notifyDataSetChanged();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public FileListAdapter(@NotNull Context context, @NotNull List<? extends Document> mFilteredList, @NotNull List<String> selectedPaths, @Nullable FileAdapterListener mListener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(mFilteredList, (String)"mFilteredList");
        Intrinsics.checkParameterIsNotNull(selectedPaths, (String)"selectedPaths");
        super(mFilteredList, selectedPaths);
        this.context = context;
        this.mFilteredList = mFilteredList;
        this.mListener = mListener;
    }

    public static final /* synthetic */ void access$onItemClicked(FileListAdapter $this, @NotNull Document document, @NotNull FileViewHolder holder) {
        $this.onItemClicked(document, holder);
    }

    @NotNull
    public static final /* synthetic */ List access$getMFilteredList$p(FileListAdapter $this) {
        return $this.mFilteredList;
    }

    public static final /* synthetic */ void access$setMFilteredList$p(FileListAdapter $this, @NotNull List list) {
        $this.mFilteredList = list;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldroidninja/filepicker/adapters/FileListAdapter$FileViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "checkBox", "Ldroidninja/filepicker/views/SmoothCheckBox;", "getCheckBox$filepicker_release", "()Ldroidninja/filepicker/views/SmoothCheckBox;", "setCheckBox$filepicker_release", "(Ldroidninja/filepicker/views/SmoothCheckBox;)V", "fileNameTextView", "Landroid/widget/TextView;", "getFileNameTextView$filepicker_release", "()Landroid/widget/TextView;", "setFileNameTextView$filepicker_release", "(Landroid/widget/TextView;)V", "fileSizeTextView", "getFileSizeTextView$filepicker_release", "setFileSizeTextView$filepicker_release", "fileTypeTv", "getFileTypeTv$filepicker_release", "setFileTypeTv$filepicker_release", "imageView", "Landroid/widget/ImageView;", "getImageView$filepicker_release", "()Landroid/widget/ImageView;", "setImageView$filepicker_release", "(Landroid/widget/ImageView;)V", "filepicker_release"})
    public static final class FileViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView fileTypeTv;
        @NotNull
        private SmoothCheckBox checkBox;
        @NotNull
        private ImageView imageView;
        @NotNull
        private TextView fileNameTextView;
        @NotNull
        private TextView fileSizeTextView;

        @NotNull
        public final TextView getFileTypeTv$filepicker_release() {
            return this.fileTypeTv;
        }

        public final void setFileTypeTv$filepicker_release(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.fileTypeTv = textView;
        }

        @NotNull
        public final SmoothCheckBox getCheckBox$filepicker_release() {
            return this.checkBox;
        }

        public final void setCheckBox$filepicker_release(@NotNull SmoothCheckBox smoothCheckBox) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)smoothCheckBox), (String)"<set-?>");
            this.checkBox = smoothCheckBox;
        }

        @NotNull
        public final ImageView getImageView$filepicker_release() {
            return this.imageView;
        }

        public final void setImageView$filepicker_release(@NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"<set-?>");
            this.imageView = imageView;
        }

        @NotNull
        public final TextView getFileNameTextView$filepicker_release() {
            return this.fileNameTextView;
        }

        public final void setFileNameTextView$filepicker_release(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.fileNameTextView = textView;
        }

        @NotNull
        public final TextView getFileSizeTextView$filepicker_release() {
            return this.fileSizeTextView;
        }

        public final void setFileSizeTextView$filepicker_release(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.fileSizeTextView = textView;
        }

        public FileViewHolder(@NotNull View itemView) {
            Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.checkbox);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView.findViewById(R.id.checkbox)");
            this.checkBox = (SmoothCheckBox)view;
            View view2 = itemView.findViewById(R.id.file_iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"itemView.findViewById(R.id.file_iv)");
            this.imageView = (ImageView)view2;
            View view3 = itemView.findViewById(R.id.file_name_tv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"itemView.findViewById(R.id.file_name_tv)");
            this.fileNameTextView = (TextView)view3;
            View view4 = itemView.findViewById(R.id.file_type_tv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"itemView.findViewById(R.id.file_type_tv)");
            this.fileTypeTv = (TextView)view4;
            View view5 = itemView.findViewById(R.id.file_size_tv);
            Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"itemView.findViewById(R.id.file_size_tv)");
            this.fileSizeTextView = (TextView)view5;
        }
    }
}

