/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.FileType;
import droidninja.filepicker.models.sort.SortingTypes;
import droidninja.filepicker.utils.Orientation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020!0'2\u0006\u0010>\u001a\u00020\u0004J\u0018\u0010;\u001a\u00020<2\b\u0010?\u001a\u0004\u0018\u00010!2\u0006\u0010>\u001a\u00020\u0004J\u0006\u0010@\u001a\u00020<J\u000e\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020\rJ\u0006\u0010C\u001a\u00020<J\u0014\u0010D\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020!0'J\u000e\u0010E\u001a\u00020<2\u0006\u0010-\u001a\u00020\u000fJ\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\r0'J\u0006\u0010G\u001a\u00020\u0004J\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020!0'2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0'J\u0006\u0010K\u001a\u00020\u000fJ\u0016\u0010L\u001a\u00020<2\u0006\u0010?\u001a\u00020!2\u0006\u0010>\u001a\u00020\u0004J\u0006\u0010M\u001a\u00020<J\u000e\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020\u0004J\u000e\u0010P\u001a\u00020<2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010Q\u001a\u00020<2\u0006\u0010.\u001a\u00020\u000fJ\u0006\u0010R\u001a\u00020\u000fJ\u0006\u0010,\u001a\u00020\u000fJ\u0006\u0010S\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u00020\u001b8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020!0'\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u000e\u0010,\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0006\"\u0004\b7\u0010\bR\u001c\u00108\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010#\"\u0004\b:\u0010%\u00a8\u0006T"}, d2={"Ldroidninja/filepicker/PickerManager;", "", "()V", "cameraDrawable", "", "getCameraDrawable", "()I", "setCameraDrawable", "(I)V", "currentCount", "getCurrentCount", "fileTypes", "Ljava/util/LinkedHashSet;", "Ldroidninja/filepicker/models/FileType;", "isDocSupport", "", "()Z", "setDocSupport", "(Z)V", "isEnableCamera", "setEnableCamera", "isShowFolderView", "setShowFolderView", "isShowGif", "setShowGif", "maxCount", "orientation", "Ldroidninja/filepicker/utils/Orientation;", "getOrientation", "()Ldroidninja/filepicker/utils/Orientation;", "setOrientation", "(Ldroidninja/filepicker/utils/Orientation;)V", "providerAuthorities", "", "getProviderAuthorities", "()Ljava/lang/String;", "setProviderAuthorities", "(Ljava/lang/String;)V", "selectedFiles", "Ljava/util/ArrayList;", "getSelectedFiles", "()Ljava/util/ArrayList;", "selectedPhotos", "getSelectedPhotos", "showImages", "showSelectAll", "showVideos", "sortingType", "Ldroidninja/filepicker/models/sort/SortingTypes;", "getSortingType", "()Ldroidninja/filepicker/models/sort/SortingTypes;", "setSortingType", "(Ldroidninja/filepicker/models/sort/SortingTypes;)V", "theme", "getTheme", "setTheme", "title", "getTitle", "setTitle", "add", "", "paths", "type", "path", "addDocTypes", "addFileType", "fileType", "clearSelections", "deleteMedia", "enableSelectAll", "getFileTypes", "getMaxCount", "getSelectedFilePaths", "files", "Ldroidninja/filepicker/models/BaseFile;", "hasSelectAll", "remove", "reset", "setMaxCount", "count", "setShowImages", "setShowVideos", "shouldAdd", "showVideo", "filepicker_release"})
public final class PickerManager {
    private static int maxCount;
    private static boolean showImages;
    private static int cameraDrawable;
    @NotNull
    private static SortingTypes sortingType;
    @NotNull
    private static final ArrayList<String> selectedPhotos;
    @NotNull
    private static final ArrayList<String> selectedFiles;
    private static final LinkedHashSet<FileType> fileTypes;
    private static int theme;
    @Nullable
    private static String title;
    private static boolean showVideos;
    private static boolean isShowGif;
    private static boolean showSelectAll;
    private static boolean isDocSupport;
    private static boolean isEnableCamera;
    @NotNull
    private static Orientation orientation;
    private static boolean isShowFolderView;
    @Nullable
    private static String providerAuthorities;
    public static final PickerManager INSTANCE;

    public final int getCameraDrawable() {
        return cameraDrawable;
    }

    public final void setCameraDrawable(int n) {
        cameraDrawable = n;
    }

    @NotNull
    public final SortingTypes getSortingType() {
        return sortingType;
    }

    public final void setSortingType(@NotNull SortingTypes sortingTypes) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortingTypes), (String)"<set-?>");
        sortingType = sortingTypes;
    }

    @NotNull
    public final ArrayList<String> getSelectedPhotos() {
        return selectedPhotos;
    }

    @NotNull
    public final ArrayList<String> getSelectedFiles() {
        return selectedFiles;
    }

    public final int getTheme() {
        return theme;
    }

    public final void setTheme(int n) {
        theme = n;
    }

    @Nullable
    public final String getTitle() {
        return title;
    }

    public final void setTitle(@Nullable String string2) {
        title = string2;
    }

    public final boolean isShowGif() {
        return isShowGif;
    }

    public final void setShowGif(boolean bl) {
        isShowGif = bl;
    }

    public final boolean isDocSupport() {
        return isDocSupport;
    }

    public final void setDocSupport(boolean bl) {
        isDocSupport = bl;
    }

    public final boolean isEnableCamera() {
        return isEnableCamera;
    }

    public final void setEnableCamera(boolean bl) {
        isEnableCamera = bl;
    }

    @NotNull
    public final Orientation getOrientation() {
        return orientation;
    }

    public final void setOrientation(@NotNull Orientation orientation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)orientation), (String)"<set-?>");
        PickerManager.orientation = orientation;
    }

    public final boolean isShowFolderView() {
        return isShowFolderView;
    }

    public final void setShowFolderView(boolean bl) {
        isShowFolderView = bl;
    }

    @Nullable
    public final String getProviderAuthorities() {
        return providerAuthorities;
    }

    public final void setProviderAuthorities(@Nullable String string2) {
        providerAuthorities = string2;
    }

    public final int getCurrentCount() {
        return selectedPhotos.size() + selectedFiles.size();
    }

    public final void setMaxCount(int count) {
        this.reset();
        maxCount = count;
    }

    public final int getMaxCount() {
        return maxCount;
    }

    public final void add(@Nullable String path, int type) {
        if (path != null && this.shouldAdd()) {
            if (!selectedPhotos.contains(path) && type == 1) {
                selectedPhotos.add(path);
            } else if (!selectedFiles.contains(path) && type == 2) {
                selectedFiles.add(path);
            } else {
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull ArrayList<String> paths, int type) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        int n = 0;
        int n2 = ((Collection)paths).size();
        while (n < n2) {
            void index;
            this.add(paths.get((int)index), type);
            ++index;
        }
    }

    public final void remove(@NotNull String path, int type) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (type == 1 && selectedPhotos.contains(path)) {
            selectedPhotos.remove(path);
        } else if (type == 2) {
            selectedFiles.remove(path);
        }
    }

    public final boolean shouldAdd() {
        return maxCount == -1 ? true : this.getCurrentCount() < maxCount;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<String> getSelectedFilePaths(@NotNull ArrayList<BaseFile> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        ArrayList<String> paths = new ArrayList<String>();
        int n = 0;
        int n2 = ((Collection)files).size();
        while (n < n2) {
            void index;
            BaseFile baseFile = files.get((int)index);
            Intrinsics.checkExpressionValueIsNotNull((Object)baseFile, (String)"files[index]");
            paths.add(baseFile.getPath());
            ++index;
        }
        return paths;
    }

    public final void reset() {
        selectedFiles.clear();
        selectedPhotos.clear();
        fileTypes.clear();
        maxCount = -1;
    }

    public final void clearSelections() {
        selectedPhotos.clear();
        selectedFiles.clear();
    }

    public final void deleteMedia(@NotNull ArrayList<String> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        selectedPhotos.removeAll((Collection)paths);
    }

    public final boolean showVideo() {
        return showVideos;
    }

    public final void setShowVideos(boolean showVideos) {
        PickerManager.showVideos = showVideos;
    }

    public final boolean showImages() {
        return showImages;
    }

    public final void setShowImages(boolean showImages) {
        PickerManager.showImages = showImages;
    }

    public final void addFileType(@NotNull FileType fileType) {
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        fileTypes.add(fileType);
    }

    public final void addDocTypes() {
        String[] pdfs = new String[]{"pdf"};
        fileTypes.add(new FileType("PDF", pdfs, R.drawable.icon_file_pdf));
        String[] docs = new String[]{"doc", "docx", "dot", "dotx"};
        fileTypes.add(new FileType("DOC", docs, R.drawable.icon_file_doc));
        String[] ppts = new String[]{"ppt", "pptx"};
        fileTypes.add(new FileType("PPT", ppts, R.drawable.icon_file_ppt));
        String[] xlss = new String[]{"xls", "xlsx"};
        fileTypes.add(new FileType("XLS", xlss, R.drawable.icon_file_xls));
        String[] txts = new String[]{"txt"};
        fileTypes.add(new FileType("TXT", txts, R.drawable.icon_file_unknown));
    }

    @NotNull
    public final ArrayList<FileType> getFileTypes() {
        return new ArrayList<FileType>((Collection)fileTypes);
    }

    public final boolean hasSelectAll() {
        return maxCount == -1 && showSelectAll;
    }

    public final void enableSelectAll(boolean showSelectAll) {
        PickerManager.showSelectAll = showSelectAll;
    }

    private PickerManager() {
    }

    static {
        PickerManager pickerManager;
        INSTANCE = pickerManager = new PickerManager();
        maxCount = -1;
        showImages = true;
        cameraDrawable = R.drawable.ic_camera;
        sortingType = SortingTypes.none;
        selectedPhotos = new ArrayList();
        selectedFiles = new ArrayList();
        fileTypes = new LinkedHashSet();
        theme = R.style.LibAppTheme;
        isDocSupport = true;
        isEnableCamera = true;
        orientation = Orientation.UNSPECIFIED;
        isShowFolderView = true;
    }
}

