/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.BaseFilePickerActivity;
import droidninja.filepicker.MediaDetailsActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.PhotoGridAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.utils.MediaStoreHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0014J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0015J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0011H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0014J\b\u0010#\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u0013H\u0002J\u0016\u0010'\u001a\u00020\u00132\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0)H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldroidninja/filepicker/MediaDetailsActivity;", "Ldroidninja/filepicker/BaseFilePickerActivity;", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "()V", "emptyView", "Landroid/widget/TextView;", "fileType", "", "mGlideRequestManager", "Lcom/bumptech/glide/RequestManager;", "photoDirectory", "Ldroidninja/filepicker/models/PhotoDirectory;", "photoGridAdapter", "Ldroidninja/filepicker/adapters/PhotoGridAdapter;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "selectAllItem", "Landroid/view/MenuItem;", "getDataFromMedia", "", "bucketId", "", "initView", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onItemSelected", "onOptionsItemSelected", "item", "onResume", "resumeRequestsIfNotDestroyed", "setTitle", "count", "setUpView", "updateList", "dirs", "", "Companion", "filepicker_release"})
public final class MediaDetailsActivity
extends BaseFilePickerActivity
implements FileAdapterListener {
    private RecyclerView recyclerView;
    private TextView emptyView;
    private RequestManager mGlideRequestManager;
    private PhotoGridAdapter photoGridAdapter;
    private int fileType;
    private MenuItem selectAllItem;
    private PhotoDirectory photoDirectory;
    private static final int SCROLL_THRESHOLD = 30;
    public static final Companion Companion = new Companion(null);

    @SuppressLint(value={"MissingSuperCall"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, R.layout.activity_media_details);
    }

    @Override
    protected void initView() {
        RequestManager requestManager = Glide.with((FragmentActivity)((FragmentActivity)this));
        Intrinsics.checkExpressionValueIsNotNull((Object)requestManager, (String)"Glide.with(this)");
        this.mGlideRequestManager = requestManager;
        Intent intent = this.getIntent();
        if (intent != null) {
            this.fileType = intent.getIntExtra("EXTRA_FILE_TYPE", 1);
            this.photoDirectory = (PhotoDirectory)intent.getParcelableExtra(PhotoDirectory.class.getSimpleName());
            if (this.photoDirectory != null) {
                this.setUpView();
                this.setTitle(0);
            }
        }
    }

    public void setTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            int maxCount = PickerManager.INSTANCE.getMaxCount();
            if (maxCount == -1 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = this.getString(R.string.attachments_num);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.attachments_num)");
                String string3 = string2;
                Object[] objectArray = new Object[]{count};
                ActionBar actionBar2 = actionBar;
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
                String string5 = string4;
                actionBar2.setTitle((CharSequence)string5);
            } else if (maxCount > 0 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string6 = this.getString(R.string.attachments_title_text);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"getString(R.string.attachments_title_text)");
                String string7 = string6;
                Object[] objectArray = new Object[]{count, maxCount};
                ActionBar actionBar3 = actionBar;
                String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(format, *args)");
                String string9 = string8;
                actionBar3.setTitle((CharSequence)string9);
            } else {
                PhotoDirectory photoDirectory = this.photoDirectory;
                actionBar.setTitle((CharSequence)(photoDirectory != null ? photoDirectory.getName() : null));
            }
        }
    }

    private final void setUpView() {
        block2: {
            this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
            this.emptyView = (TextView)this.findViewById(R.id.empty_view);
            StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(3, 1);
            layoutManager.setGapStrategy(2);
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            }
            RecyclerView recyclerView2 = this.recyclerView;
            if (recyclerView2 != null) {
                recyclerView2.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
            }
            RecyclerView recyclerView3 = this.recyclerView;
            if (recyclerView3 == null) break block2;
            recyclerView3.addOnScrollListener(new RecyclerView.OnScrollListener(this){
                final /* synthetic */ MediaDetailsActivity this$0;

                public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    super.onScrolled(recyclerView, dx, dy);
                    if (Math.abs(dy) > MediaDetailsActivity.access$getSCROLL_THRESHOLD$cp()) {
                        MediaDetailsActivity.access$getMGlideRequestManager$p(this.this$0).pauseRequests();
                    } else {
                        MediaDetailsActivity.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }

                public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                    Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
                    if (newState == 0) {
                        MediaDetailsActivity.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    protected void onResume() {
        super.onResume();
        PhotoDirectory photoDirectory = this.photoDirectory;
        this.getDataFromMedia(photoDirectory != null ? photoDirectory.getBucketId() : null);
    }

    private final void getDataFromMedia(String bucketId) {
        Bundle mediaStoreArgs = new Bundle();
        mediaStoreArgs.putBoolean("SHOW_GIF", false);
        mediaStoreArgs.putString("EXTRA_BUCKET_ID", bucketId);
        mediaStoreArgs.putInt("EXTRA_FILE_TYPE", this.fileType);
        ContentResolver contentResolver = this.getContentResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"contentResolver");
        MediaStoreHelper.INSTANCE.getDirs(contentResolver, mediaStoreArgs, new FileResultCallback<PhotoDirectory>(this){
            final /* synthetic */ MediaDetailsActivity this$0;

            public void onResultCallback(@NotNull List<? extends PhotoDirectory> files) {
                Intrinsics.checkParameterIsNotNull(files, (String)"files");
                MediaDetailsActivity.access$updateList(this.this$0, CollectionsKt.toMutableList((Collection)files));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void updateList(List<PhotoDirectory> dirs) {
        ArrayList<Media> medias = new ArrayList<Media>();
        int n = 0;
        int n2 = ((Collection)dirs).size();
        while (n < n2) {
            void i;
            medias.addAll((Collection)dirs.get((int)i).getMedias());
            ++i;
        }
        CollectionsKt.sortWith((List)medias, (Comparator)updateList.1.INSTANCE);
        if (medias.size() > 0) {
            TextView textView = this.emptyView;
            if (textView != null) {
                textView.setVisibility(8);
            }
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setVisibility(0);
            }
        } else {
            TextView textView = this.emptyView;
            if (textView != null) {
                textView.setVisibility(0);
            }
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setVisibility(8);
            }
            return;
        }
        if (this.photoGridAdapter != null) {
            PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
            if (photoGridAdapter != null) {
                photoGridAdapter.setData((List)medias);
            }
            PhotoGridAdapter photoGridAdapter2 = this.photoGridAdapter;
            if (photoGridAdapter2 != null) {
                photoGridAdapter2.notifyDataSetChanged();
            }
        } else {
            Context context = (Context)this;
            RequestManager requestManager = this.mGlideRequestManager;
            if (requestManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
            }
            this.photoGridAdapter = new PhotoGridAdapter(context, requestManager, medias, PickerManager.INSTANCE.getSelectedPhotos(), false, this);
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            }
        }
        if (PickerManager.INSTANCE.getMaxCount() == -1) {
            if (this.photoGridAdapter != null && this.selectAllItem != null) {
                PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
                PhotoGridAdapter photoGridAdapter3 = this.photoGridAdapter;
                if (Intrinsics.areEqual((Object)(photoGridAdapter != null ? Integer.valueOf(photoGridAdapter.getItemCount()) : null), (Object)(photoGridAdapter3 != null ? Integer.valueOf(photoGridAdapter3.getSelectedItemCount()) : null))) {
                    MenuItem menuItem = this.selectAllItem;
                    if (menuItem != null) {
                        menuItem.setIcon(R.drawable.ic_select_all);
                    }
                    MenuItem menuItem2 = this.selectAllItem;
                    if (menuItem2 != null) {
                        menuItem2.setChecked(true);
                    }
                }
            }
            this.setTitle(PickerManager.INSTANCE.getCurrentCount());
        }
    }

    private final void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.INSTANCE.canLoadImage((Activity)this)) {
            return;
        }
        RequestManager requestManager = this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        requestManager.resumeRequests();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
            this.getMenuInflater().inflate(R.menu.media_detail_menu, menu2);
            MenuItem menuItem = this.selectAllItem = menu2.findItem(R.id.action_select);
            if (menuItem == null) break block0;
            menuItem.setVisible(PickerManager.INSTANCE.hasSelectAll());
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int itemId = item.getItemId();
        if (itemId == R.id.action_done) {
            this.setResult(-1, null);
            this.finish();
            return true;
        }
        if (itemId == R.id.action_select) {
            MenuItem menuItem = this.selectAllItem;
            if (menuItem != null) {
                MenuItem menuItem2;
                MenuItem it = menuItem2 = menuItem;
                PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
                if (photoGridAdapter != null) {
                    PhotoGridAdapter photoGridAdapter2;
                    PhotoGridAdapter adapter = photoGridAdapter2 = photoGridAdapter;
                    if (it.isChecked()) {
                        PickerManager.INSTANCE.deleteMedia(adapter.getSelectedPaths());
                        adapter.clearSelection();
                        it.setIcon(R.drawable.ic_deselect_all);
                    } else {
                        adapter.selectAll();
                        PickerManager.INSTANCE.add(adapter.getSelectedPaths(), 1);
                        it.setIcon(R.drawable.ic_select_all);
                    }
                    it.setChecked(!it.isChecked());
                    this.setTitle(PickerManager.INSTANCE.getCurrentCount());
                }
            }
            return true;
        }
        if (itemId == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemSelected() {
        int maxCount = PickerManager.INSTANCE.getMaxCount();
        if (maxCount == 1) {
            this.setResult(-1, null);
            this.finish();
        }
        this.setTitle(PickerManager.INSTANCE.getCurrentCount());
    }

    public void onBackPressed() {
        this.setResult(0, null);
        this.finish();
    }

    static {
        SCROLL_THRESHOLD = 30;
    }

    public static final /* synthetic */ int access$getSCROLL_THRESHOLD$cp() {
        return SCROLL_THRESHOLD;
    }

    @NotNull
    public static final /* synthetic */ RequestManager access$getMGlideRequestManager$p(MediaDetailsActivity $this) {
        RequestManager requestManager = $this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        return requestManager;
    }

    public static final /* synthetic */ void access$setMGlideRequestManager$p(MediaDetailsActivity $this, @NotNull RequestManager requestManager) {
        $this.mGlideRequestManager = requestManager;
    }

    public static final /* synthetic */ void access$resumeRequestsIfNotDestroyed(MediaDetailsActivity $this) {
        $this.resumeRequestsIfNotDestroyed();
    }

    public static final /* synthetic */ void access$updateList(MediaDetailsActivity $this, @NotNull List dirs) {
        $this.updateList(dirs);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldroidninja/filepicker/MediaDetailsActivity$Companion;", "", "()V", "SCROLL_THRESHOLD", "", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

