/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import droidninja.filepicker.FilePickerActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.models.FileType;
import droidninja.filepicker.models.sort.SortingTypes;
import droidninja.filepicker.utils.Orientation;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\nJ+\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\u000b\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fJ\u0014\u0010\"\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Ldroidninja/filepicker/FilePickerBuilder;", "", "()V", "mPickerOptionsBundle", "Landroid/os/Bundle;", "addFileSupport", "title", "", "extensions", "", "(Ljava/lang/String;[Ljava/lang/String;)Ldroidninja/filepicker/FilePickerBuilder;", "drawable", "", "(Ljava/lang/String;[Ljava/lang/String;I)Ldroidninja/filepicker/FilePickerBuilder;", "enableCameraSupport", "status", "", "enableDocSupport", "enableImagePicker", "enableSelectAll", "enableVideoPicker", "pickFile", "", "context", "Landroid/app/Activity;", "requestCode", "Landroidx/fragment/app/Fragment;", "pickPhoto", "setActivityTheme", "theme", "setActivityTitle", "setCameraPlaceholder", "setMaxCount", "maxCount", "setSelectedFiles", "selectedPhotos", "Ljava/util/ArrayList;", "showFolderView", "showGifs", "sortDocumentsBy", "type", "Ldroidninja/filepicker/models/sort/SortingTypes;", "start", "fragment", "withOrientation", "orientation", "Ldroidninja/filepicker/utils/Orientation;", "Companion", "filepicker_release"})
public final class FilePickerBuilder {
    private final Bundle mPickerOptionsBundle = new Bundle();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FilePickerBuilder setMaxCount(int maxCount) {
        PickerManager.INSTANCE.setMaxCount(maxCount);
        return this;
    }

    @NotNull
    public final FilePickerBuilder setActivityTheme(int theme) {
        PickerManager.INSTANCE.setTheme(theme);
        return this;
    }

    @NotNull
    public final FilePickerBuilder setActivityTitle(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        PickerManager.INSTANCE.setTitle(title);
        return this;
    }

    @NotNull
    public final FilePickerBuilder setSelectedFiles(@NotNull ArrayList<String> selectedPhotos) {
        Intrinsics.checkParameterIsNotNull(selectedPhotos, (String)"selectedPhotos");
        this.mPickerOptionsBundle.putStringArrayList("SELECTED_PHOTOS", selectedPhotos);
        return this;
    }

    @NotNull
    public final FilePickerBuilder enableVideoPicker(boolean status) {
        PickerManager.INSTANCE.setShowVideos(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder enableImagePicker(boolean status) {
        PickerManager.INSTANCE.setShowImages(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder enableSelectAll(boolean status) {
        PickerManager.INSTANCE.enableSelectAll(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder setCameraPlaceholder(@DrawableRes int drawable2) {
        PickerManager.INSTANCE.setCameraDrawable(drawable2);
        return this;
    }

    @NotNull
    public final FilePickerBuilder showGifs(boolean status) {
        PickerManager.INSTANCE.setShowGif(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder showFolderView(boolean status) {
        PickerManager.INSTANCE.setShowFolderView(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder enableDocSupport(boolean status) {
        PickerManager.INSTANCE.setDocSupport(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder enableCameraSupport(boolean status) {
        PickerManager.INSTANCE.setEnableCamera(status);
        return this;
    }

    @NotNull
    public final FilePickerBuilder withOrientation(@NotNull Orientation orientation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)orientation), (String)"orientation");
        PickerManager.INSTANCE.setOrientation(orientation);
        return this;
    }

    @NotNull
    public final FilePickerBuilder addFileSupport(@NotNull String title, @NotNull String[] extensions, @DrawableRes int drawable2) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)extensions, (String)"extensions");
        PickerManager.INSTANCE.addFileType(new FileType(title, extensions, drawable2));
        return this;
    }

    @NotNull
    public final FilePickerBuilder addFileSupport(@NotNull String title, @NotNull String[] extensions) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)extensions, (String)"extensions");
        PickerManager.INSTANCE.addFileType(new FileType(title, extensions, 0));
        return this;
    }

    @NotNull
    public final FilePickerBuilder sortDocumentsBy(@NotNull SortingTypes type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        PickerManager.INSTANCE.setSortingType(type);
        return this;
    }

    public final void pickPhoto(@NotNull Activity context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 233);
    }

    public final void pickPhoto(@NotNull Fragment context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 233);
    }

    public final void pickFile(@NotNull Activity context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 234);
    }

    public final void pickFile(@NotNull Fragment context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 234);
    }

    public final void pickPhoto(@NotNull Activity context, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, requestCode);
    }

    public final void pickPhoto(@NotNull Fragment context, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, requestCode);
    }

    public final void pickFile(@NotNull Activity context, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, requestCode);
    }

    public final void pickFile(@NotNull Fragment context, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, requestCode);
    }

    private final void start(Activity context, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)((Context)context), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            Toast.makeText((Context)((Context)context), (CharSequence)context.getResources().getString(R.string.permission_filepicker_rationale), (int)0).show();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        PickerManager.INSTANCE.setProviderAuthorities(stringBuilder.append(context2.getPackageName()).append(".droidninja.filepicker.provider").toString());
        Intent intent = new Intent((Context)context, FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        context.startActivityForResult(intent, requestCode);
    }

    private final void start(Fragment fragment, int requestCode) {
        block1: {
            Context context;
            Context context2 = fragment.getContext();
            if (context2 == null) break block1;
            Context it = context = context2;
            if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)it, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                Context context3 = fragment.getContext();
                Context context4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"it");
                Toast.makeText((Context)context3, (CharSequence)context4.getResources().getString(R.string.permission_filepicker_rationale), (int)0).show();
                return;
            }
            Context context5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)context5, (String)"it");
            Context context6 = context5.getApplicationContext();
            PickerManager.INSTANCE.setProviderAuthorities(Intrinsics.stringPlus((String)(context6 != null ? context6.getPackageName() : null), (Object)".droidninja.filepicker.provider"));
            Intent intent = new Intent((Context)fragment.getActivity(), FilePickerActivity.class);
            intent.putExtras(this.mPickerOptionsBundle);
            fragment.startActivityForResult(intent, requestCode);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldroidninja/filepicker/FilePickerBuilder$Companion;", "", "()V", "instance", "Ldroidninja/filepicker/FilePickerBuilder;", "getInstance", "()Ldroidninja/filepicker/FilePickerBuilder;", "filepicker_release"})
    public static final class Companion {
        @NotNull
        public final FilePickerBuilder getInstance() {
            return new FilePickerBuilder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

