/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.text.TextUtils;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.utils.FilePickerUtils;
import java.io.File;

public class FileUtils {
    public static FilePickerConst.FILE_TYPE getFileType(String path) {
        String fileExtension = FilePickerUtils.getFileExtension(new File(path));
        if (TextUtils.isEmpty((CharSequence)fileExtension)) {
            return FilePickerConst.FILE_TYPE.UNKNOWN;
        }
        if (FileUtils.isExcelFile(path)) {
            return FilePickerConst.FILE_TYPE.EXCEL;
        }
        if (FileUtils.isDocFile(path)) {
            return FilePickerConst.FILE_TYPE.WORD;
        }
        if (FileUtils.isPPTFile(path)) {
            return FilePickerConst.FILE_TYPE.PPT;
        }
        if (FileUtils.isPDFFile(path)) {
            return FilePickerConst.FILE_TYPE.PDF;
        }
        if (FileUtils.isTxtFile(path)) {
            return FilePickerConst.FILE_TYPE.TXT;
        }
        return FilePickerConst.FILE_TYPE.UNKNOWN;
    }

    public static boolean isExcelFile(String path) {
        String[] types = new String[]{"xls", "xlsx"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isDocFile(String path) {
        String[] types = new String[]{"doc", "docx", "dot", "dotx"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isPPTFile(String path) {
        String[] types = new String[]{"ppt", "pptx"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isPDFFile(String path) {
        String[] types = new String[]{"pdf"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isTxtFile(String path) {
        String[] types = new String[]{"txt"};
        return FilePickerUtils.contains(types, path);
    }
}

