/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.Media;
import java.util.ArrayList;
import java.util.List;

public class PhotoDirectory
extends BaseFile
implements Parcelable {
    private String bucketId;
    private String coverPath;
    private String name;
    private long dateAdded;
    private List<Media> medias = new ArrayList<Media>();
    public static final Parcelable.Creator<PhotoDirectory> CREATOR = new Parcelable.Creator<PhotoDirectory>(){

        public PhotoDirectory createFromParcel(Parcel in) {
            return new PhotoDirectory(in);
        }

        public PhotoDirectory[] newArray(int size) {
            return new PhotoDirectory[size];
        }
    };

    public PhotoDirectory() {
    }

    public PhotoDirectory(int id2, String name, String path) {
        super(id2, name, path);
    }

    protected PhotoDirectory(Parcel in) {
        this.bucketId = in.readString();
        this.coverPath = in.readString();
        this.name = in.readString();
        this.dateAdded = in.readLong();
    }

    @Override
    public boolean equals(Object o) {
        boolean otherHasId;
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhotoDirectory)) {
            return false;
        }
        PhotoDirectory directory = (PhotoDirectory)o;
        boolean hasId = !TextUtils.isEmpty((CharSequence)this.bucketId);
        boolean bl = otherHasId = !TextUtils.isEmpty((CharSequence)directory.bucketId);
        if (hasId && otherHasId) {
            if (!TextUtils.equals((CharSequence)this.bucketId, (CharSequence)directory.bucketId)) {
                return false;
            }
            return TextUtils.equals((CharSequence)this.name, (CharSequence)directory.name);
        }
        return false;
    }

    public int hashCode() {
        if (TextUtils.isEmpty((CharSequence)this.bucketId)) {
            if (TextUtils.isEmpty((CharSequence)this.name)) {
                return 0;
            }
            return this.name.hashCode();
        }
        int result = this.bucketId.hashCode();
        if (TextUtils.isEmpty((CharSequence)this.name)) {
            return result;
        }
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String getCoverPath() {
        if (this.medias != null && this.medias.size() > 0) {
            return this.medias.get(0).getPath();
        }
        if (this.coverPath != null) {
            return this.coverPath;
        }
        return "";
    }

    public void setCoverPath(String coverPath) {
        this.coverPath = coverPath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(long dateAdded) {
        this.dateAdded = dateAdded;
    }

    public List<Media> getMedias() {
        return this.medias;
    }

    public void setMedias(List<Media> medias) {
        this.medias = medias;
    }

    public List<String> getPhotoPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.medias.size());
        for (Media media : this.medias) {
            paths.add(media.getPath());
        }
        return paths;
    }

    public void addPhoto(int id2, String name, String path, int mediaType) {
        this.medias.add(new Media(id2, name, path, mediaType));
    }

    public void addPhoto(Media media) {
        this.medias.add(media);
    }

    public void addPhotos(List<Media> photosList) {
        this.medias.addAll(photosList);
    }

    public String getBucketId() {
        if (this.bucketId.equals("ALL_PHOTOS_BUCKET_ID")) {
            return null;
        }
        return this.bucketId;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.bucketId);
        parcel.writeString(this.coverPath);
        parcel.writeString(this.name);
        parcel.writeLong(this.dateAdded);
    }
}

