/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.FileListAdapter;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.models.FileType;
import java.util.List;

public class DocFragment
extends BaseFragment
implements FileAdapterListener {
    private static final String TAG = DocFragment.class.getSimpleName();
    RecyclerView recyclerView;
    TextView emptyView;
    private DocFragmentListener mListener;
    private MenuItem selectAllItem;
    private FileListAdapter fileListAdapter;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_photo_picker, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof DocFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (DocFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public static DocFragment newInstance(FileType fileType) {
        DocFragment photoPickerFragment = new DocFragment();
        Bundle bun = new Bundle();
        bun.putParcelable("FILE_TYPE", (Parcelable)fileType);
        photoPickerFragment.setArguments(bun);
        return photoPickerFragment;
    }

    public FileType getFileType() {
        return (FileType)this.getArguments().getParcelable("FILE_TYPE");
    }

    @Override
    public void onItemSelected() {
        this.mListener.onItemSelected();
        if (this.fileListAdapter != null && this.selectAllItem != null && this.fileListAdapter.getItemCount() == this.fileListAdapter.getSelectedItemCount()) {
            this.selectAllItem.setIcon(R.drawable.ic_select_all);
            this.selectAllItem.setChecked(true);
        }
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.recyclerView.setVisibility(8);
    }

    public void updateList(List<Document> dirs) {
        if (this.getView() == null) {
            return;
        }
        if (dirs.size() > 0) {
            this.recyclerView.setVisibility(0);
            this.emptyView.setVisibility(8);
            this.fileListAdapter = (FileListAdapter)this.recyclerView.getAdapter();
            if (this.fileListAdapter == null) {
                this.fileListAdapter = new FileListAdapter((Context)this.getActivity(), dirs, PickerManager.getInstance().getSelectedFiles(), this);
                this.recyclerView.setAdapter((RecyclerView.Adapter)this.fileListAdapter);
            } else {
                this.fileListAdapter.setData(dirs);
                this.fileListAdapter.notifyDataSetChanged();
            }
            this.onItemSelected();
        } else {
            this.recyclerView.setVisibility(8);
            this.emptyView.setVisibility(0);
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.doc_picker_menu, menu2);
        this.selectAllItem = menu2.findItem(R.id.action_select);
        if (PickerManager.getInstance().hasSelectAll()) {
            this.selectAllItem.setVisible(true);
            this.onItemSelected();
        } else {
            this.selectAllItem.setVisible(false);
        }
        MenuItem search = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)search.getActionView();
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                return false;
            }

            public boolean onQueryTextChange(String newText) {
                if (DocFragment.this.fileListAdapter != null) {
                    DocFragment.this.fileListAdapter.getFilter().filter((CharSequence)newText);
                }
                return true;
            }
        });
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.action_select) {
            if (this.fileListAdapter != null) {
                if (this.selectAllItem != null) {
                    if (this.selectAllItem.isChecked()) {
                        this.fileListAdapter.clearSelection();
                        PickerManager.getInstance().clearSelections();
                        this.selectAllItem.setIcon(R.drawable.ic_deselect_all);
                    } else {
                        this.fileListAdapter.selectAll();
                        PickerManager.getInstance().add(this.fileListAdapter.getSelectedPaths(), 2);
                        this.selectAllItem.setIcon(R.drawable.ic_select_all);
                    }
                }
                this.selectAllItem.setChecked(!this.selectAllItem.isChecked());
                this.mListener.onItemSelected();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public static interface DocFragmentListener {
        public void onItemSelected();
    }
}

