/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.SectionsPagerAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileMapResultCallback;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.fragments.DocFragment;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.models.FileType;
import droidninja.filepicker.utils.MediaStoreHelper;
import droidninja.filepicker.utils.TabLayoutHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DocPickerFragment
extends BaseFragment {
    private static final String TAG = DocPickerFragment.class.getSimpleName();
    TabLayout tabLayout;
    ViewPager viewPager;
    private ProgressBar progressBar;
    private DocPickerFragmentListener mListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_doc_picker, container, false);
    }

    public static DocPickerFragment newInstance() {
        DocPickerFragment docPickerFragment = new DocPickerFragment();
        return docPickerFragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof DocPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement DocPickerFragmentListener");
        }
        this.mListener = (DocPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.setViews(view);
        this.initView();
    }

    private void initView() {
        this.setUpViewPager();
        this.setData();
    }

    private void setViews(View view) {
        this.tabLayout = (TabLayout)view.findViewById(R.id.tabs);
        this.viewPager = (ViewPager)view.findViewById(R.id.viewPager);
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        this.tabLayout.setTabGravity(0);
        this.tabLayout.setTabMode(0);
    }

    private void setData() {
        MediaStoreHelper.getDocs(this.getActivity(), PickerManager.getInstance().getFileTypes(), PickerManager.getInstance().getSortingType().getComparator(), new FileMapResultCallback(){

            @Override
            public void onResultCallback(Map<FileType, List<Document>> files) {
                if (!DocPickerFragment.this.isAdded()) {
                    return;
                }
                DocPickerFragment.this.progressBar.setVisibility(8);
                DocPickerFragment.this.setDataOnFragments(files);
            }
        });
    }

    private void setDataOnFragments(Map<FileType, List<Document>> filesMap) {
        SectionsPagerAdapter sectionsPagerAdapter = (SectionsPagerAdapter)this.viewPager.getAdapter();
        if (sectionsPagerAdapter != null) {
            for (int index = 0; index < sectionsPagerAdapter.getCount(); ++index) {
                List<Document> filesFilteredByType;
                FileType fileType;
                DocFragment docFragment = (DocFragment)this.getChildFragmentManager().findFragmentByTag("android:switcher:" + R.id.viewPager + ":" + index);
                if (docFragment == null || (fileType = docFragment.getFileType()) == null || (filesFilteredByType = filesMap.get(fileType)) == null) continue;
                docFragment.updateList(filesFilteredByType);
            }
        }
    }

    private void setUpViewPager() {
        SectionsPagerAdapter adapter = new SectionsPagerAdapter(this.getChildFragmentManager());
        ArrayList<FileType> supportedTypes = PickerManager.getInstance().getFileTypes();
        for (int index = 0; index < supportedTypes.size(); ++index) {
            adapter.addFragment(DocFragment.newInstance(supportedTypes.get(index)), supportedTypes.get((int)index).title);
        }
        this.viewPager.setOffscreenPageLimit(supportedTypes.size());
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.tabLayout.setupWithViewPager(this.viewPager);
        TabLayoutHelper mTabLayoutHelper = new TabLayoutHelper(this.tabLayout, this.viewPager);
        mTabLayoutHelper.setAutoAdjustTabModeEnabled(true);
    }

    public static interface DocPickerFragmentListener {
    }
}

