/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.format.Formatter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.views.SmoothCheckBox;
import java.util.ArrayList;
import java.util.List;

public class FileListAdapter
extends SelectableAdapter<FileViewHolder, Document>
implements Filterable {
    private final Context context;
    private final FileAdapterListener mListener;
    private List<Document> mFilteredList;

    public FileListAdapter(Context context, List<Document> items, List<String> selectedPaths, FileAdapterListener fileAdapterListener) {
        super(items, selectedPaths);
        this.mFilteredList = items;
        this.context = context;
        this.mListener = fileAdapterListener;
    }

    public FileViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_doc_layout, parent, false);
        return new FileViewHolder(itemView);
    }

    public void onBindViewHolder(final FileViewHolder holder, int position) {
        final Document document = this.mFilteredList.get(position);
        int drawable2 = document.getFileType().getDrawable();
        holder.imageView.setImageResource(drawable2);
        if (drawable2 == R.drawable.icon_file_unknown || drawable2 == R.drawable.icon_file_pdf) {
            holder.fileTypeTv.setVisibility(0);
            holder.fileTypeTv.setText((CharSequence)document.getFileType().title);
        } else {
            holder.fileTypeTv.setVisibility(8);
        }
        holder.fileNameTextView.setText((CharSequence)document.getTitle());
        holder.fileSizeTextView.setText((CharSequence)Formatter.formatShortFileSize((Context)this.context, (long)Long.parseLong(document.getSize())));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FileListAdapter.this.onItemClicked(document, holder);
            }
        });
        holder.checkBox.setOnCheckedChangeListener(null);
        holder.checkBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FileListAdapter.this.onItemClicked(document, holder);
            }
        });
        holder.checkBox.setChecked(this.isSelected(document));
        holder.itemView.setBackgroundResource(this.isSelected(document) ? R.color.bg_gray : 17170443);
        holder.checkBox.setVisibility(this.isSelected(document) ? 0 : 8);
        holder.checkBox.setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(){

            @Override
            public void onCheckedChanged(SmoothCheckBox checkBox, boolean isChecked) {
                FileListAdapter.this.toggleSelection(document);
                holder.itemView.setBackgroundResource(isChecked ? R.color.bg_gray : 17170443);
            }
        });
    }

    private void onItemClicked(Document document, FileViewHolder holder) {
        if (PickerManager.getInstance().getMaxCount() == 1) {
            PickerManager.getInstance().add(document.getPath(), 2);
        } else if (holder.checkBox.isChecked()) {
            PickerManager.getInstance().remove(document.getPath(), 2);
            holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
            holder.checkBox.setVisibility(8);
        } else if (PickerManager.getInstance().shouldAdd()) {
            PickerManager.getInstance().add(document.getPath(), 2);
            holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
            holder.checkBox.setVisibility(0);
        }
        if (this.mListener != null) {
            this.mListener.onItemSelected();
        }
    }

    public int getItemCount() {
        return this.mFilteredList.size();
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence charSequence) {
                String charString = charSequence.toString();
                if (charString.isEmpty()) {
                    FileListAdapter.this.mFilteredList = FileListAdapter.this.getItems();
                } else {
                    ArrayList<Document> filteredList = new ArrayList<Document>();
                    for (Document document : FileListAdapter.this.getItems()) {
                        if (!document.getTitle().toLowerCase().contains(charString)) continue;
                        filteredList.add(document);
                    }
                    FileListAdapter.this.mFilteredList = filteredList;
                }
                Filter.FilterResults filterResults = new Filter.FilterResults();
                filterResults.values = FileListAdapter.this.mFilteredList;
                return filterResults;
            }

            protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
                FileListAdapter.this.mFilteredList = (ArrayList)filterResults.values;
                FileListAdapter.this.notifyDataSetChanged();
            }
        };
    }

    public static class FileViewHolder
    extends RecyclerView.ViewHolder {
        TextView fileTypeTv;
        SmoothCheckBox checkBox;
        ImageView imageView;
        TextView fileNameTextView;
        TextView fileSizeTextView;

        public FileViewHolder(View itemView) {
            super(itemView);
            this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.checkbox);
            this.imageView = (ImageView)itemView.findViewById(R.id.file_iv);
            this.fileNameTextView = (TextView)itemView.findViewById(R.id.file_name_tv);
            this.fileTypeTv = (TextView)itemView.findViewById(R.id.file_type_tv);
            this.fileSizeTextView = (TextView)itemView.findViewById(R.id.file_size_tv);
        }
    }
}

