/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.models;

import android.os.Parcel;
import android.os.Parcelable;
import droidninja.filepicker.utils.FilePickerUtils;

public class BaseFile
implements Parcelable {
    protected int id;
    protected String name;
    protected String path;
    public static final Parcelable.Creator<BaseFile> CREATOR = new Parcelable.Creator<BaseFile>(){

        public BaseFile createFromParcel(Parcel in) {
            return new BaseFile(in);
        }

        public BaseFile[] newArray(int size) {
            return new BaseFile[size];
        }
    };

    public BaseFile() {
    }

    public BaseFile(int id2, String name, String path) {
        this.id = id2;
        this.name = name;
        this.path = path;
    }

    protected BaseFile(Parcel in) {
        this.id = in.readInt();
        this.name = in.readString();
        this.path = in.readString();
    }

    public boolean isImage() {
        String[] types = new String[]{"jpg", "jpeg", "png", "gif"};
        return FilePickerUtils.contains(types, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseFile)) {
            return false;
        }
        BaseFile baseFile = (BaseFile)o;
        if (this.path != null && ((BaseFile)o).path != null) {
            return this.id == baseFile.id && this.path.equals(baseFile.path);
        }
        return this.id == baseFile.id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id2) {
        this.id = id2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeInt(this.id);
        parcel.writeString(this.name);
        parcel.writeString(this.path);
    }
}

