/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.SectionsPagerAdapter;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.fragments.MediaDetailPickerFragment;
import droidninja.filepicker.fragments.MediaFolderPickerFragment;

public class MediaPickerFragment
extends BaseFragment {
    TabLayout tabLayout;
    ViewPager viewPager;
    private MediaPickerFragmentListener mListener;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_media_picker, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof MediaPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement MediaPickerFragment");
        }
        this.mListener = (MediaPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static MediaPickerFragment newInstance() {
        MediaPickerFragment photoPickerFragment = new MediaPickerFragment();
        return photoPickerFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.tabLayout = (TabLayout)view.findViewById(R.id.tabs);
        this.viewPager = (ViewPager)view.findViewById(R.id.viewPager);
        this.tabLayout.setTabGravity(0);
        this.tabLayout.setTabMode(1);
        SectionsPagerAdapter adapter = new SectionsPagerAdapter(this.getChildFragmentManager());
        if (PickerManager.getInstance().showImages()) {
            if (PickerManager.getInstance().isShowFolderView()) {
                adapter.addFragment(MediaFolderPickerFragment.newInstance(1), this.getString(R.string.images));
            } else {
                adapter.addFragment(MediaDetailPickerFragment.newInstance(1), this.getString(R.string.images));
            }
        } else {
            this.tabLayout.setVisibility(8);
        }
        if (PickerManager.getInstance().showVideo()) {
            if (PickerManager.getInstance().isShowFolderView()) {
                adapter.addFragment(MediaFolderPickerFragment.newInstance(3), this.getString(R.string.videos));
            } else {
                adapter.addFragment(MediaDetailPickerFragment.newInstance(3), this.getString(R.string.videos));
            }
        } else {
            this.tabLayout.setVisibility(8);
        }
        this.viewPager.setAdapter((PagerAdapter)adapter);
        this.tabLayout.setupWithViewPager(this.viewPager);
    }

    public static interface MediaPickerFragmentListener {
    }
}

