/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.MediaDetailsActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FolderGridAdapter;
import droidninja.filepicker.cursors.loadercallbacks.FileResultCallback;
import droidninja.filepicker.fragments.BaseFragment;
import droidninja.filepicker.fragments.PhotoPickerFragmentListener;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.utils.GridSpacingItemDecoration;
import droidninja.filepicker.utils.ImageCaptureManager;
import droidninja.filepicker.utils.MediaStoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MediaFolderPickerFragment
extends BaseFragment
implements FolderGridAdapter.FolderGridAdapterListener {
    private static final String TAG = MediaFolderPickerFragment.class.getSimpleName();
    private static final int SCROLL_THRESHOLD = 30;
    RecyclerView recyclerView;
    TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private FolderGridAdapter photoGridAdapter;
    private ImageCaptureManager imageCaptureManager;
    private RequestManager mGlideRequestManager;
    private int fileType;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_media_folder_picker, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static MediaFolderPickerFragment newInstance(int fileType) {
        MediaFolderPickerFragment photoPickerFragment = new MediaFolderPickerFragment();
        Bundle bun = new Bundle();
        bun.putInt("FILE_TYPE", fileType);
        photoPickerFragment.setArguments(bun);
        return photoPickerFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mGlideRequestManager = Glide.with((Fragment)this);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
        this.fileType = this.getArguments().getInt("FILE_TYPE");
        this.imageCaptureManager = new ImageCaptureManager((Context)this.getActivity());
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this.getActivity(), 2);
        int spanCount = 2;
        int spacing = 5;
        boolean includeEdge = false;
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(spanCount, spacing, includeEdge));
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (Math.abs(dy) > 30) {
                    MediaFolderPickerFragment.this.mGlideRequestManager.pauseRequests();
                } else {
                    MediaFolderPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    MediaFolderPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }
        });
        this.getDataFromMedia();
    }

    private void getDataFromMedia() {
        Bundle mediaStoreArgs = new Bundle();
        mediaStoreArgs.putBoolean("SHOW_GIF", PickerManager.getInstance().isShowGif());
        mediaStoreArgs.putInt("EXTRA_FILE_TYPE", this.fileType);
        if (this.fileType == 1) {
            MediaStoreHelper.getPhotoDirs(this.getActivity(), mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

                @Override
                public void onResultCallback(List<PhotoDirectory> dirs) {
                    MediaFolderPickerFragment.this.updateList(dirs);
                }
            });
        } else if (this.fileType == 3) {
            MediaStoreHelper.getVideoDirs(this.getActivity(), mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

                @Override
                public void onResultCallback(List<PhotoDirectory> dirs) {
                    MediaFolderPickerFragment.this.updateList(dirs);
                }
            });
        }
    }

    private void updateList(List<PhotoDirectory> dirs) {
        Log.i((String)"updateList", (String)("" + dirs.size()));
        if (dirs.size() <= 0) {
            this.emptyView.setVisibility(0);
            this.recyclerView.setVisibility(8);
            return;
        }
        this.emptyView.setVisibility(8);
        this.recyclerView.setVisibility(0);
        PhotoDirectory photoDirectory = new PhotoDirectory();
        photoDirectory.setBucketId("ALL_PHOTOS_BUCKET_ID");
        if (this.fileType == 3) {
            photoDirectory.setName(this.getString(R.string.all_videos));
        } else if (this.fileType == 1) {
            photoDirectory.setName(this.getString(R.string.all_photos));
        } else {
            photoDirectory.setName(this.getString(R.string.all_files));
        }
        if (dirs.size() > 0 && dirs.get(0).getMedias().size() > 0) {
            photoDirectory.setDateAdded(dirs.get(0).getDateAdded());
            photoDirectory.setCoverPath(dirs.get(0).getMedias().get(0).getPath());
        }
        for (int i = 0; i < dirs.size(); ++i) {
            photoDirectory.addPhotos(dirs.get(i).getMedias());
        }
        dirs.add(0, photoDirectory);
        if (this.photoGridAdapter != null) {
            this.photoGridAdapter.setData(dirs);
            this.photoGridAdapter.notifyDataSetChanged();
        } else {
            this.photoGridAdapter = new FolderGridAdapter((Context)this.getActivity(), this.mGlideRequestManager, (ArrayList)dirs, null, this.fileType == 1 && PickerManager.getInstance().isEnableCamera());
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            this.photoGridAdapter.setFolderGridAdapterListener(this);
        }
    }

    @Override
    public void onCameraClicked() {
        try {
            Intent intent = this.imageCaptureManager.dispatchTakePictureIntent((Context)this.getActivity());
            if (intent != null) {
                this.startActivityForResult(intent, 257);
            } else {
                Toast.makeText((Context)this.getActivity(), (int)R.string.no_camera_exists, (int)0).show();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onFolderClicked(PhotoDirectory photoDirectory) {
        Intent intent = new Intent((Context)this.getActivity(), MediaDetailsActivity.class);
        intent.putExtra(PhotoDirectory.class.getSimpleName(), (Parcelable)photoDirectory);
        intent.putExtra("EXTRA_FILE_TYPE", this.fileType);
        this.getActivity().startActivityForResult(intent, 235);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 257: {
                if (resultCode != -1) break;
                String imagePath = this.imageCaptureManager.notifyMediaStoreDatabase();
                if (imagePath != null && PickerManager.getInstance().getMaxCount() == 1) {
                    PickerManager.getInstance().add(imagePath, 1);
                    this.mListener.onItemSelected();
                    break;
                }
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MediaFolderPickerFragment.this.getDataFromMedia();
                    }
                }, 1000L);
            }
        }
    }

    private void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.canLoadImage(this)) {
            return;
        }
        this.mGlideRequestManager.resumeRequests();
    }
}

