/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import java.io.File;
import java.util.ArrayList;

public class FolderGridAdapter
extends SelectableAdapter<PhotoViewHolder, PhotoDirectory> {
    private final Context context;
    private final RequestManager glide;
    private final boolean showCamera;
    private int imageSize;
    public static final int ITEM_TYPE_CAMERA = 100;
    public static final int ITEM_TYPE_PHOTO = 101;
    private FolderGridAdapterListener folderGridAdapterListener;

    public FolderGridAdapter(Context context, RequestManager requestManager, ArrayList<PhotoDirectory> photos, ArrayList<String> selectedPaths, boolean showCamera) {
        super(photos, selectedPaths);
        this.context = context;
        this.glide = requestManager;
        this.showCamera = showCamera;
        this.setColumnNumber(context, 3);
    }

    public PhotoViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_folder_layout, parent, false);
        return new PhotoViewHolder(itemView);
    }

    public int getItemViewType(int position) {
        if (this.showCamera) {
            return position == 0 ? 100 : 101;
        }
        return 101;
    }

    public void onBindViewHolder(PhotoViewHolder holder, int position) {
        if (this.getItemViewType(position) == 101) {
            final PhotoDirectory photoDirectory = (PhotoDirectory)this.getItems().get(this.showCamera ? position - 1 : position);
            if (AndroidLifecycleUtils.canLoadImage(holder.imageView.getContext())) {
                this.glide.load(new File(photoDirectory.getCoverPath())).apply(RequestOptions.centerCropTransform().override(this.imageSize, this.imageSize).placeholder(R.drawable.image_placeholder)).thumbnail(0.5f).into(holder.imageView);
            }
            holder.folderTitle.setText((CharSequence)photoDirectory.getName());
            holder.folderCount.setText((CharSequence)String.valueOf(photoDirectory.getMedias().size()));
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FolderGridAdapter.this.folderGridAdapterListener != null) {
                        FolderGridAdapter.this.folderGridAdapterListener.onFolderClicked(photoDirectory);
                    }
                }
            });
            holder.bottomOverlay.setVisibility(0);
        } else {
            holder.imageView.setImageResource(PickerManager.getInstance().getCameraDrawable());
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (FolderGridAdapter.this.folderGridAdapterListener != null) {
                        FolderGridAdapter.this.folderGridAdapterListener.onCameraClicked();
                    }
                }
            });
            holder.bottomOverlay.setVisibility(8);
        }
    }

    private void setColumnNumber(Context context, int columnNum) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        this.imageSize = widthPixels / columnNum;
    }

    public int getItemCount() {
        if (this.showCamera) {
            return this.getItems().size() + 1;
        }
        return this.getItems().size();
    }

    public void setFolderGridAdapterListener(FolderGridAdapterListener onClickListener) {
        this.folderGridAdapterListener = onClickListener;
    }

    public static class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        ImageView imageView;
        TextView folderTitle;
        TextView folderCount;
        View bottomOverlay;
        View selectBg;

        public PhotoViewHolder(View itemView) {
            super(itemView);
            this.imageView = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.folderTitle = (TextView)itemView.findViewById(R.id.folder_title);
            this.folderCount = (TextView)itemView.findViewById(R.id.folder_count);
            this.bottomOverlay = itemView.findViewById(R.id.bottomOverlay);
            this.selectBg = itemView.findViewById(R.id.transparent_bg);
        }
    }

    public static interface FolderGridAdapterListener {
        public void onCameraClicked();

        public void onFolderClicked(PhotoDirectory var1);
    }
}

